/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.emf.ui;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.ui.action.ValidateAction;

public class AdapterFactoryDiagnostician
extends Diagnostician {
    private final AdapterFactory adapterFactory;

    public AdapterFactoryDiagnostician(AdapterFactory adapterFactory) {
        this.adapterFactory = adapterFactory;
    }

    public AdapterFactoryDiagnostician(EValidator.Registry eValidatorRegistry, AdapterFactory adapterFactory) {
        super(eValidatorRegistry);
        this.adapterFactory = adapterFactory;
    }

    public String getObjectLabel(EObject eObject) {
        IItemLabelProvider itemLabelProvider = (IItemLabelProvider)this.adapterFactory.adapt((Notifier)eObject, IItemLabelProvider.class);
        if (itemLabelProvider != null) {
            return itemLabelProvider.getText((Object)eObject);
        }
        return super.getObjectLabel(eObject);
    }

    public Diagnostic validate(Resource resource, boolean createMarkers) {
        BasicDiagnostic resourceDiagnostic = new BasicDiagnostic("org.eclipse.emf.ecore", 0, "Diagnosis of " + String.valueOf(resource.getURI()), new Object[]{resource});
        for (EObject eObject : resource.getContents()) {
            Diagnostic eObjectDiagnostic = this.validate(eObject);
            resourceDiagnostic.addAll(eObjectDiagnostic);
        }
        if (createMarkers) {
            ValidateAction.EclipseResourcesUtil util = new ValidateAction.EclipseResourcesUtil();
            util.deleteMarkers((Object)resource);
            for (Diagnostic diagnostic : resourceDiagnostic.getChildren()) {
                util.createMarkers(resource, diagnostic);
            }
        }
        return resourceDiagnostic;
    }
}

