/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.core.internal;

import org.eclipse.core.commands.operations.IOperationApprover;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.gmf.runtime.common.core.internal.CommonCoreDebugOptions;
import org.eclipse.gmf.runtime.common.core.internal.command.FileModificationApprover;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class CommonCorePlugin
extends Plugin {
    protected static final String LOG_LISTENER_EXT_P_NAME = "logListeners";
    private static CommonCorePlugin plugin;

    public CommonCorePlugin() {
        plugin = this;
    }

    public static CommonCorePlugin getDefault() {
        return plugin;
    }

    public static String getPluginId() {
        return CommonCorePlugin.getDefault().getBundle().getSymbolicName();
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.configureLogListeners();
        FileModificationApprover approver = new FileModificationApprover();
        OperationHistoryFactory.getOperationHistory().addOperationApprover((IOperationApprover)approver);
    }

    private void configureLogListeners() {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = reg.getConfigurationElementsFor(CommonCorePlugin.getPluginId(), LOG_LISTENER_EXT_P_NAME);
        ILogListener listener = null;
        try {
            int i = 0;
            while (i < elements.length) {
                listener = (ILogListener)elements[i].createExecutableExtension("class");
                Platform.getLog((Bundle)CommonCorePlugin.getDefault().getBundle()).addLogListener(listener);
                ++i;
            }
        }
        catch (CoreException e) {
            Trace.catching(CommonCorePlugin.getDefault(), CommonCoreDebugOptions.EXCEPTIONS_CATCHING, ((Object)((Object)this)).getClass(), "configureLogListeners", e);
            Log.error(CommonCorePlugin.getDefault(), 5, e.getMessage());
        }
    }
}

