/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.stdlib;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEvaluationEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalParserUtil;
import org.eclipse.m2m.internal.qvt.oml.evaluator.ModuleInstance;
import org.eclipse.m2m.internal.qvt.oml.stdlib.AbstractQVTStdlib;
import org.eclipse.m2m.internal.qvt.oml.stdlib.CallHandler;
import org.eclipse.m2m.internal.qvt.oml.stdlib.CallHandlerAdapter;
import org.eclipse.ocl.ecore.EcoreEnvironment;
import org.eclipse.ocl.ecore.EcoreFactory;
import org.eclipse.ocl.expressions.ExpressionsFactory;
import org.eclipse.ocl.expressions.Variable;

public abstract class AbstractContextualOperations {
    protected static final CallHandler UNSUPPORTED_OPER = new CallHandler(){

        @Override
        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            throw new UnsupportedOperationException();
        }
    };
    private final EClassifier fContextType;
    private final AbstractQVTStdlib fLib;

    protected AbstractContextualOperations(AbstractQVTStdlib lib, EClassifier contextType) {
        if (lib == null || contextType == null) {
            throw new IllegalArgumentException();
        }
        this.fContextType = contextType;
        this.fLib = lib;
    }

    protected abstract OperationProvider[] getOperations();

    public AbstractQVTStdlib getStdlib() {
        return this.fLib;
    }

    public void define(EcoreEnvironment env) {
        OperationProvider[] operationProviderArray = this.getOperations();
        int n = operationProviderArray.length;
        int n2 = 0;
        while (n2 < n) {
            OperationProvider operation = operationProviderArray[n2];
            EOperation defOper = operation.define(env);
            if (operation.fIsStatic) {
                QvtOperationalParserUtil.markAsStaticOperation(defOper);
            }
            if (CallHandlerAdapter.getDispatcher(defOper) == UNSUPPORTED_OPER) {
                QvtOperationalParserUtil.markAsUnsupported((EModelElement)defOper, operation.fParamNames != null && operation.fParamNames.length > operation.fParamTypes.length ? operation.fParamNames[operation.fParamTypes.length] : null);
            }
            ++n2;
        }
    }

    protected OperationProvider createOwnedStaticOperationProvider(CallHandler dispatcher, String name, String[] parameterNames, EClassifier returnType, EClassifier ... paramTypes) {
        OwnedOperationProvider provider = new OwnedOperationProvider(dispatcher, name, parameterNames, returnType, paramTypes);
        provider.fIsStatic = true;
        return provider;
    }

    protected OperationProvider createStaticOperationProvider(CallHandler dispatcher, String name, String[] parameterNames, EClassifier returnType, EClassifier ... paramTypes) {
        OperationProvider provider = new OperationProvider(dispatcher, name, parameterNames, returnType, paramTypes);
        provider.fIsStatic = true;
        return provider;
    }

    protected class OperationProvider {
        protected final String fName;
        protected final String[] fParamNames;
        protected final EClassifier fReturnType;
        protected final EClassifier[] fParamTypes;
        protected final CallHandler fDispatcher;
        protected boolean fIsStatic;
        protected boolean fIsDeprecated;
        protected String fDeprecatedBy;

        protected OperationProvider(CallHandler dispatcher, String name, String[] paramNames, EClassifier returnType, EClassifier ... paramTypes) {
            this.fName = name;
            this.fReturnType = returnType;
            this.fParamTypes = paramTypes;
            this.fDispatcher = dispatcher;
            this.fIsStatic = false;
            if (paramNames != null && paramNames.length < paramTypes.length) {
                throw new IllegalArgumentException("Invalid number of parameter names");
            }
            this.fParamNames = paramNames;
        }

        protected OperationProvider(CallHandler dispatcher, String name, EClassifier returnType, EClassifier ... paramTypes) {
            this(dispatcher, name, (String[])null, returnType, paramTypes);
        }

        public OperationProvider deprecateBy(String deprecatingReplacement) {
            this.fIsDeprecated = true;
            this.fDeprecatedBy = deprecatingReplacement;
            return this;
        }

        public OperationProvider deprecate() {
            return this.deprecateBy(null);
        }

        public CallHandler callDispatcher() {
            return this.fDispatcher;
        }

        public OperationProvider implentBy(CallHandler dispatch) {
            return this;
        }

        public EOperation define(EcoreEnvironment env) {
            ArrayList<Variable> argList = new ArrayList<Variable>();
            int pos = 0;
            EClassifier[] eClassifierArray = this.fParamTypes;
            int n = this.fParamTypes.length;
            int n2 = 0;
            while (n2 < n) {
                EClassifier cls = eClassifierArray[n2];
                Variable stringVariable = ExpressionsFactory.eINSTANCE.createVariable();
                String paramName = cls.getName();
                if (this.fParamNames != null) {
                    paramName = this.fParamNames[pos++];
                }
                stringVariable.setName(paramName);
                stringVariable.setType((Object)cls);
                argList.add(stringVariable);
                ++n2;
            }
            EOperation result = env.defineOperation(AbstractContextualOperations.this.fContextType, this.fName, this.fReturnType, argList, EcoreFactory.eINSTANCE.createConstraint());
            CallHandlerAdapter.attach(result, this.fDispatcher);
            this.setupDeprecated(result);
            return result;
        }

        void setupDeprecated(EOperation result) {
            if (this.fIsDeprecated) {
                if (this.fDeprecatedBy != null) {
                    QvtOperationalParserUtil.markAsDeprecated((EModelElement)result, this.fDeprecatedBy);
                } else {
                    QvtOperationalParserUtil.markAsDeprecated((EModelElement)result);
                }
            }
        }

        public String toString() {
            return String.valueOf(this.fName) + (this.fParamNames != null ? Arrays.toString(this.fParamNames) : "");
        }
    }

    protected class OwnedOperationProvider
    extends OperationProvider {
        public OwnedOperationProvider(CallHandler dispatcher, String name, EClassifier returnType, EClassifier ... paramTypes) {
            super(dispatcher, name, returnType, paramTypes);
        }

        public OwnedOperationProvider(CallHandler dispatcher, String name, String[] parameterNames, EClassifier returnType, EClassifier ... paramTypes) {
            super(dispatcher, name, parameterNames, returnType, paramTypes);
        }

        @Override
        public EOperation define(EcoreEnvironment env) {
            EOperation eOperation = org.eclipse.emf.ecore.EcoreFactory.eINSTANCE.createEOperation();
            eOperation.setName(this.fName);
            int pos = 0;
            EClassifier[] eClassifierArray = this.fParamTypes;
            int n = this.fParamTypes.length;
            int n2 = 0;
            while (n2 < n) {
                EClassifier cls = eClassifierArray[n2];
                EParameter eParam = org.eclipse.emf.ecore.EcoreFactory.eINSTANCE.createEParameter();
                String paramName = cls.getName();
                if (this.fParamNames != null) {
                    paramName = this.fParamNames[pos++];
                }
                eParam.setName(paramName);
                eParam.setEType(cls);
                eOperation.getEParameters().add((Object)eParam);
                ++n2;
            }
            eOperation.setEType(this.fReturnType);
            assert (AbstractContextualOperations.this.fContextType instanceof EClass);
            ((EClass)AbstractContextualOperations.this.fContextType).getEOperations().add((Object)eOperation);
            CallHandlerAdapter.attach(eOperation, this.fDispatcher);
            this.setupDeprecated(eOperation);
            return eOperation;
        }
    }
}

