/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.bdd.conversion;

import com.github.javabdd.BDD;
import com.github.javabdd.BDDDomain;
import com.github.javabdd.BDDFactory;
import java.util.Arrays;
import org.eclipse.escet.cif.bdd.conversion.CifBddBitVectorAndCarry;
import org.eclipse.escet.common.java.Assert;

public class CifBddBitVector {
    private BDDFactory factory;
    private BDD[] bits;

    private CifBddBitVector(BDDFactory factory, int length) {
        if (length < 0) {
            throw new IllegalArgumentException("Length is negative.");
        }
        this.factory = factory;
        this.bits = new BDD[length];
    }

    public static CifBddBitVector create(BDDFactory factory, int length) {
        return CifBddBitVector.createBits(factory, length, false);
    }

    public static CifBddBitVector createBits(BDDFactory factory, int length, boolean value) {
        CifBddBitVector vector = new CifBddBitVector(factory, length);
        int i = 0;
        while (i < vector.bits.length) {
            vector.bits[i] = value ? factory.one() : factory.zero();
            ++i;
        }
        return vector;
    }

    public static CifBddBitVector createInt(BDDFactory factory, int value) {
        if (value < 0) {
            throw new IllegalArgumentException("Value is negative.");
        }
        int length = 0;
        int v = value;
        while (v > 0) {
            ++length;
            v >>= 1;
        }
        CifBddBitVector vector = new CifBddBitVector(factory, length);
        int i = 0;
        while (i < vector.bits.length) {
            vector.bits[i] = (value & 1) != 0 ? factory.one() : factory.zero();
            value >>= 1;
            ++i;
        }
        Assert.check((value == 0 ? 1 : 0) != 0);
        return vector;
    }

    public static CifBddBitVector createInt(BDDFactory factory, int length, int value) {
        if (length < 0) {
            throw new IllegalArgumentException("Length is negative.");
        }
        if (value < 0) {
            throw new IllegalArgumentException("Value is negative.");
        }
        CifBddBitVector vector = new CifBddBitVector(factory, length);
        int i = 0;
        while (i < vector.bits.length) {
            vector.bits[i] = (value & 1) != 0 ? factory.one() : factory.zero();
            value >>= 1;
            ++i;
        }
        return vector;
    }

    public static CifBddBitVector createDomain(BDDDomain domain) {
        CifBddBitVector vector = new CifBddBitVector(domain.getFactory(), domain.varNum());
        int[] vars = domain.vars();
        int i = 0;
        while (i < vars.length) {
            vector.bits[i] = vector.factory.ithVar(vars[i]);
            ++i;
        }
        return vector;
    }

    public CifBddBitVector copy() {
        CifBddBitVector vector = new CifBddBitVector(this.factory, this.bits.length);
        int i = 0;
        while (i < this.bits.length) {
            vector.bits[i] = this.bits[i].id();
            ++i;
        }
        return vector;
    }

    public void replaceBy(CifBddBitVector other) {
        this.free();
        this.factory = other.factory;
        this.bits = other.bits;
        other.factory = null;
        other.bits = null;
    }

    public int length() {
        return this.bits.length;
    }

    public int countInt() {
        if (this.bits.length > 30) {
            throw new IllegalStateException("More than 30 bits in vector.");
        }
        return 1 << this.bits.length;
    }

    public long countLong() {
        if (this.bits.length > 62) {
            throw new IllegalStateException("More than 62 bits in vector.");
        }
        return 1L << this.bits.length;
    }

    public BDD getBit(int index) {
        return this.bits[index];
    }

    public int getInt() {
        if (this.bits.length > 31) {
            throw new IllegalStateException("More than 31 bits in vector.");
        }
        int value = 0;
        int i = this.bits.length - 1;
        while (i >= 0) {
            if (this.bits[i].isOne()) {
                value = value << 1 | 1;
            } else if (this.bits[i].isZero()) {
                value <<= 1;
            } else {
                return -1;
            }
            --i;
        }
        return value;
    }

    public long getLong() {
        if (this.bits.length > 63) {
            throw new IllegalStateException("More than 63 bits in vector.");
        }
        long value = 0L;
        int i = this.bits.length - 1;
        while (i >= 0) {
            if (this.bits[i].isOne()) {
                value = value << 1 | 1L;
            } else if (this.bits[i].isZero()) {
                value <<= 1;
            } else {
                return -1L;
            }
            --i;
        }
        return value;
    }

    public void setBit(int idx, BDD bdd) {
        this.bits[idx].free();
        this.bits[idx] = bdd;
    }

    public void setBit(int idx, boolean value) {
        this.setBit(idx, value ? this.factory.one() : this.factory.zero());
    }

    public void setBits(boolean value) {
        int i = 0;
        while (i < this.bits.length) {
            this.bits[i].free();
            this.bits[i] = value ? this.factory.one() : this.factory.zero();
            ++i;
        }
    }

    public void setInt(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("Value is negative.");
        }
        int i = 0;
        while (i < this.bits.length) {
            this.bits[i].free();
            this.bits[i] = (value & 1) != 0 ? this.factory.one() : this.factory.zero();
            value >>= 1;
            ++i;
        }
        if (value > 0) {
            throw new IllegalArgumentException("Value doesn't fit.");
        }
    }

    public void setDomain(BDDDomain domain) {
        int[] vars = domain.vars();
        int cnt = Math.min(vars.length, this.bits.length);
        int i = 0;
        while (i < cnt) {
            this.bits[i].free();
            this.bits[i] = this.factory.ithVar(vars[i]);
            ++i;
        }
        i = cnt;
        while (i < this.bits.length) {
            this.bits[i].free();
            this.bits[i] = this.factory.zero();
            ++i;
        }
    }

    public void resize(int length) {
        if (length == this.bits.length) {
            return;
        }
        if (length < 0) {
            throw new IllegalArgumentException("Length is negative.");
        }
        BDD[] newBits = new BDD[length];
        int min = Math.min(this.bits.length, length);
        System.arraycopy(this.bits, 0, newBits, 0, min);
        int i = min;
        while (i < length) {
            newBits[i] = this.factory.zero();
            ++i;
        }
        i = min;
        while (i < this.bits.length) {
            this.bits[i].free();
            ++i;
        }
        this.bits = newBits;
    }

    public CifBddBitVectorAndCarry add(CifBddBitVector other) {
        if (this.bits.length != other.bits.length) {
            throw new IllegalArgumentException("Different lengths.");
        }
        CifBddBitVector rslt = new CifBddBitVector(this.factory, this.bits.length);
        BDD carry = this.factory.zero();
        int i = 0;
        while (i < this.bits.length) {
            rslt.bits[i] = this.bits[i].xor(other.bits[i]).xorWith(carry.id());
            carry = this.bits[i].and(other.bits[i]).orWith(carry.andWith(this.bits[i].or(other.bits[i])));
            ++i;
        }
        return new CifBddBitVectorAndCarry(rslt, carry);
    }

    public CifBddBitVectorAndCarry subtract(CifBddBitVector other) {
        if (this.bits.length != other.bits.length) {
            throw new IllegalArgumentException("Different lengths.");
        }
        CifBddBitVector rslt = new CifBddBitVector(this.factory, this.bits.length);
        BDD carry = this.factory.zero();
        int i = 0;
        while (i < this.bits.length) {
            rslt.bits[i] = this.bits[i].xor(other.bits[i]).xorWith(carry.id());
            BDD tmp1 = other.bits[i].or(carry);
            BDD tmp2 = this.bits[i].apply(tmp1, BDDFactory.less);
            tmp1.free();
            carry = this.bits[i].and(other.bits[i]).andWith(carry).orWith(tmp2);
            ++i;
        }
        return new CifBddBitVectorAndCarry(rslt, carry);
    }

    public CifBddBitVector div(int value) {
        return this.divmod(value, true);
    }

    public CifBddBitVector mod(int value) {
        return this.divmod(value, false);
    }

    public CifBddBitVector divmod(int value, boolean isDiv) {
        if (value <= 0) {
            throw new IllegalArgumentException("Divisor is not positive.");
        }
        if (!(isDiv || this.bits.length != 0 && this.bits[this.bits.length - 1].isZero())) {
            throw new IllegalStateException("Highest bit is not false.");
        }
        CifBddBitVector divisor = CifBddBitVector.create(this.factory, this.bits.length);
        try {
            divisor.setInt(value);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("Divisor doesn't fit.");
        }
        CifBddBitVector tmp = CifBddBitVector.createBits(this.factory, this.bits.length, false);
        CifBddBitVector tmpRemainder = tmp.shiftLeft(1, this.bits[this.bits.length - 1]);
        CifBddBitVector result = this.shiftLeft(1, this.factory.zero());
        this.divModRecursive(divisor, tmpRemainder, result, this.bits.length);
        divisor.free();
        tmp.free();
        if (isDiv) {
            tmpRemainder.free();
            return result;
        }
        CifBddBitVector remainder = tmpRemainder.shiftRight(1, this.factory.zero());
        tmpRemainder.free();
        result.free();
        return remainder;
    }

    private void divModRecursive(CifBddBitVector divisor, CifBddBitVector remainder, CifBddBitVector result, int step) {
        int divLen = divisor.bits.length;
        BDD isSmaller = divisor.lessOrEqual(remainder);
        CifBddBitVector newResult = result.shiftLeft(1, isSmaller);
        CifBddBitVector sub = CifBddBitVector.create(this.factory, divLen);
        int i = 0;
        while (i < divLen) {
            sub.bits[i] = isSmaller.ite(divisor.bits[i], this.factory.zero());
            ++i;
        }
        CifBddBitVectorAndCarry tmp = remainder.subtract(sub);
        CifBddBitVector newRemainder = tmp.vector.shiftLeft(1, result.bits[divLen - 1]);
        if (step > 1) {
            this.divModRecursive(divisor, newRemainder, newResult, step - 1);
        }
        tmp.vector.free();
        tmp.carry.free();
        sub.free();
        isSmaller.free();
        result.replaceBy(newResult);
        remainder.replaceBy(newRemainder);
    }

    public CifBddBitVector shiftLeft(int amount, BDD carry) {
        if (amount < 0) {
            throw new IllegalArgumentException("Amount is negative.");
        }
        CifBddBitVector result = new CifBddBitVector(this.factory, this.bits.length);
        int min = Math.min(this.bits.length, amount);
        int i = 0;
        while (i < min) {
            result.bits[i] = carry.id();
            ++i;
        }
        i = min;
        while (i < this.bits.length) {
            result.bits[i] = this.bits[i - amount].id();
            ++i;
        }
        return result;
    }

    public CifBddBitVector shiftRight(int amount, BDD carry) {
        int max;
        if (amount < 0) {
            throw new IllegalArgumentException("Amount is negative.");
        }
        CifBddBitVector result = new CifBddBitVector(this.factory, this.bits.length);
        int i = max = Math.max(0, this.bits.length - amount);
        while (i < this.bits.length) {
            result.bits[i] = carry.id();
            ++i;
        }
        i = 0;
        while (i < max) {
            result.bits[i] = this.bits[i + amount].id();
            ++i;
        }
        return result;
    }

    public CifBddBitVector ifThenElse(CifBddBitVector elseVector, BDD condition) {
        if (this.bits.length != elseVector.bits.length) {
            throw new IllegalArgumentException("Different lengths.");
        }
        CifBddBitVector rslt = new CifBddBitVector(this.factory, this.bits.length);
        int i = 0;
        while (i < this.bits.length) {
            rslt.bits[i] = condition.ite(this.getBit(i), elseVector.getBit(i));
            ++i;
        }
        return rslt;
    }

    public BDD lessThan(CifBddBitVector other) {
        if (this.bits.length != other.bits.length) {
            throw new IllegalArgumentException("Different lengths.");
        }
        BDD rslt = this.factory.zero();
        int i = 0;
        while (i < this.bits.length) {
            BDD lt = this.bits[i].apply(other.bits[i], BDDFactory.less);
            BDD eq = this.bits[i].biimp(other.bits[i]);
            rslt = lt.orWith(eq.andWith(rslt));
            ++i;
        }
        return rslt;
    }

    public BDD lessOrEqual(CifBddBitVector other) {
        if (this.bits.length != other.bits.length) {
            throw new IllegalArgumentException("Different lengths.");
        }
        BDD rslt = this.factory.one();
        int i = 0;
        while (i < this.bits.length) {
            BDD lt = this.bits[i].apply(other.bits[i], BDDFactory.less);
            BDD eq = this.bits[i].biimp(other.bits[i]);
            rslt = lt.orWith(eq.andWith(rslt));
            ++i;
        }
        return rslt;
    }

    public BDD greaterThan(CifBddBitVector other) {
        BDD le = this.lessOrEqual(other);
        BDD gt = le.not();
        le.free();
        return gt;
    }

    public BDD greaterOrEqual(CifBddBitVector other) {
        BDD lt = this.lessThan(other);
        BDD ge = lt.not();
        lt.free();
        return ge;
    }

    public BDD equalTo(CifBddBitVector other) {
        if (this.bits.length != other.bits.length) {
            throw new IllegalArgumentException("Different lengths.");
        }
        BDD eq = this.factory.one();
        int i = 0;
        while (i < this.bits.length) {
            BDD bit = this.bits[i].biimp(other.bits[i]);
            eq = eq.andWith(bit);
            ++i;
        }
        return eq;
    }

    public BDD unequalTo(CifBddBitVector other) {
        BDD eq = this.equalTo(other);
        BDD uneq = eq.not();
        eq.free();
        return uneq;
    }

    public void free() {
        int i = 0;
        while (i < this.bits.length) {
            this.bits[i].free();
            ++i;
        }
        this.factory = null;
        this.bits = null;
    }

    public String toString() {
        if (this.bits == null) {
            return "freed";
        }
        return Arrays.toString(this.bits);
    }
}

