/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.context.tck.contexts.priority.spi;

import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.microprofile.context.spi.ThreadContextController;
import org.eclipse.microprofile.context.spi.ThreadContextSnapshot;

public class ThreadPrioritySnapshot
implements ThreadContextSnapshot {
    private final int priority;

    ThreadPrioritySnapshot(int priority) {
        this.priority = priority;
    }

    public ThreadContextController begin() {
        Thread thread = Thread.currentThread();
        int priorityToRestore = thread.getPriority();
        AtomicBoolean restored = new AtomicBoolean();
        ThreadContextController contextRestorer = () -> {
            if (!restored.compareAndSet(false, true)) {
                throw new IllegalStateException();
            }
            thread.setPriority(priorityToRestore);
        };
        thread.setPriority(this.priority);
        return contextRestorer;
    }

    public String toString() {
        return "ThreadPrioritySnapshot@" + Integer.toHexString(System.identityHashCode(this)) + ": " + this.priority;
    }
}

