/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.context.tck;

import java.lang.reflect.Method;
import org.eclipse.microprofile.context.spi.ContextManager;
import org.eclipse.microprofile.context.spi.ContextManagerProvider;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.ITestResult;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ContextManagerTest
extends Arquillian {
    @AfterMethod
    public void afterMethod(Method m, ITestResult result) {
        System.out.println("<<< END " + m.getClass().getSimpleName() + '.' + m.getName() + (result.isSuccess() ? " SUCCESS" : " FAILED"));
        Throwable failure = result.getThrowable();
        if (failure != null) {
            failure.printStackTrace(System.out);
        }
    }

    @BeforeMethod
    public void beforeMethod(Method m) {
        System.out.println(">>> BEGIN " + m.getClass().getSimpleName() + '.' + m.getName());
    }

    @Deployment
    public static WebArchive createDeployment() {
        return (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)(ContextManagerTest.class.getSimpleName() + ".war"))).addClass(ContextManagerTest.class);
    }

    @Test
    public void builderForContextManagerIsProvided() {
        ContextManagerProvider provider = ContextManagerProvider.instance();
        ClassLoader classLoader = ContextManagerTest.class.getClassLoader();
        ContextManager.Builder contextManagerBuilder = null;
        try {
            contextManagerBuilder = provider.getContextManagerBuilder();
            Assert.assertNotNull((Object)contextManagerBuilder, (String)"MicroProfile Context Propagation implementation does not provide a ContextManager builder.");
        }
        catch (UnsupportedOperationException ex1) {
            System.out.println("ContextManagerProvider.getContextManagerBuilder is not supported.");
            try {
                provider.registerContextManager(provider.getContextManager(), classLoader);
                Assert.fail((String)"ContextManagerProvider.registerContextManager should not be supported, if ContextManagerProvider.getContextManagerBuilder is not supported.");
            }
            catch (UnsupportedOperationException ex2) {
                System.out.println("ContextManagerProvider.registerContextManager is not supported.");
            }
            try {
                provider.releaseContextManager(provider.getContextManager());
                Assert.fail((String)"ContextManagerProvider.releaseContextManager should not be supported, if ContextManagerProvider.getContextManagerBuilder is not supported.");
            }
            catch (UnsupportedOperationException ex3) {
                System.out.println("ContextManagerProvider.releaseContextManager is not supported.");
            }
            return;
        }
        ContextManager builtManager = contextManagerBuilder.build();
        provider.registerContextManager(builtManager, classLoader);
        ContextManager registeredManager = provider.getContextManager(classLoader);
        Assert.assertEquals((Object)builtManager, (Object)registeredManager, (String)"ContextManagerProvider.getContextManager(classLoader) did not return the same manager that was registered.");
        provider.releaseContextManager(registeredManager);
        Assert.assertNotEquals((Object)builtManager, (Object)provider.getContextManager(classLoader), (String)"ContextManager was not released from the ContextManagerProvider.");
    }
}

