/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.bulkhead;

import java.time.Duration;
import java.util.ArrayList;
import java.util.concurrent.Future;
import java.util.function.Function;
import javax.inject.Inject;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.BulkheadAsynchTest;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.Bulkhead33RetryManyAsyncClassBean;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.Bulkhead33RetryManyAsyncMethodBean;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.Bulkhead55RapidRetry10ClassAsynchBean;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.Bulkhead55RapidRetry10MethodAsynchBean;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.BulkheadRetryAbortOnAsyncBean;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.BulkheadRetryDelayAsyncBean;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.BulkheadRetryQueueAsyncBean;
import org.eclipse.microprofile.fault.tolerance.tck.config.ConfigAnnotationAsset;
import org.eclipse.microprofile.fault.tolerance.tck.util.AsyncTaskManager;
import org.eclipse.microprofile.fault.tolerance.tck.util.Barrier;
import org.eclipse.microprofile.fault.tolerance.tck.util.Packages;
import org.eclipse.microprofile.fault.tolerance.tck.util.TCKConfig;
import org.eclipse.microprofile.fault.tolerance.tck.util.TestException;
import org.eclipse.microprofile.faulttolerance.exceptions.BulkheadException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.annotations.Test;

public class BulkheadAsynchRetryTest
extends Arquillian {
    @Inject
    private Bulkhead33RetryManyAsyncClassBean retryManyClassBean;
    @Inject
    private Bulkhead33RetryManyAsyncMethodBean retryManyMethodBean;
    @Inject
    private Bulkhead55RapidRetry10ClassAsynchBean rrClassBean;
    @Inject
    private Bulkhead55RapidRetry10MethodAsynchBean rrMethodBean;
    @Inject
    private BulkheadRetryDelayAsyncBean retryDelayAsyncBean;
    @Inject
    private BulkheadRetryQueueAsyncBean retryQueueAsyncBean;
    @Inject
    private BulkheadRetryAbortOnAsyncBean retryAbortOnAsyncBean;

    @Deployment
    public static WebArchive deploy() {
        ConfigAnnotationAsset config = new ConfigAnnotationAsset().autoscaleClass(Bulkhead33RetryManyAsyncClassBean.class).autoscaleMethod(Bulkhead33RetryManyAsyncMethodBean.class, "test").autoscaleClass(BulkheadRetryDelayAsyncBean.class).autoscaleClass(BulkheadRetryQueueAsyncBean.class).autoscaleClass(BulkheadRetryAbortOnAsyncBean.class);
        JavaArchive testJar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"ftBulkheadAsynchRetryTest.jar")).addClass(BulkheadAsynchTest.class)).addPackage(Bulkhead33RetryManyAsyncClassBean.class.getPackage())).addPackage(Packages.UTILS)).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml")).addAsManifestResource((Asset)config, "microprofile-config.properties");
        return (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ftBulkheadAsynchRetryTest.war")).addAsLibrary((Archive)testJar);
    }

    @Test
    public void testBulkheadExceptionThrownClassAsync() {
        BulkheadAsynchTest.testBulkhead(5, 5, this.rrClassBean::test);
    }

    @Test
    public void testBulkheadExceptionThrownMethodAsync() {
        BulkheadAsynchTest.testBulkhead(5, 5, this.rrMethodBean::test);
    }

    @Test
    public void testBulkheadExceptionRetriedMethodAsync() {
        BulkheadAsynchRetryTest.testBulkheadExceptionRetried(3, 3, this.retryManyMethodBean::test);
    }

    @Test
    public void testBulkheadExceptionRetriedClassAsync() {
        BulkheadAsynchRetryTest.testBulkheadExceptionRetried(3, 3, this.retryManyClassBean::test);
    }

    private static void testBulkheadExceptionRetried(int maxRunning, int maxQueued, Function<Barrier, Future<?>> bulkheadMethod) {
        try (AsyncTaskManager taskManager = new AsyncTaskManager();){
            int i;
            ArrayList runningTasks = new ArrayList();
            for (i = 0; i < maxRunning; ++i) {
                AsyncTaskManager.BarrierTask task = taskManager.runAsyncBarrierTask(bulkheadMethod);
                runningTasks.add(task);
            }
            for (i = 0; i < maxRunning; ++i) {
                ((AsyncTaskManager.BarrierTask)runningTasks.get(i)).assertAwaits();
            }
            ArrayList queuedTasks = new ArrayList();
            for (int i2 = 0; i2 < maxQueued; ++i2) {
                AsyncTaskManager.BarrierTask task = taskManager.runAsyncBarrierTask(bulkheadMethod);
                queuedTasks.add(task);
            }
            AsyncTaskManager.assertAllNotAwaiting(queuedTasks);
            AsyncTaskManager.BarrierTask overflowTask = taskManager.runAsyncBarrierTask(bulkheadMethod);
            overflowTask.assertNotAwaiting();
            runningTasks.forEach(AsyncTaskManager.BarrierTask::openBarrier);
            queuedTasks.forEach(AsyncTaskManager.BarrierTask::openBarrier);
            overflowTask.assertAwaits();
            overflowTask.openBarrier();
            overflowTask.assertCompletes();
        }
    }

    @Test
    public void testRetriesReenterBulkhead() {
        try (AsyncTaskManager taskManager = new AsyncTaskManager();){
            AsyncTaskManager.BarrierTask taskA = taskManager.runAsyncBarrierTask(barrier -> this.retryDelayAsyncBean.test((Barrier)barrier, new TestException()));
            taskA.assertAwaits();
            AsyncTaskManager.BarrierTask taskB = taskManager.runAsyncBarrierTask(barrier -> this.retryDelayAsyncBean.test((Barrier)barrier, null));
            taskB.assertNotAwaiting();
            taskA.openBarrier();
            taskB.assertAwaits();
            AsyncTaskManager.BarrierTask taskC = taskManager.runAsyncBarrierTask(barrier -> this.retryDelayAsyncBean.test((Barrier)barrier, null));
            taskC.assertNotAwaiting();
            taskA.assertThrows(BulkheadException.class);
            taskB.openBarrier();
            taskB.assertSuccess();
            taskC.openBarrier();
            taskC.assertSuccess();
        }
    }

    @Test
    public void testRetriesJoinBackOfQueue() {
        try (AsyncTaskManager taskManager = new AsyncTaskManager();){
            AsyncTaskManager.BarrierTask taskA = taskManager.runAsyncBarrierTask(barrier -> this.retryQueueAsyncBean.test((Barrier)barrier, new TestException()));
            taskA.assertAwaits();
            AsyncTaskManager.BarrierTask taskB = taskManager.runAsyncBarrierTask(barrier -> this.retryQueueAsyncBean.test((Barrier)barrier, null));
            taskB.assertNotAwaiting();
            AsyncTaskManager.BarrierTask taskC = taskManager.runAsyncBarrierTask(barrier -> this.retryQueueAsyncBean.test((Barrier)barrier, null));
            taskC.assertNotAwaiting();
            taskA.openBarrier();
            taskB.assertAwaits();
            taskC.assertNotAwaiting();
            taskA.assertNotCompleting();
            taskB.openBarrier();
            taskB.assertSuccess();
            taskC.assertAwaits();
            taskA.assertNotCompleting();
            taskC.openBarrier();
            taskC.assertSuccess();
            taskA.assertThrows(TestException.class);
        }
    }

    @Test
    public void testNoRetriesWithoutRetryOn() throws InterruptedException {
        try (AsyncTaskManager taskManager = new AsyncTaskManager();){
            AsyncTaskManager.BarrierTask taskA = taskManager.runAsyncBarrierTask(barrier -> this.retryDelayAsyncBean.test((Barrier)barrier, null));
            taskA.assertAwaits();
            AsyncTaskManager.BarrierTask taskB = taskManager.runAsyncBarrierTask(barrier -> this.retryDelayAsyncBean.test((Barrier)barrier, null));
            taskB.assertNotAwaiting();
            long startTime = System.nanoTime();
            AsyncTaskManager.BarrierTask taskC = taskManager.runAsyncBarrierTask(barrier -> this.retryDelayAsyncBean.test((Barrier)barrier, null));
            taskC.assertThrows(BulkheadException.class);
            long endTime = System.nanoTime();
            MatcherAssert.assertThat((String)"Task took to long to return, may have done retries", (Object)Duration.ofNanos(endTime - startTime), (Matcher)Matchers.lessThan((Comparable)TCKConfig.getConfig().getTimeoutInDuration(800)));
        }
    }

    @Test
    public void testNoRetriesWithAbortOn() throws InterruptedException {
        try (AsyncTaskManager taskManager = new AsyncTaskManager();){
            AsyncTaskManager.BarrierTask taskA = taskManager.runAsyncBarrierTask(this.retryAbortOnAsyncBean::test);
            taskA.assertAwaits();
            AsyncTaskManager.BarrierTask taskB = taskManager.runAsyncBarrierTask(this.retryAbortOnAsyncBean::test);
            taskB.assertNotAwaiting();
            long startTime = System.nanoTime();
            AsyncTaskManager.BarrierTask taskC = taskManager.runAsyncBarrierTask(this.retryAbortOnAsyncBean::test);
            taskC.assertThrows(BulkheadException.class);
            long endTime = System.nanoTime();
            MatcherAssert.assertThat((String)"Task took to long to return, may have done retries", (Object)Duration.ofNanos(endTime - startTime), (Matcher)Matchers.lessThan((Comparable)TCKConfig.getConfig().getTimeoutInDuration(800)));
        }
    }
}

