/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.metrics;

import java.time.Duration;
import javax.inject.Inject;
import org.eclipse.microprofile.fault.tolerance.tck.config.ConfigAnnotationAsset;
import org.eclipse.microprofile.fault.tolerance.tck.metrics.RetryMetricBean;
import org.eclipse.microprofile.fault.tolerance.tck.metrics.util.MetricDefinition;
import org.eclipse.microprofile.fault.tolerance.tck.metrics.util.MetricGetter;
import org.eclipse.microprofile.fault.tolerance.tck.util.Exceptions;
import org.eclipse.microprofile.fault.tolerance.tck.util.Packages;
import org.eclipse.microprofile.fault.tolerance.tck.util.TCKConfig;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class RetryMetricTest
extends Arquillian {
    @Inject
    private RetryMetricBean retryBean;

    @Deployment
    public static WebArchive deploy() {
        ConfigAnnotationAsset config = new ConfigAnnotationAsset().autoscaleMethod(RetryMetricBean.class, "failAfterDelay");
        JavaArchive jar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"ftMetricRetry.jar")).addClasses(new Class[]{RetryMetricBean.class})).addPackage(Packages.UTILS)).addPackage(Packages.METRIC_UTILS)).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml")).addAsManifestResource((Asset)config, "microprofile-config.properties");
        WebArchive war = (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ftMetricRetry.war")).addAsLibrary((Archive)jar);
        return war;
    }

    @Test
    public void testRetryMetricSuccessfulImmediately() {
        MetricGetter m = new MetricGetter(RetryMetricBean.class, "failSeveralTimes");
        m.baselineMetrics();
        this.retryBean.failSeveralTimes(0, new RetryMetricBean.CallCounter());
        this.assertRetryCallsIncremented(m, MetricDefinition.RetryRetried.FALSE, MetricDefinition.RetryResult.VALUE_RETURNED, 1L);
        MatcherAssert.assertThat((String)"retries", (Object)m.getRetryRetries().delta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"invocations returning value", (Object)m.getInvocations(MetricDefinition.InvocationResult.VALUE_RETURNED, MetricDefinition.InvocationFallback.NOT_DEFINED).delta(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((String)"invocations throwing exception", (Object)m.getInvocations(MetricDefinition.InvocationResult.EXCEPTION_THROWN, MetricDefinition.InvocationFallback.NOT_DEFINED).delta(), (Matcher)Matchers.is((Object)0L));
    }

    @Test
    public void testRetryMetricSuccessfulAfterRetry() {
        MetricGetter m = new MetricGetter(RetryMetricBean.class, "failSeveralTimes");
        m.baselineMetrics();
        this.retryBean.failSeveralTimes(3, new RetryMetricBean.CallCounter());
        this.assertRetryCallsIncremented(m, MetricDefinition.RetryRetried.TRUE, MetricDefinition.RetryResult.VALUE_RETURNED, 1L);
        MatcherAssert.assertThat((String)"retries", (Object)m.getRetryRetries().delta(), (Matcher)Matchers.is((Object)3L));
        MatcherAssert.assertThat((String)"invocations returning value", (Object)m.getInvocations(MetricDefinition.InvocationResult.VALUE_RETURNED, MetricDefinition.InvocationFallback.NOT_DEFINED).delta(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((String)"invocations throwing exception", (Object)m.getInvocations(MetricDefinition.InvocationResult.EXCEPTION_THROWN, MetricDefinition.InvocationFallback.NOT_DEFINED).delta(), (Matcher)Matchers.is((Object)0L));
    }

    @Test
    public void testRetryMetricNonRetryableImmediately() {
        MetricGetter m = new MetricGetter(RetryMetricBean.class, "failSeveralTimesThenNonRetryable");
        m.baselineMetrics();
        Assert.expectThrows(RetryMetricBean.NonRetryableException.class, () -> this.retryBean.failSeveralTimesThenNonRetryable(0, new RetryMetricBean.CallCounter()));
        this.assertRetryCallsIncremented(m, MetricDefinition.RetryRetried.FALSE, MetricDefinition.RetryResult.EXCEPTION_NOT_RETRYABLE, 1L);
        MatcherAssert.assertThat((String)"retries", (Object)m.getRetryRetries().delta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"invocations returning value", (Object)m.getInvocations(MetricDefinition.InvocationResult.VALUE_RETURNED, MetricDefinition.InvocationFallback.NOT_DEFINED).delta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"invocations throwing exception", (Object)m.getInvocations(MetricDefinition.InvocationResult.EXCEPTION_THROWN, MetricDefinition.InvocationFallback.NOT_DEFINED).delta(), (Matcher)Matchers.is((Object)1L));
    }

    @Test
    public void testRetryMetricNonRetryableAfterRetries() {
        MetricGetter m = new MetricGetter(RetryMetricBean.class, "failSeveralTimesThenNonRetryable");
        m.baselineMetrics();
        Assert.expectThrows(RetryMetricBean.NonRetryableException.class, () -> this.retryBean.failSeveralTimesThenNonRetryable(3, new RetryMetricBean.CallCounter()));
        this.assertRetryCallsIncremented(m, MetricDefinition.RetryRetried.TRUE, MetricDefinition.RetryResult.EXCEPTION_NOT_RETRYABLE, 1L);
        MatcherAssert.assertThat((String)"retries", (Object)m.getRetryRetries().delta(), (Matcher)Matchers.is((Object)3L));
        MatcherAssert.assertThat((String)"invocations returning value", (Object)m.getInvocations(MetricDefinition.InvocationResult.VALUE_RETURNED, MetricDefinition.InvocationFallback.NOT_DEFINED).delta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"invocations throwing exception", (Object)m.getInvocations(MetricDefinition.InvocationResult.EXCEPTION_THROWN, MetricDefinition.InvocationFallback.NOT_DEFINED).delta(), (Matcher)Matchers.is((Object)1L));
    }

    @Test
    public void testRetryMetricMaxRetries() {
        MetricGetter m = new MetricGetter(RetryMetricBean.class, "failSeveralTimes");
        m.baselineMetrics();
        Exceptions.expectTestException(() -> this.retryBean.failSeveralTimes(20, new RetryMetricBean.CallCounter()));
        Exceptions.expectTestException(() -> this.retryBean.failSeveralTimes(20, new RetryMetricBean.CallCounter()));
        this.assertRetryCallsIncremented(m, MetricDefinition.RetryRetried.TRUE, MetricDefinition.RetryResult.MAX_RETRIES_REACHED, 2L);
        MatcherAssert.assertThat((String)"retries", (Object)m.getRetryRetries().delta(), (Matcher)Matchers.is((Object)10L));
        MatcherAssert.assertThat((String)"invocations returning value", (Object)m.getInvocations(MetricDefinition.InvocationResult.VALUE_RETURNED, MetricDefinition.InvocationFallback.NOT_DEFINED).delta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"invocations throwing exception", (Object)m.getInvocations(MetricDefinition.InvocationResult.EXCEPTION_THROWN, MetricDefinition.InvocationFallback.NOT_DEFINED).delta(), (Matcher)Matchers.is((Object)2L));
    }

    @Test
    public void testRetryMetricMaxRetriesHitButNoRetry() {
        MetricGetter m = new MetricGetter(RetryMetricBean.class, "maxRetriesZero");
        m.baselineMetrics();
        Exceptions.expectTestException(() -> this.retryBean.maxRetriesZero());
        this.assertRetryCallsIncremented(m, MetricDefinition.RetryRetried.FALSE, MetricDefinition.RetryResult.MAX_RETRIES_REACHED, 1L);
        MatcherAssert.assertThat((String)"retries", (Object)m.getRetryRetries().delta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"invocations returning value", (Object)m.getInvocations(MetricDefinition.InvocationResult.VALUE_RETURNED, MetricDefinition.InvocationFallback.NOT_DEFINED).delta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"invocations throwing exception", (Object)m.getInvocations(MetricDefinition.InvocationResult.EXCEPTION_THROWN, MetricDefinition.InvocationFallback.NOT_DEFINED).delta(), (Matcher)Matchers.is((Object)1L));
    }

    @Test
    public void testRetryMetricMaxDuration() {
        MetricGetter m = new MetricGetter(RetryMetricBean.class, "failAfterDelay");
        m.baselineMetrics();
        Duration testDelay = TCKConfig.getConfig().getTimeoutInDuration(100);
        Exceptions.expectTestException(() -> this.retryBean.failAfterDelay(testDelay));
        this.assertRetryCallsIncremented(m, MetricDefinition.RetryRetried.TRUE, MetricDefinition.RetryResult.MAX_DURATION_REACHED, 1L);
        MatcherAssert.assertThat((String)"invocations returning value", (Object)m.getInvocations(MetricDefinition.InvocationResult.VALUE_RETURNED, MetricDefinition.InvocationFallback.NOT_DEFINED).delta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"invocations throwing exception", (Object)m.getInvocations(MetricDefinition.InvocationResult.EXCEPTION_THROWN, MetricDefinition.InvocationFallback.NOT_DEFINED).delta(), (Matcher)Matchers.is((Object)1L));
    }

    @Test
    public void testRetryMetricMaxDurationNoRetries() {
        MetricGetter m = new MetricGetter(RetryMetricBean.class, "failAfterDelay");
        m.baselineMetrics();
        Duration testDelay = TCKConfig.getConfig().getTimeoutInDuration(1500);
        Exceptions.expectTestException(() -> this.retryBean.failAfterDelay(testDelay));
        this.assertRetryCallsIncremented(m, MetricDefinition.RetryRetried.FALSE, MetricDefinition.RetryResult.MAX_DURATION_REACHED, 1L);
        MatcherAssert.assertThat((String)"retries", (Object)m.getRetryRetries().delta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"invocations returning value", (Object)m.getInvocations(MetricDefinition.InvocationResult.VALUE_RETURNED, MetricDefinition.InvocationFallback.NOT_DEFINED).delta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"invocations throwing exception", (Object)m.getInvocations(MetricDefinition.InvocationResult.EXCEPTION_THROWN, MetricDefinition.InvocationFallback.NOT_DEFINED).delta(), (Matcher)Matchers.is((Object)1L));
    }

    private void assertRetryCallsIncremented(MetricGetter m, MetricDefinition.RetryRetried retriedValue, MetricDefinition.RetryResult resultValue, Long expectedDelta) {
        for (MetricDefinition.RetryRetried retried : MetricDefinition.RetryRetried.values()) {
            for (MetricDefinition.RetryResult result : MetricDefinition.RetryResult.values()) {
                if (retried == retriedValue && result == resultValue) {
                    MatcherAssert.assertThat((String)("Retry calls (" + retried + ", " + result + ")"), (Object)m.getRetryCalls(retried, result).delta(), (Matcher)Matchers.is((Object)expectedDelta));
                    continue;
                }
                MatcherAssert.assertThat((String)("Retry calls (" + retried + ", " + result + ")"), (Object)m.getRetryCalls(retried, result).delta(), (Matcher)Matchers.is((Object)0L));
            }
        }
    }
}

