/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.health.tck;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.main.JsonSchema;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import jakarta.json.JsonObject;
import java.io.IOException;
import org.eclipse.microprofile.health.tck.DeploymentUtils;
import org.eclipse.microprofile.health.tck.TCKBase;
import org.eclipse.microprofile.health.tck.deployment.SuccessfulLiveness;
import org.eclipse.microprofile.health.tck.deployment.SuccessfulReadiness;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.shrinkwrap.api.Archive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class JsonSchemaValidationTest
extends TCKBase {
    @Deployment
    public static Archive getDeployment() {
        return DeploymentUtils.createWarFileWithClasses(JsonSchemaValidationTest.class.getSimpleName(), SuccessfulLiveness.class, SuccessfulReadiness.class);
    }

    @Test
    @RunAsClient
    public void testPayloadJsonVerifiesWithTheSpecificationSchema() throws Exception {
        TCKBase.Response response = this.getUrlHealthContents();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        JsonObject json = this.readJson(response);
        ObjectMapper mapper = new ObjectMapper();
        JsonNode schemaJson = mapper.readTree(Thread.currentThread().getContextClassLoader().getResourceAsStream("health-check-schema.json"));
        JsonSchemaFactory factory = JsonSchemaFactory.byDefault();
        JsonSchema schema = factory.getJsonSchema(schemaJson);
        ProcessingReport report = schema.validate(this.toJsonNode(json));
        Assert.assertTrue((boolean)report.isSuccess(), (String)"Returned Health JSON does not validate against the specification schema");
    }

    private JsonNode toJsonNode(JsonObject jsonObject) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        return objectMapper.readTree(jsonObject.toString());
    }
}

