/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.jwt.tck.config;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.security.PrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.util.HashMap;
import java.util.Properties;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.eclipse.microprofile.jwt.tck.config.JwksApplication;
import org.eclipse.microprofile.jwt.tck.config.PublicKeyEndpoint;
import org.eclipse.microprofile.jwt.tck.config.SimpleTokenUtils;
import org.eclipse.microprofile.jwt.tck.util.MpJwtTestVersion;
import org.eclipse.microprofile.jwt.tck.util.TokenUtils;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.Reporter;
import org.testng.annotations.Test;

public class PublicKeyAsJWKLocationURLTest
extends Arquillian {
    @ArquillianResource
    private URL baseURL;

    @Deployment
    public static WebArchive createLocationURLDeployment() throws IOException {
        URL publicKey = PublicKeyAsJWKLocationURLTest.class.getResource("/publicKey4k.pem");
        Properties configProps = new Properties();
        String jwksBaseURL = System.getProperty("mp.jwt.tck.jwks.baseURL", "http://localhost:8080/");
        System.out.printf("baseURL=%s\n", jwksBaseURL);
        URL jwksURL = new URL(new URL(jwksBaseURL), "jwks/endp/publicKey4kAsJWKS?kid=publicKey4k");
        System.out.printf("jwksURL=%s\n", jwksURL);
        configProps.setProperty("mp.jwt.verify.publickey.location", jwksURL.toExternalForm());
        configProps.setProperty("mp.jwt.verify.issuer", "https://server.example.com");
        StringWriter configSW = new StringWriter();
        configProps.store(configSW, "PublicKeyAsJWKLocationURLTest microprofile-config.properties");
        StringAsset configAsset = new StringAsset(configSW.toString());
        WebArchive webArchive = (WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"PublicKeyAsJWKLocationURLTest.war")).addAsManifestResource((Asset)new StringAsset(MpJwtTestVersion.MPJWT_V_1_1.name()), "MPJWTTESTVERSION")).addAsResource(publicKey, "/publicKey4k.pem")).addAsResource(publicKey, "/publicKey.pem")).addClass(PublicKeyEndpoint.class)).addClass(JwksApplication.class)).addClass(SimpleTokenUtils.class)).addAsWebInfResource("beans.xml", "beans.xml")).addAsManifestResource((Asset)configAsset, "microprofile-config.properties");
        System.out.printf("WebArchive: %s\n", webArchive.toString(true));
        return webArchive;
    }

    @RunAsClient
    @Test(groups={"config"}, description="Validate the http://localhost:8080/jwks/endp/publicKey4kAsJWKS JWKS endpoint")
    public void validateLocationUrlContents() throws Exception {
        URL locationURL = new URL(this.baseURL, "jwks/endp/publicKey4kAsJWKS?kid=publicKey4k");
        Reporter.log((String)"Begin validateLocationUrlContents");
        StringWriter content = new StringWriter();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(locationURL.openStream()));){
            String line = reader.readLine();
            while (line != null) {
                content.write(line);
                content.write(10);
                line = reader.readLine();
            }
        }
        Reporter.log((String)("Received: " + content));
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(content.toString()));
        JsonObject jwks = jsonReader.readObject();
        JsonArray keys = jwks.getJsonArray("keys");
        JsonObject key = keys.getJsonObject(0);
        Assert.assertEquals((String)key.getJsonString("kty").getString(), (String)"RSA");
        Assert.assertEquals((String)key.getJsonString("use").getString(), (String)"sig");
        Assert.assertEquals((String)key.getJsonString("kid").getString(), (String)"publicKey4k");
        Assert.assertEquals((String)key.getJsonString("alg").getString(), (String)"RS256");
        Assert.assertEquals((String)key.getJsonString("e").getString(), (String)"AQAB");
        Assert.assertTrue((boolean)key.getJsonString("n").getString().startsWith("tL6HShqY5H4y56rsCo7VdhT9"));
    }

    @RunAsClient
    @Test(groups={"config"}, dependsOnMethods={"validateLocationUrlContents"}, description="Validate specifying the mp.jwt.verify.publickey.location as remote URL to a JWKS key")
    public void testKeyAsLocationUrl() throws Exception {
        Reporter.log((String)"testKeyAsLocationUrl, expect HTTP_OK");
        RSAPrivateKey privateKey = TokenUtils.readPrivateKey((String)"/privateKey4k.pem");
        String kid = "publicKey4k";
        HashMap timeClaims = new HashMap();
        String token = TokenUtils.generateTokenString((PrivateKey)privateKey, (String)kid, (String)"/Token1.json", null, timeClaims);
        String uri = this.baseURL.toExternalForm() + "jwks/endp/verifyKeyLocationAsJWKSUrl";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam("kid", new Object[]{kid});
        Response response = echoEndpointTarget.request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + token)).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        String replyString = (String)response.readEntity(String.class);
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(replyString));
        JsonObject reply = jsonReader.readObject();
        Reporter.log((String)reply.toString());
        Assert.assertTrue((boolean)reply.getBoolean("pass"), (String)reply.getString("msg"));
    }
}

