/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.jwt.tck.config;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.security.PrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.util.HashMap;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.eclipse.microprofile.jwt.tck.config.PublicKeyEndpoint;
import org.eclipse.microprofile.jwt.tck.config.SimpleTokenUtils;
import org.eclipse.microprofile.jwt.tck.container.jaxrs.TCKApplication;
import org.eclipse.microprofile.jwt.tck.util.MpJwtTestVersion;
import org.eclipse.microprofile.jwt.tck.util.TokenUtils;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.Reporter;
import org.testng.annotations.Test;

public class PublicKeyAsPEMTest
extends Arquillian {
    @ArquillianResource
    private URL baseURL;

    @Deployment
    public static WebArchive createDeployment() throws IOException {
        URL publicKey = PublicKeyAsPEMTest.class.getResource("/publicKey4k.pem");
        URL config = PublicKeyAsPEMTest.class.getResource("/META-INF/microprofile-config-publickey.properties");
        WebArchive webArchive = (WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"PublicKeyAsPEMTest.war")).addAsManifestResource((Asset)new StringAsset(MpJwtTestVersion.MPJWT_V_1_1.name()), "MPJWTTESTVERSION")).addAsResource(publicKey, "/publicKey.pem")).addClass(PublicKeyEndpoint.class)).addClass(TCKApplication.class)).addClass(SimpleTokenUtils.class)).addAsWebInfResource("beans.xml", "beans.xml")).addAsManifestResource(config, "microprofile-config.properties");
        System.out.printf("WebArchive: %s\n", webArchive.toString(true));
        return webArchive;
    }

    @RunAsClient
    @Test(groups={"config"}, description="Validate that the embedded PEM key is used to sign the JWT")
    public void testKeyAsPEM() throws Exception {
        Reporter.log((String)"testKeyAsPEM, expect HTTP_OK");
        RSAPrivateKey privateKey = TokenUtils.readPrivateKey((String)"/privateKey4k.pem");
        String kid = "/privateKey4k.pem";
        HashMap timeClaims = new HashMap();
        String token = TokenUtils.generateTokenString((PrivateKey)privateKey, (String)kid, (String)"/Token1.json", null, timeClaims);
        String uri = this.baseURL.toExternalForm() + "endp/verifyKeyAsPEM";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri);
        Response response = echoEndpointTarget.request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + token)).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        String replyString = (String)response.readEntity(String.class);
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(replyString));
        JsonObject reply = jsonReader.readObject();
        Reporter.log((String)reply.toString());
        Assert.assertTrue((boolean)reply.getBoolean("pass"), (String)reply.getString("msg"));
    }
}

