/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.jwt.tck.container.jaxrs;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.eclipse.microprofile.jwt.tck.container.jaxrs.PrincipalInjectionEndpoint;
import org.eclipse.microprofile.jwt.tck.container.jaxrs.TCKApplication;
import org.eclipse.microprofile.jwt.tck.util.MpJwtTestVersion;
import org.eclipse.microprofile.jwt.tck.util.TokenUtils;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.Reporter;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class PrincipalInjectionTest
extends Arquillian {
    private static String token;
    @ArquillianResource
    private URL baseURL;

    @Deployment(testable=true)
    public static WebArchive createDeployment() throws IOException {
        URL config = PrincipalInjectionTest.class.getResource("/META-INF/microprofile-config-publickey-location.properties");
        URL publicKey = PrincipalInjectionTest.class.getResource("/publicKey.pem");
        WebArchive webArchive = (WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"PrincipalInjectionTest.war")).addAsManifestResource((Asset)new StringAsset(MpJwtTestVersion.MPJWT_V_1_0.name()), "MPJWTTESTVERSION")).addAsResource(publicKey, "/publicKey.pem")).addClass(PrincipalInjectionEndpoint.class)).addClass(TCKApplication.class)).addAsWebInfResource("beans.xml", "beans.xml")).addAsManifestResource(config, "microprofile-config.properties");
        System.out.printf("WebArchive: %s\n", webArchive.toString(true));
        return webArchive;
    }

    @BeforeClass(alwaysRun=true)
    public static void generateToken() throws Exception {
        token = TokenUtils.generateTokenString((String)"/Token1.json");
    }

    @RunAsClient
    @Test(groups={"cdi-provider"}, description="Verify that the injected authenticated principal is as expected")
    public void verifyInjectedPrincipal() throws Exception {
        Reporter.log((String)("Begin verifyInjectedPrincipal, baseURL=" + this.baseURL.toExternalForm()));
        String uri = this.baseURL.toExternalForm() + "endp/verifyInjectedPrincipal";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri);
        Response response = echoEndpointTarget.request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + token)).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        String replyString = (String)response.readEntity(String.class);
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(replyString));
        JsonObject reply = jsonReader.readObject();
        Reporter.log((String)reply.toString());
        Assert.assertTrue((boolean)reply.getBoolean("pass"), (String)reply.getString("msg"));
    }
}

