/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.lra.tck.participant.nonjaxrs.valid;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Logger;
import org.eclipse.microprofile.lra.annotation.Compensate;
import org.eclipse.microprofile.lra.annotation.ws.rs.LRA;
import org.eclipse.microprofile.lra.tck.service.LRAMetricService;
import org.eclipse.microprofile.lra.tck.service.LRAMetricType;

@ApplicationScoped
@Path(value="long-business-participant")
public class LongBusinessMethodParticipant {
    public static final String ROOT_PATH = "long-business-participant";
    public static final String BUSINESS_METHOD = "business-method";
    public static final String SYNC_METHOD = "sync-method";
    private static final Logger LOGGER = Logger.getLogger(LongBusinessMethodParticipant.class.getName());
    private CountDownLatch businessLatch = new CountDownLatch(1);
    private CountDownLatch syncLatch = new CountDownLatch(1);
    @Inject
    private LRAMetricService lraMetricService;

    @Compensate
    public void compensate(URI lraId) {
        assert (lraId != null);
        if (this.businessLatch.getCount() > 0L) {
            this.businessLatch.countDown();
        }
        this.lraMetricService.incrementMetric(LRAMetricType.Compensated, lraId, LongBusinessMethodParticipant.class);
    }

    @PUT
    @Path(value="business-method")
    @LRA(value=LRA.Type.MANDATORY, end=false)
    public Response enlistWithLongLatency(@HeaderParam(value="Long-Running-Action") URI lraId) {
        LOGGER.info("call of enlistWithLongLatency");
        try {
            this.syncLatch.countDown();
            this.businessLatch.await();
            return Response.ok((Object)lraId).build();
        }
        catch (InterruptedException ex) {
            return Response.serverError().build();
        }
    }

    @PUT
    @Path(value="sync-method")
    public Response sync() {
        LOGGER.info("call of sync method");
        try {
            this.syncLatch.await();
        }
        catch (Exception e) {
            throw new IllegalStateException("Expecting the latch will be succesfully released on long latency LRA is in progress");
        }
        return Response.ok().build();
    }
}

