/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.lra.tck;

import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.eclipse.microprofile.lra.tck.TckLRATypeTests;
import org.eclipse.microprofile.lra.tck.participant.api.GenericLRAException;

public class LRAClientOps {
    private static final Logger LOGGER = Logger.getLogger(TckLRATypeTests.class.getName());
    private final WebTarget target;
    private final ScheduledExecutorService executor;
    private final Map<LRATask, ScheduledFuture<?>> lraTasks;

    public LRAClientOps(WebTarget target) {
        this.target = target;
        this.executor = Executors.newSingleThreadScheduledExecutor();
        this.lraTasks = new ConcurrentHashMap();
    }

    private synchronized Response invokeRestEndpoint(URI lra, String basePath, String path, int coerceResponse) {
        WebTarget resourcePath = this.target.path(basePath).path(path).queryParam("Coerce-Status", new Object[]{coerceResponse});
        Invocation.Builder builder = resourcePath.request();
        if (lra != null) {
            builder.header("Long-Running-Action", (Object)lra);
        }
        return builder.put(Entity.text((Object)""));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String invokeRestEndpointAndReturnLRA(URI lra, String basePath, String path, int coerceResponse) {
        try (Response response = this.invokeRestEndpoint(lra, basePath, path, coerceResponse);){
            String string = (String)response.readEntity(String.class);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int invokeRestEndpointAndReturnStatus(URI lra, String basePath, String path, int coerceResponse) {
        try (Response response = this.invokeRestEndpoint(lra, basePath, path, coerceResponse);){
            int n = response.getStatus();
            return n;
        }
    }

    private URI toURI(String lra) throws GenericLRAException {
        try {
            return new URI(lra);
        }
        catch (URISyntaxException e) {
            throw new GenericLRAException(null, e.getMessage(), e);
        }
    }

    public URI startLRA(URI parentLRA, String clientID, long timeout, ChronoUnit unit) throws GenericLRAException {
        String lra = (String)this.invokeRestEndpoint(parentLRA, "non-participating-tck-resource", "/start-dont-end", 200).readEntity(String.class);
        if (timeout > 0L) {
            this.scheduleCancelation(clientID, this.toURI(lra), timeout, unit);
        }
        return this.toURI(lra);
    }

    public void cancelLRA(URI lraId) throws GenericLRAException {
        this.cancelCancelation(lraId);
        this.invokeRestEndpointAndReturnLRA(lraId, "non-participating-tck-resource", "/end", 500);
    }

    private void cancelLRA(String clientId, URI lra) {
        LOGGER.warning("cancelling LRA from the timer: clientId: " + clientId + " LRA id: " + lra.toASCIIString());
        this.cancelLRA(lra);
        throw new IllegalArgumentException("LRA timed out prematurely");
    }

    public void closeLRA(URI lraId) throws GenericLRAException {
        this.cancelCancelation(lraId);
        this.invokeRestEndpointAndReturnLRA(lraId, "non-participating-tck-resource", "/end", 200);
    }

    void closeLRA(String lraId) {
        this.closeLRA(this.toURI(lraId));
    }

    private void leaveLRA(URI lra, String basePath, String resourcePath) throws GenericLRAException {
        this.invokeRestEndpoint(lra, basePath, resourcePath, 200);
    }

    private static TimeUnit timeUnit(ChronoUnit unit) {
        switch (unit) {
            case NANOS: {
                return TimeUnit.NANOSECONDS;
            }
            case MICROS: {
                return TimeUnit.MICROSECONDS;
            }
            case MILLIS: {
                return TimeUnit.MILLISECONDS;
            }
            case SECONDS: {
                return TimeUnit.SECONDS;
            }
            case MINUTES: {
                return TimeUnit.MINUTES;
            }
            case HOURS: {
                return TimeUnit.HOURS;
            }
            case DAYS: {
                return TimeUnit.DAYS;
            }
        }
        throw new IllegalArgumentException("ChronoUnit cannot be converted to TimeUnit: " + unit);
    }

    private void scheduleCancelation(String clientId, URI lra, long timeout, ChronoUnit unit) {
        this.lraTasks.put(new LRATask(clientId, lra), this.executor.schedule(() -> this.cancelLRA(clientId, lra), timeout, LRAClientOps.timeUnit(unit)));
    }

    private void cancelCancelation(URI lraId) {
        LRATask lra = new LRATask(null, lraId);
        if (this.lraTasks.containsKey(lra)) {
            this.lraTasks.remove(lra).cancel(false);
        }
    }

    void cleanUp(Logger logger, String testName) {
        this.lraTasks.forEach((lra, future) -> {
            logger.warning("Test: " + testName + " didn't finish LRA " + lra.lra + " with clientId " + lra.clientId);
            this.cancelLRA(lra.lra);
        });
    }

    private class LRATask {
        final String clientId;
        final URI lra;

        LRATask(String clientId, URI lra) {
            this.clientId = clientId;
            this.lra = lra;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LRATask lraTask = (LRATask)o;
            return this.lra.equals(lraTask.lra);
        }

        public int hashCode() {
            return Objects.hash(this.lra);
        }
    }
}

