/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.lra.tck.participant.activity;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.lra.tck.participant.activity.Activity;

@ApplicationScoped
public class ActivityStorage {
    private Map<URI, Activity> activities = new HashMap<URI, Activity>();

    public Activity getActivityAndAssertExistence(URI lraId, UriInfo jaxrsContext) {
        if (!this.activities.containsKey(lraId)) {
            String errorMessage = String.format("Activity store does not contain LRA id '%s', invoked from endpoint '%s'", lraId, jaxrsContext.getPath());
            throw new WebApplicationException(Response.status((int)410).entity((Object)errorMessage).build());
        }
        return this.activities.get(lraId);
    }

    public List<Activity> findAll() {
        return new ArrayList<Activity>(this.activities.values());
    }

    public Activity add(Activity activity) {
        this.activities.putIfAbsent(activity.getLraId(), activity);
        return this.activities.get(activity.getLraId());
    }

    public void remove(URI id) {
        this.activities.remove(id);
    }
}

