/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.reactive.messaging.tck.signatures.processors;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import javax.enterprise.context.ApplicationScoped;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.MapAssert;
import org.awaitility.Awaitility;
import org.eclipse.microprofile.reactive.messaging.Incoming;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.eclipse.microprofile.reactive.messaging.Outgoing;
import org.eclipse.microprofile.reactive.streams.operators.ProcessorBuilder;
import org.eclipse.microprofile.reactive.streams.operators.PublisherBuilder;
import org.eclipse.microprofile.reactive.streams.operators.ReactiveStreams;
import org.reactivestreams.Processor;

@ApplicationScoped
public class ProcessorBean {
    private Map<String, List<String>> collector = new ConcurrentHashMap<String, List<String>>();
    private static final List<String> EXPECTED = Arrays.asList("1", "1", "2", "2", "3", "3", "4", "4", "5", "5", "6", "6", "7", "7", "8", "8", "9", "9", "10", "10");
    private static Map<String, AtomicInteger> counters = new ConcurrentHashMap<String, AtomicInteger>();

    private static void increment(String counter) {
        counters.computeIfAbsent(counter, x -> new AtomicInteger(0)).incrementAndGet();
    }

    @Outgoing(value="publisher-for-processor-message")
    public PublisherBuilder<Integer> streamForProcessorOfMessages() {
        return ReactiveStreams.of((Object[])new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9});
    }

    @Outgoing(value="publisher-for-processor-payload")
    public PublisherBuilder<Integer> streamForProcessorOfPayloads() {
        return ReactiveStreams.of((Object[])new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9});
    }

    @Outgoing(value="publisher-for-processor-builder-message")
    public PublisherBuilder<Integer> streamForProcessorBuilderOfMessages() {
        return ReactiveStreams.of((Object[])new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9});
    }

    @Outgoing(value="publisher-for-processor-builder-payload")
    public PublisherBuilder<Integer> streamForProcessorBuilderOfPayloads() {
        return ReactiveStreams.of((Object[])new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9});
    }

    @Incoming(value="processor-message")
    public void getMessgesFromProcessorOfMessages(String value) {
        this.add("processor-message", value);
    }

    @Incoming(value="processor-payload")
    public void getMessgesFromProcessorOfPayloads(String value) {
        this.add("processor-payload", value);
    }

    @Incoming(value="processor-builder-message")
    public void getMessgesFromProcessorBuilderOfMessages(String value) {
        this.add("processor-builder-message", value);
    }

    @Incoming(value="processor-builder-payload")
    public void getMessgesFromProcessorBuilderOfPayloads(String value) {
        this.add("processor-builder-payload", value);
    }

    @Incoming(value="publisher-for-processor-message")
    @Outgoing(value="processor-message")
    public Processor<Message<Integer>, Message<String>> processorOfMessages() {
        ProcessorBean.increment("publisher-for-processor-message");
        return ReactiveStreams.builder().map(Message::getPayload).map(i -> i + 1).flatMap(i -> ReactiveStreams.of((Object[])new Integer[]{i, i})).map(i -> Integer.toString(i)).map(Message::of).buildRs();
    }

    @Incoming(value="publisher-for-processor-payload")
    @Outgoing(value="processor-payload")
    public Processor<Integer, String> processorOfPayloads() {
        ProcessorBean.increment("publisher-for-processor-payload");
        return ReactiveStreams.builder().map(i -> i + 1).flatMap(i -> ReactiveStreams.of((Object[])new Integer[]{i, i})).map(i -> Integer.toString(i)).buildRs();
    }

    @Incoming(value="publisher-for-processor-builder-message")
    @Outgoing(value="processor-builder-message")
    public ProcessorBuilder<Message<Integer>, Message<String>> processorBuilderOfMessages() {
        ProcessorBean.increment("publisher-for-processor-builder-message");
        return ReactiveStreams.builder().map(Message::getPayload).map(i -> i + 1).flatMap(i -> ReactiveStreams.of((Object[])new Integer[]{i, i})).map(i -> Integer.toString(i)).map(Message::of);
    }

    @Incoming(value="publisher-for-processor-builder-payload")
    @Outgoing(value="processor-builder-payload")
    public ProcessorBuilder<Integer, String> processorBuilderOfPayloads() {
        ProcessorBean.increment("publisher-for-processor-builder-payload");
        return ReactiveStreams.builder().map(i -> i + 1).flatMap(i -> ReactiveStreams.of((Object[])new Integer[]{i, i})).map(i -> Integer.toString(i));
    }

    private void add(String key, String value) {
        this.collector.computeIfAbsent(key, x -> new CopyOnWriteArrayList()).add(value);
    }

    void verify() {
        Awaitility.await().until(() -> this.collector.size() == 4);
        ((MapAssert)Assertions.assertThat(this.collector).hasSize(4)).allSatisfy((k, v) -> {
            ListAssert cfr_ignored_0 = (ListAssert)Assertions.assertThat((List)v).containsExactlyElementsOf(EXPECTED);
        });
        Assertions.assertThat((AtomicInteger)counters.get("publisher-for-processor-message")).hasValue(1);
        Assertions.assertThat((AtomicInteger)counters.get("publisher-for-processor-payload")).hasValue(1);
        Assertions.assertThat((AtomicInteger)counters.get("publisher-for-processor-builder-message")).hasValue(1);
        Assertions.assertThat((AtomicInteger)counters.get("publisher-for-processor-builder-payload")).hasValue(1);
    }
}

