/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.reactive.streams.operators.tck.spi;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.eclipse.microprofile.reactive.streams.operators.ProcessorBuilder;
import org.eclipse.microprofile.reactive.streams.operators.tck.spi.AbstractStageVerification;
import org.eclipse.microprofile.reactive.streams.operators.tck.spi.QuietRuntimeException;
import org.eclipse.microprofile.reactive.streams.operators.tck.spi.ReactiveStreamsSpiVerification;
import org.reactivestreams.Processor;
import org.reactivestreams.Publisher;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TakeWhileStageVerification
extends AbstractStageVerification {
    TakeWhileStageVerification(ReactiveStreamsSpiVerification.VerificationDeps deps) {
        super(deps);
    }

    @Test
    public void takeWhileStageShouldTakeWhileConditionIsTrue() {
        Assert.assertEquals((Collection)((Collection)this.await(this.rs.of((Object[])new Integer[]{1, 2, 3, 4, 5, 6, 1, 2}).takeWhile(i -> i < 5).toList().run(this.getEngine()))), Arrays.asList(1, 2, 3, 4));
    }

    @Test
    public void takeWhileStageShouldEmitEmpty() {
        Assert.assertEquals((Collection)((Collection)this.await(this.rs.of((Object[])new Integer[]{1, 2, 3, 4, 5, 6}).takeWhile(i -> false).toList().run(this.getEngine()))), Collections.emptyList());
    }

    @Test
    public void takeWhileShouldCancelUpStreamWhenDone() {
        CompletableFuture cancelled = new CompletableFuture();
        this.infiniteStream().onTerminate(() -> cancelled.complete(null)).takeWhile(t -> false).toList().run(this.getEngine());
        this.await(cancelled);
    }

    @Test
    public void takeWhileShouldIgnoreSubsequentErrorsWhenDone() {
        Assert.assertEquals((Collection)((Collection)this.await(this.rs.of((Object[])new Integer[]{1, 2, 3, 4}).flatMap(i -> {
            if (i == 4) {
                return this.rs.failed((Throwable)new QuietRuntimeException("failed"));
            }
            return this.rs.of(i);
        }).takeWhile(t -> t < 3).toList().run(this.getEngine()))), Arrays.asList(1, 2));
    }

    @Test(expectedExceptions={QuietRuntimeException.class}, expectedExceptionsMessageRegExp="failed")
    public void takeWhileStageShouldHandleErrors() {
        CompletableFuture cancelled = new CompletableFuture();
        CompletionStage result = this.infiniteStream().onTerminate(() -> cancelled.complete(null)).takeWhile(i -> {
            throw new QuietRuntimeException("failed");
        }).toList().run(this.getEngine());
        this.await(cancelled);
        this.await(result);
    }

    @Test
    public void takeWhileStageShouldBeReusable() {
        ProcessorBuilder takeWhile = this.rs.builder().takeWhile(i -> i < 3);
        Assert.assertEquals((Collection)((Collection)this.await(this.rs.of((Object[])new Integer[]{1, 2, 3, 4}).via(takeWhile).toList().run(this.getEngine()))), Arrays.asList(1, 2));
        Assert.assertEquals((Collection)((Collection)this.await(this.rs.of((Object[])new Integer[]{2, 1, 5, 6}).via(takeWhile).toList().run(this.getEngine()))), Arrays.asList(2, 1));
    }

    @Override
    List<Object> reactiveStreamsTckVerifiers() {
        return Collections.singletonList(new ProcessorVerification());
    }

    public class ProcessorVerification
    extends AbstractStageVerification.StageProcessorVerification<Integer> {
        public ProcessorVerification() {
            super(TakeWhileStageVerification.this);
        }

        public Processor<Integer, Integer> createIdentityProcessor(int bufferSize) {
            return TakeWhileStageVerification.this.rs.builder().takeWhile(t -> true).buildRs(TakeWhileStageVerification.this.getEngine());
        }

        public Integer createElement(int element) {
            return element;
        }

        @Override
        public Publisher<Integer> createFailedPublisher() {
            return TakeWhileStageVerification.this.rs.failed((Throwable)new RuntimeException("failed")).takeWhile(t -> true).buildRs(TakeWhileStageVerification.this.getEngine());
        }
    }
}

