/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.reactive.streams.operators.tck.api;

import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.microprofile.reactive.streams.operators.ReactiveStreamsFactory;
import org.eclipse.microprofile.reactive.streams.operators.spi.Graph;
import org.eclipse.microprofile.reactive.streams.operators.spi.ReactiveStreamsEngine;
import org.eclipse.microprofile.reactive.streams.operators.spi.Stage;
import org.eclipse.microprofile.reactive.streams.operators.spi.SubscriberWithCompletionStage;
import org.eclipse.microprofile.reactive.streams.operators.spi.UnsupportedStageException;
import org.eclipse.microprofile.reactive.streams.operators.tck.api.AbstractReactiveStreamsApiVerification;
import org.reactivestreams.Processor;
import org.reactivestreams.Publisher;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CompletionRunnerVerification
extends AbstractReactiveStreamsApiVerification {
    public CompletionRunnerVerification(ReactiveStreamsFactory rs) {
        super(rs);
    }

    @Test
    public void run() {
        final AtomicReference builtGraph = new AtomicReference();
        final CompletableFuture expected = new CompletableFuture();
        CompletionStage returned = this.rs.empty().cancel().run(new ReactiveStreamsEngine(){

            public <T> Publisher<T> buildPublisher(Graph graph) throws UnsupportedStageException {
                throw new RuntimeException("Wrong method invoked");
            }

            public <T, R> SubscriberWithCompletionStage<T, R> buildSubscriber(Graph graph) throws UnsupportedStageException {
                throw new RuntimeException("Wrong method invoked");
            }

            public <T, R> Processor<T, R> buildProcessor(Graph graph) throws UnsupportedStageException {
                throw new RuntimeException("Wrong method invoked");
            }

            public <T> CompletionStage<T> buildCompletion(Graph graph) throws UnsupportedStageException {
                builtGraph.set(graph);
                return expected;
            }
        });
        Assert.assertSame((Object)returned, expected);
        Assert.assertEquals((int)((Graph)builtGraph.get()).getStages().size(), (int)2);
        Iterator stages = ((Graph)builtGraph.get()).getStages().iterator();
        this.assertEmptyStage((Stage)stages.next());
        Assert.assertTrue((boolean)(stages.next() instanceof Stage.Cancel));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void runNull() {
        this.rs.empty().cancel().run(null);
    }
}

