/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.frames;

import org.eclipse.jetty.http3.frames.Frame;
import org.eclipse.jetty.http3.frames.FrameType;

public class GoAwayFrame
extends Frame {
    public static final GoAwayFrame CLIENT_GRACEFUL = new GoAwayFrame(0x3FFFFFFFFFFFFFFFL);
    public static final GoAwayFrame SERVER_GRACEFUL = new GoAwayFrame(0x3FFFFFFFFFFFFFFCL);
    private final long lastId;

    public GoAwayFrame(long lastId) {
        super(FrameType.GOAWAY);
        this.lastId = lastId;
    }

    public long getLastId() {
        return this.lastId;
    }

    public boolean isGraceful() {
        return this.lastId == GoAwayFrame.CLIENT_GRACEFUL.lastId || this.lastId == GoAwayFrame.SERVER_GRACEFUL.lastId;
    }

    @Override
    public String toString() {
        return String.format("%s@%x[lastId=%d,graceful=%b]", this.getClass().getSimpleName(), this.hashCode(), this.getLastId(), this.isGraceful());
    }
}

