/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.query.examples.statements.actions;

import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.examples.extlibrary.EXTLibraryPackage;
import org.eclipse.emf.examples.extlibrary.Writer;
import org.eclipse.emf.query.conditions.Condition;
import org.eclipse.emf.query.conditions.eobjects.EObjectCondition;
import org.eclipse.emf.query.conditions.eobjects.EObjectTypeRelationCondition;
import org.eclipse.emf.query.conditions.eobjects.structuralfeatures.EObjectAttributeValueCondition;
import org.eclipse.emf.query.conditions.eobjects.structuralfeatures.EObjectReferenceValueCondition;
import org.eclipse.emf.query.conditions.strings.StringValue;
import org.eclipse.emf.query.examples.statements.actions.AbstractQueryDelegate;
import org.eclipse.emf.query.examples.statements.internal.l10n.QueryStatementsMessages;
import org.eclipse.emf.query.statements.FROM;
import org.eclipse.emf.query.statements.SELECT;
import org.eclipse.emf.query.statements.WHERE;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectBooksDelegate
extends AbstractQueryDelegate {
    public SelectBooksDelegate() {
        super(QueryStatementsMessages.selectBooks_title, QueryStatementsMessages.selectBooks_inputDialog_message, QueryStatementsMessages.selectBooks_message_notFound);
    }

    @Override
    protected Collection<EObject> performQuery(Object value) throws Exception {
        if (this.selectedEObjects == null) {
            throw new NullPointerException("Argument 'context' is null");
        }
        if (value == null) {
            throw new NullPointerException("Argument 'value' is null");
        }
        Writer chosenWriter = (Writer)value;
        String name = chosenWriter.getName();
        EObjectReferenceValueCondition condition = new EObjectReferenceValueCondition((EObjectCondition)new EObjectTypeRelationCondition(EXTLibraryPackage.eINSTANCE.getBook()), EXTLibraryPackage.eINSTANCE.getBook_Author(), (EObjectCondition)new EObjectAttributeValueCondition(EXTLibraryPackage.eINSTANCE.getWriter_Name(), (Condition)new StringValue(name)));
        SELECT statement = new SELECT(new FROM((Collection)chosenWriter.eResource().getContents()), new WHERE((EObjectCondition)condition));
        return statement.execute();
    }

    public void run(IAction action) {
        try {
            Collection<EObject> result = this.performQuery(this.selectedEObjects.iterator().next());
            if (result.isEmpty()) {
                MessageDialog.openInformation((Shell)this.shell, (String)this.title, (String)this.notFoundMessage);
            } else {
                this.editor.setSelectionToViewer(result);
            }
        }
        catch (Exception e) {
            MessageDialog.openInformation((Shell)this.shell, (String)this.title, (String)MESSAGE_EXCEPTION);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        if (action.isEnabled()) {
            if (this.selectedEObjects.size() != 1) {
                action.setEnabled(false);
                return;
            }
            if (!(this.selectedEObjects.iterator().next() instanceof Writer)) {
                action.setEnabled(false);
                return;
            }
        }
    }
}

