/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.validation.internal.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.internal.EMFModelValidationPlugin;
import org.eclipse.emf.validation.internal.l10n.ValidationMessages;
import org.eclipse.emf.validation.internal.service.ClientContext;
import org.eclipse.emf.validation.internal.service.IClientContext;
import org.eclipse.emf.validation.internal.util.Log;
import org.eclipse.emf.validation.internal.util.Trace;
import org.eclipse.emf.validation.internal.util.XmlExpressionSelector;
import org.eclipse.emf.validation.model.IClientSelector;
import org.eclipse.emf.validation.model.IModelConstraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientContextManager {
    private static final String E_CLIENT_CONTEXT = "clientContext";
    private static final String E_BINDING = "binding";
    private static final String A_CONTEXT = "context";
    private static final String A_CONSTRAINT = "constraint";
    private static final String A_CATEGORY = "category";
    private static final String A_REF = "ref";
    private static final ClientContextManager INSTANCE = new ClientContextManager();
    private final Set<IClientContext> clientContexts = new HashSet<IClientContext>();
    private final Map<String, IClientContext> clientContextMap = new HashMap<String, IClientContext>();
    private final Set<ClientContext> defaultContexts = new HashSet<ClientContext>();

    private ClientContextManager() {
        this.configureConstraintBindings();
    }

    private void configureConstraintBindings() {
        IConfigurationElement[] configs = Platform.getExtensionRegistry().getConfigurationElementsFor(EMFModelValidationPlugin.getPluginId(), "constraintBindings");
        this.configureClientContexts(configs);
        this.configureBindings(configs);
    }

    public static final ClientContextManager getInstance() {
        return INSTANCE;
    }

    public IClientContext getClientContext(String contextId) {
        return this.clientContextMap.get(contextId);
    }

    public Set<IClientContext> getClientContexts() {
        return this.clientContexts;
    }

    public Collection<IClientContext> getClientContextsFor(EObject eObject) {
        ArrayList<IClientContext> result = new ArrayList<IClientContext>();
        EvaluationContext ctx = new EvaluationContext(null, (Object)eObject);
        Iterator<IClientContext> iter = this.getClientContexts().iterator();
        while (iter.hasNext()) {
            IClientContext next = iter.next();
            IClientSelector selector = next.getSelector();
            EvaluationContext toTest = selector instanceof XmlExpressionSelector ? ctx : eObject;
            try {
                if (!selector.selects(toTest)) continue;
                result.add(next);
            }
            catch (RuntimeException e) {
                iter.remove();
                this.clientContextMap.remove(next.getId());
                this.defaultContexts.remove(next);
                Trace.catching(this.getClass(), "getClientContextsFor", e);
                Log.log(4, 114, EMFModelValidationPlugin.getMessage(ValidationMessages.client_selectorFailure_ERROR_, next.getId()), e);
            }
        }
        return result;
    }

    public <T extends IModelConstraint> Collection<T> getBindings(EObject eObject, Collection<? extends T> constraints) {
        Collection<IClientContext> contexts = this.getClientContextsFor(eObject);
        Collection<Object> result = contexts.isEmpty() ? (Collection<? extends T>)Collections.emptyList() : (contexts.size() == 1 ? this.getBindings(contexts.iterator().next(), constraints) : this.getBindings(contexts, constraints));
        return result;
    }

    public <T extends IModelConstraint> Collection<T> getBindings(IClientContext context, Collection<? extends T> constraints) {
        ArrayList<IModelConstraint> result = new ArrayList<IModelConstraint>(constraints.size());
        for (IModelConstraint constraint : constraints) {
            if (context.includes(constraint)) {
                result.add(constraint);
                continue;
            }
            if (!context.isDefault() || !this.isDefaultBinding(constraint)) continue;
            result.add(constraint);
        }
        return result;
    }

    public <T extends IModelConstraint> Collection<T> getBindings(Collection<? extends IClientContext> contexts, Collection<? extends T> constraints) {
        ArrayList<IModelConstraint> result = new ArrayList<IModelConstraint>(constraints.size());
        IClientContext[] ctxArray = contexts.toArray(new IClientContext[contexts.size()]);
        boolean anyContextIsDefault = false;
        for (IModelConstraint constraint : constraints) {
            boolean bound = false;
            IClientContext[] iClientContextArray = ctxArray;
            int n = ctxArray.length;
            int n2 = 0;
            while (n2 < n) {
                IClientContext element = iClientContextArray[n2];
                bound = element.includes(constraint);
                if (bound) {
                    result.add(constraint);
                    break;
                }
                if (element.isDefault()) {
                    anyContextIsDefault = true;
                }
                ++n2;
            }
            if (bound || !anyContextIsDefault || !this.isDefaultBinding(constraint)) continue;
            result.add(constraint);
        }
        return result;
    }

    private boolean isDefaultBinding(IModelConstraint constraint) {
        boolean result = true;
        String id = constraint.getDescriptor().getId();
        Iterator<IClientContext> iter = this.clientContexts.iterator();
        while (result && iter.hasNext()) {
            boolean bl = result = !iter.next().includes(constraint);
        }
        if (result) {
            for (ClientContext next : this.defaultContexts) {
                next.bindConstraint(id);
            }
        }
        return result;
    }

    @Deprecated
    public void configureConstraintBindings(IConfigurationElement[] elements) {
    }

    private void configureClientContexts(IConfigurationElement[] elements) {
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement config = iConfigurationElementArray[n2];
            if (E_CLIENT_CONTEXT.equals(config.getName())) {
                try {
                    ClientContext context = new ClientContext(config);
                    if (this.clientContexts.add(context)) {
                        this.clientContextMap.put(context.getId(), context);
                        if (context.isDefault()) {
                            this.defaultContexts.add(context);
                        }
                    }
                }
                catch (CoreException e) {
                    Trace.catching(this.getClass(), "configureClientContexts", e);
                    Log.log(e.getStatus());
                }
            }
            ++n2;
        }
    }

    private void configureBindings(IConfigurationElement[] elements) {
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement config = iConfigurationElementArray[n2];
            if (E_BINDING.equals(config.getName())) {
                String contextId = config.getAttribute(A_CONTEXT);
                if (contextId == null) {
                    Log.errorMessage(120, ValidationMessages.binding_noContextId_ERROR_, new Object[]{config.getDeclaringExtension().getNamespaceIdentifier()});
                } else {
                    ClientContext context = (ClientContext)this.getClientContext(contextId);
                    if (context == null) {
                        Log.errorMessage(121, ValidationMessages.binding_noSuchContext_ERROR_, new Object[]{contextId, config.getDeclaringExtension().getNamespaceIdentifier()});
                    } else {
                        this.configureBindings(context, config);
                    }
                }
            }
            ++n2;
        }
    }

    private void configureBindings(ClientContext context, IConfigurationElement config) {
        String ref;
        IConfigurationElement element;
        IConfigurationElement[] children;
        String id = config.getAttribute(A_CONSTRAINT);
        if (id != null) {
            context.bindConstraint(id);
        }
        if ((id = config.getAttribute(A_CATEGORY)) != null) {
            context.bindCategory(id);
        }
        IConfigurationElement[] iConfigurationElementArray = children = config.getChildren(A_CONSTRAINT);
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            element = iConfigurationElementArray[n2];
            ref = element.getAttribute(A_REF);
            if (ref == null) {
                Log.warningMessage(122, ValidationMessages.binding_noConstraintRef_WARN_, new Object[]{context.getId(), config.getDeclaringExtension().getNamespaceIdentifier()});
            } else {
                context.bindConstraint(ref);
            }
            ++n2;
        }
        iConfigurationElementArray = children = config.getChildren(A_CATEGORY);
        n = children.length;
        n2 = 0;
        while (n2 < n) {
            element = iConfigurationElementArray[n2];
            ref = element.getAttribute(A_REF);
            if (ref == null) {
                Log.errorMessage(123, ValidationMessages.binding_noCategoryRef_WARN_, new Object[]{context.getId(), config.getDeclaringExtension().getNamespaceIdentifier()});
            } else {
                context.bindCategory(ref);
            }
            ++n2;
        }
    }
}

