/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.ui.widgets;

import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.internal.ui.messages.Messages;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class TextAndDisable
extends Composite
implements SelectionListener,
ModifyListener {
    private Text text;
    private Button disabled;
    private String disabledValue;

    public TextAndDisable(Composite parent, int textStyle, String disabledValue) {
        super(parent, 0);
        this.disabledValue = disabledValue;
        GridLayout grid = new GridLayout(2, false);
        grid.marginHeight = 0;
        grid.marginWidth = 0;
        this.setLayout((Layout)grid);
        this.text = this.createText(textStyle);
        this.text.setLayoutData((Object)this.createTextLayoutData());
        this.text.addModifyListener((ModifyListener)this);
        this.disabled = this.createButton();
        this.disabled.setText(Messages.getString("TextAndDisable.0"));
        this.disabled.addSelectionListener((SelectionListener)this);
        this.disabled.setLayoutData((Object)UIUtil.createGridData(false, false));
    }

    public Text getText() {
        return this.text;
    }

    public Button getButton() {
        return this.disabled;
    }

    public boolean isDisabled() {
        return this.disabled.getSelection();
    }

    public void setDisabled(boolean disabled) {
        this.disabled.setSelection(disabled);
        this.widgetSelected(null);
    }

    public String getValue() {
        return this.text.getText();
    }

    public void setValue(String value) {
        this.text.setText(value);
        this.setDisabled(ObjectUtil.equals((Object)value, (Object)this.disabledValue));
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.isDisabled()) {
            this.text.setText(this.disabledValue);
            this.text.setEnabled(false);
        } else {
            this.text.setEnabled(true);
        }
    }

    public void modifyText(ModifyEvent e) {
    }

    protected Text createText(int textStyle) {
        return new Text((Composite)this, textStyle);
    }

    protected GridData createTextLayoutData() {
        GridData gd = new GridData();
        gd.widthHint = 32;
        return gd;
    }

    protected Button createButton() {
        return new Button((Composite)this, 32);
    }
}

