/*******************************************************************************
 * Copyright (c) 2010 Ecliptical Software Inc. and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Ecliptical Software Inc. - initial API and implementation
 *******************************************************************************/
package org.eclipse.emf.mint.internal.ui.views;

import java.util.LinkedHashMap;
import java.util.Map;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.ui.progress.WorkbenchJob;

public class UpdateViewerJob extends WorkbenchJob {
	
	private final TableViewer viewer;
	
	private final IWorkbenchSiteProgressService progressService;
	
	private final Object updateLock = new Object();
	
	private LinkedHashMap<ItemJavaElementDescriptor, Object> updates;

	public UpdateViewerJob(TableViewer viewer, IWorkbenchSiteProgressService progressService) {
		super(viewer.getControl().getDisplay(), Messages.UpdateViewerJob_Name);
		this.viewer = viewer;
		this.progressService = progressService;
//		setPriority(DECORATE);
		setSystem(true);
	}
	
	public void addUpdate(ItemJavaElementDescriptor descriptor, Object element) {
		synchronized (updateLock) {
			if (updates == null)
				updates = new LinkedHashMap<ItemJavaElementDescriptor, Object>();
			
			if (!updates.containsKey(descriptor)) {
				updates.put(descriptor, element);
				if (progressService == null)
					schedule();
				else
					progressService.schedule(this, 0L, true);
			}
		}
	}
	
	@Override
	public IStatus runInUIThread(IProgressMonitor monitor) {
		if (monitor.isCanceled() || viewer.getControl().isDisposed())
			return Status.CANCEL_STATUS;
		
		LinkedHashMap<ItemJavaElementDescriptor, Object> updates;
		synchronized (updateLock) {
			updates = this.updates;
			this.updates = null;
		}

		if (updates != null) {
			for (Map.Entry<ItemJavaElementDescriptor, Object> update : updates.entrySet())
				update.getKey().setElement(update.getValue());
			
			viewer.update(updates.keySet().toArray(), null);
			if (progressService != null)
				progressService.warnOfContentChange();
		}
		
		return Status.OK_STATUS;
	}
}
