/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.examples.prov.server.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceFactoryImpl;
import org.eclipse.net4j.core.Executor;
import org.eclipse.net4j.core.ITempManager;
import org.eclipse.net4j.core.Task;
import org.eclipse.net4j.examples.prov.Category;
import org.eclipse.net4j.examples.prov.Feature;
import org.eclipse.net4j.examples.prov.ProvFactory;
import org.eclipse.net4j.examples.prov.Site;
import org.eclipse.net4j.examples.prov.server.ProvException;
import org.eclipse.net4j.examples.prov.server.ProvServerPlugin;
import org.eclipse.net4j.examples.prov.server.SiteManager;
import org.eclipse.net4j.examples.prov.server.util.FileSystemSilencer;
import org.eclipse.net4j.examples.prov.server.util.SaxHandler;
import org.eclipse.net4j.examples.prov.server.util.SaxParser;
import org.eclipse.net4j.spring.ValidationException;
import org.eclipse.net4j.spring.impl.ServiceImpl;
import org.eclipse.net4j.util.IOHelper;
import org.eclipse.net4j.util.StringHelper;
import org.eclipse.net4j.util.UnderlyingIOException;
import org.eclipse.net4j.util.eclipse.ResourcesHelper;
import org.eclipse.net4j.util.thread.Worker;
import org.eclipse.osgi.framework.util.Headers;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.pde.internal.core.plugin.PluginBase;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SiteManagerImpl
extends ServiceImpl
implements SiteManager {
    public static final long DEFAULT_FILE_SYSTEM_MONITOR_INTERVAL = 1000L;
    private long fileSystemMonitorInterval = 1000L;
    private Executor incomingExecutor;
    private ITempManager tempManager;
    private transient IFolder rootFolder;
    private transient IFolder incomingFolder;
    private transient IFolder pluginsFolder;
    private transient IFolder featuresFolder;
    private transient Site site;
    private transient FileSystemMonitor fileSystemMonitor;

    public long getFileSystemMonitorInterval() {
        return this.fileSystemMonitorInterval;
    }

    public void setFileSystemMonitorInterval(long fileSystemMonitorInterval) {
        this.doSet("fileSystemMonitorInterval", fileSystemMonitorInterval);
    }

    public Executor getIncomingExecutor() {
        return this.incomingExecutor;
    }

    public void setIncomingExecutor(Executor incomingExecutor) {
        this.doSet("incomingExecutor", incomingExecutor);
    }

    @Override
    public ITempManager getTempManager() {
        return this.tempManager;
    }

    public void setTempManager(ITempManager tempManager) {
        this.doSet("tempManager", tempManager);
    }

    @Override
    public Site getSite() {
        return this.site;
    }

    @Override
    public Feature getFeature(String id, String version) {
        for (Category category : this.getSite().getCategories()) {
            for (Feature feature : category.getFeatures()) {
                if (!StringHelper.equals((Object)feature.getId(), (Object)id) || !StringHelper.equals((Object)feature.getVersion(), (Object)version)) continue;
                return feature;
            }
        }
        return null;
    }

    @Override
    public InputStream getFeatureContent(String id, String version) throws CoreException {
        Feature feature = this.getFeature(id, version);
        return this.getFeatureContent(feature);
    }

    @Override
    public InputStream getFeatureContent(Feature feature) throws CoreException {
        IFile file = this.getFeaturesFolder().getFile((IPath)new Path(feature.getUrl()));
        try {
            return file.getContents();
        }
        catch (CoreException coreException) {
            file.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
            return file.getContents();
        }
    }

    @Override
    public void setCategories(List<Category> categories) {
        NullProgressMonitor monitor = new NullProgressMonitor();
        for (Category category : this.getSite().getCategories()) {
            String fileName = String.valueOf(category.getName()) + ".category";
            IFile file = this.getRootFolder().getFile(fileName);
            try {
                file.delete(true, (IProgressMonitor)monitor);
            }
            catch (CoreException ex) {
                this.error("Could not delete file " + file.getFullPath(), ex);
            }
        }
        this.getSite().getCategories().clear();
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Map map = resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap();
        map.put("category", new XMLResourceFactoryImpl());
        for (Category category : categories) {
            String fileName = String.valueOf(category.getName()) + ".category";
            IFile file = this.getRootFolder().getFile(fileName);
            URI uri = URI.createPlatformResourceURI((String)file.getFullPath().toString());
            Resource resource = resourceSet.createResource(uri);
            resource.getContents().add((Object)category);
            try {
                resource.save(Collections.EMPTY_MAP);
            }
            catch (IOException ex) {
                this.error("Could not save file " + file.getFullPath(), ex);
            }
            this.getSite().getCategories().add((Object)category);
        }
    }

    @Override
    public String generateManifest() {
        StringBuffer buffer = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        buffer.append("<site>\n");
        this.generateFeatures(buffer);
        this.generateCategories(buffer);
        buffer.append("</site>\n");
        return buffer.toString();
    }

    private void generateCategories(StringBuffer buffer) {
        buffer.append("   <category-def name=\"all\" label=\"All Features\">");
        buffer.append("This category is automatically generated to show all available features.");
        buffer.append("</category-def>\n");
        for (Category category : this.getSite().getCategories()) {
            buffer.append("   <category-def name=\"");
            buffer.append(category.getName());
            buffer.append("\" label=\"");
            buffer.append(category.getLabel());
            buffer.append("\"");
            if (category.getDescription() == null) {
                buffer.append(" />\n");
                continue;
            }
            buffer.append(">");
            buffer.append(category.getDescription());
            buffer.append("</category-def>\n");
        }
    }

    private void generateFeatures(StringBuffer buffer) {
        for (Feature feature : this.site.getFeatures()) {
            this.generateFeature(feature, buffer);
        }
    }

    private void generateFeature(Feature feature, StringBuffer buffer) {
        buffer.append("   <feature url=\"features/");
        buffer.append(feature.getId());
        buffer.append("_");
        buffer.append(feature.getVersion());
        buffer.append(".jar\" patch=\"false\" id=\"");
        buffer.append(feature.getId());
        buffer.append("\" version=\"");
        buffer.append(feature.getVersion());
        buffer.append("\">\n");
        buffer.append("      <category name=\"all\" />\n");
        for (Category category : this.getSite().getCategories(feature.getId(), feature.getVersion())) {
            buffer.append("      <category name=\"");
            buffer.append(category.getName());
            buffer.append("\" />\n");
        }
        buffer.append("   </feature>\n");
    }

    @Override
    public IFolder getRootFolder() {
        if (this.rootFolder == null) {
            this.rootFolder = SiteManagerImpl.ensureFolder((IContainer)ProvServerPlugin.getProject(), "site");
        }
        return this.rootFolder;
    }

    @Override
    public IFolder getIncomingFolder() {
        if (this.incomingFolder == null) {
            this.incomingFolder = SiteManagerImpl.ensureFolder((IContainer)ProvServerPlugin.getProject(), "incoming");
        }
        return this.incomingFolder;
    }

    @Override
    public IFolder getPluginsFolder() {
        if (this.pluginsFolder == null) {
            this.pluginsFolder = SiteManagerImpl.ensureFolder((IContainer)this.getRootFolder(), "plugins");
        }
        return this.pluginsFolder;
    }

    @Override
    public IFolder getFeaturesFolder() {
        if (this.featuresFolder == null) {
            this.featuresFolder = SiteManagerImpl.ensureFolder((IContainer)this.getRootFolder(), "features");
        }
        return this.featuresFolder;
    }

    @Override
    public Feature[] addResource(File file, String name) {
        FileSystemSilencer.waitForSilence(file);
        if (this.isDebugEnabled()) {
            this.debug("Start processing resource: " + name);
        }
        long start = System.currentTimeMillis();
        IncomingState incomingState = new IncomingState();
        File temp = null;
        if (file.isFile()) {
            if (name.endsWith("zip")) {
                temp = this.addArchive(file, incomingState);
            } else if (name.endsWith("jar")) {
                this.processFile(file, incomingState);
            } else if (name.endsWith("category")) {
                this.addCategory(file);
            }
        } else if (file.isDirectory()) {
            this.processFile(file, incomingState);
        }
        if (!incomingState.hasFeature() && incomingState.hasPlugin()) {
            try {
                Feature autoFeature = this.generateAutoFeature(file, incomingState);
                incomingState.getFeatures().add(autoFeature);
            }
            catch (Exception ex) {
                this.warn("Problem while generating an AutoFeature", ex);
            }
        }
        try {
            this.getRootFolder().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception ex) {
            this.warn("Problem while refreshing document root " + this.getRootFolder(), ex);
        }
        this.initSite();
        this.tempManager.release(temp);
        IOHelper.deleteFile((File)file);
        long time = System.currentTimeMillis() - start;
        if (this.isDebugEnabled()) {
            this.debug("Finished processing resource: " + name + " (" + time + " msec)");
        }
        List<Feature> features = incomingState.getFeatures();
        return features.toArray(new Feature[features.size()]);
    }

    private File addArchive(File file, IncomingState incomingState) {
        String zipName = StringHelper.removeSuffix((String)file.getName(), (String)".zip");
        File temp = this.tempManager.createTempFolder("archive");
        File targetFolder = new File(temp, zipName);
        targetFolder.mkdirs();
        String targetPath = targetFolder.getAbsolutePath();
        IOHelper.unzip((String)file.getAbsolutePath(), (String)targetPath);
        this.processFile(targetFolder, incomingState);
        return temp;
    }

    private void processFile(File file, IncomingState incomingState) {
        String features = this.getFeaturesFolder().getLocation().toString();
        String plugins = this.getPluginsFolder().getLocation().toString();
        if (file.isDirectory()) {
            if (new File(file, "feature.xml").exists()) {
                if (this.isDebugEnabled()) {
                    this.debug("Adding feature " + file.getName());
                }
                try {
                    incomingState.addFeature(new FileInputStream(new File(file, "feature.xml")));
                }
                catch (FileNotFoundException fileNotFoundException) {}
                File target = new File(features, String.valueOf(file.getName()) + ".jar");
                IOHelper.jar((File)file, (File)target, (boolean)true);
            } else if (new File(file, "plugin.xml").exists()) {
                if (this.isDebugEnabled()) {
                    this.debug("Adding plugin " + file.getName());
                }
                incomingState.addPlugin(file);
                File target = new File(plugins, String.valueOf(file.getName()) + ".jar");
                IOHelper.jar((File)file, (File)target, (boolean)true);
            } else if (new File(file, "fragment.xml").exists()) {
                if (this.isDebugEnabled()) {
                    this.debug("Adding fragment " + file.getName());
                }
                incomingState.addPlugin(file);
                File target = new File(plugins, String.valueOf(file.getName()) + ".jar");
                IOHelper.jar((File)file, (File)target, (boolean)true);
            } else {
                File manifestFile = new File(file, "META-INF/MANIFEST.MF");
                if (manifestFile.exists()) {
                    FileInputStream is;
                    block27: {
                        is = null;
                        try {
                            try {
                                is = new FileInputStream(manifestFile);
                                Headers headers = Headers.parseManifest((InputStream)is);
                                if (headers.get((Object)"Bundle-SymbolicName") != null) {
                                    if (headers.get((Object)"Fragment-Host") != null) {
                                        if (this.isDebugEnabled()) {
                                            this.debug("Adding fragment " + file.getName());
                                        }
                                    } else if (this.isDebugEnabled()) {
                                        this.debug("Adding plugin " + file.getName());
                                    }
                                    incomingState.addPlugin(file);
                                    File target = new File(plugins, String.valueOf(file.getName()) + ".jar");
                                    IOHelper.jar((File)file, (File)target, (boolean)true);
                                    break block27;
                                }
                                manifestFile = null;
                            }
                            catch (Exception exception) {}
                        }
                        catch (Throwable throwable) {
                            IOHelper.close(is);
                            throw throwable;
                        }
                    }
                    IOHelper.close((InputStream)is);
                } else {
                    manifestFile = null;
                }
                if (manifestFile == null) {
                    File[] children = file.listFiles();
                    int i = 0;
                    while (i < children.length) {
                        File child = children[i];
                        this.processFile(child, incomingState);
                        ++i;
                    }
                }
            }
        } else if (file.isFile() && file.getName().endsWith(".jar")) {
            this.processJar(file, incomingState);
        }
    }

    private void processJar(File file, IncomingState incomingState) {
        String features = this.getFeaturesFolder().getLocation().toString();
        String plugins = this.getPluginsFolder().getLocation().toString();
        ZipFile jarFile = null;
        JarEntry entry = null;
        try {
            try {
                File target = null;
                jarFile = new JarFile(file);
                entry = ((JarFile)jarFile).getJarEntry("feature.xml");
                if (entry != null) {
                    String name = StringHelper.removeSuffix((String)file.getName(), (String)".jar");
                    if (this.isDebugEnabled()) {
                        this.debug("Adding feature " + name);
                    }
                    incomingState.addFeature(((JarFile)jarFile).getInputStream(entry));
                    target = new File(features, file.getName());
                } else {
                    entry = ((JarFile)jarFile).getJarEntry("plugin.xml");
                    if (entry != null) {
                        String name = StringHelper.removeSuffix((String)file.getName(), (String)".jar");
                        if (this.isDebugEnabled()) {
                            this.debug("Adding plugin " + name);
                        }
                        incomingState.addPlugin(file);
                        target = new File(plugins, file.getName());
                    } else {
                        entry = ((JarFile)jarFile).getJarEntry("fragment.xml");
                        if (entry != null) {
                            String name = StringHelper.removeSuffix((String)file.getName(), (String)".jar");
                            if (this.isDebugEnabled()) {
                                this.debug("Adding fragment " + name);
                            }
                            incomingState.addPlugin(file);
                            target = new File(plugins, file.getName());
                        } else {
                            entry = ((JarFile)jarFile).getJarEntry("META-INF/MANIFEST.MF");
                            if (entry != null) {
                                InputStream is = null;
                                try {
                                    try {
                                        is = ((JarFile)jarFile).getInputStream(entry);
                                        Headers headers = Headers.parseManifest((InputStream)is);
                                        if (headers.get((Object)"Bundle-SymbolicName") != null) {
                                            if (headers.get((Object)"Fragment-Host") != null) {
                                                if (this.isDebugEnabled()) {
                                                    this.debug("Adding fragment " + file.getName());
                                                }
                                            } else if (this.isDebugEnabled()) {
                                                this.debug("Adding plugin " + file.getName());
                                            }
                                            incomingState.addPlugin(file);
                                            target = new File(plugins, file.getName());
                                        }
                                    }
                                    catch (Exception exception) {}
                                }
                                catch (Throwable throwable) {
                                    IOHelper.close(is);
                                    throw throwable;
                                }
                                IOHelper.close((InputStream)is);
                            }
                        }
                    }
                }
                if (target != null) {
                    IOHelper.copy((File)file, (File)target);
                }
            }
            catch (IOException ex) {
                throw new UnderlyingIOException("Error while analyzing jarfile " + file, (Throwable)ex);
            }
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException ex) {
                    this.warn("Problem while closing jar " + file, ex);
                }
            }
        }
    }

    private Feature generateAutoFeature(File file, IncomingState incomingState) throws IOException {
        String version;
        String id;
        String resourceName = file.getName();
        resourceName = StringHelper.removeSuffix((String)resourceName, (String)".jar");
        int lastUnderscore = (resourceName = StringHelper.removeSuffix((String)resourceName, (String)".zip")).lastIndexOf(95);
        if (lastUnderscore != -1) {
            id = resourceName.substring(0, lastUnderscore);
            version = resourceName.substring(lastUnderscore + 1);
            try {
                Version.parseVersion((String)version);
            }
            catch (Exception exception) {
                id = resourceName;
                version = "1.0.0";
            }
        } else {
            id = resourceName;
            version = "1.0.0";
        }
        AutoFeature feature = new AutoFeature(id, new Version(version));
        for (File pluginFile : incomingState.getPlugins()) {
            if (feature.addPlugin(pluginFile) != null) continue;
            this.warn("Plugin or fragment not added: " + pluginFile);
        }
        String name = String.valueOf(feature.getId()) + "_" + feature.getVersion();
        if (this.isDebugEnabled()) {
            this.debug("Generating feature " + name);
        }
        File temp = null;
        try {
            temp = this.tempManager.createTempFolder("feature");
            File folder = new File(temp, name);
            folder.mkdirs();
            File manifestFile = new File(folder, "feature.xml");
            feature.writeManifest(manifestFile);
            File target = new File(this.getFeaturesFolder().getLocation().toString(), String.valueOf(name) + ".jar");
            IOHelper.jar((File)folder, (File)target, (boolean)true);
        }
        finally {
            this.tempManager.release(temp);
        }
        Feature result = ProvFactory.eINSTANCE.createFeature();
        result.setId(id);
        result.setVersion(version);
        return result;
    }

    private void addCategory(File file) {
        try {
            Category category = this.loadCategory(file);
            if (this.isDebugEnabled()) {
                this.debug("Adding category " + category.getName());
            }
            FileInputStream fis = new FileInputStream(file);
            IFile target = this.getRootFolder().getFile(file.getName());
            if (target.exists()) {
                target.setContents((InputStream)fis, true, false, (IProgressMonitor)new NullProgressMonitor());
            } else {
                target.create((InputStream)fis, true, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (Exception ex) {
            this.error("Could not add category file " + file, ex);
        }
    }

    protected void activate() throws Exception {
        super.activate();
        this.fileSystemMonitor = new FileSystemMonitor((IContainer)this.getIncomingFolder(), 1, this.getFileSystemMonitorInterval());
        this.fileSystemMonitor.setDaemon(true);
        this.fileSystemMonitor.startup();
    }

    protected void deactivate() throws Exception {
        this.fileSystemMonitor.shutdown(200L);
        this.fileSystemMonitor = null;
        this.featuresFolder = null;
        this.incomingExecutor = null;
        this.incomingFolder = null;
        this.pluginsFolder = null;
        this.site = null;
        this.tempManager = null;
        super.deactivate();
    }

    protected void validate() throws ValidationException {
        super.validate();
        this.assertNotNull("incomingExecutor");
        this.assertNotNull("tempManager");
        this.getPluginsFolder();
        this.getFeaturesFolder();
        this.initSite();
    }

    private static IFolder ensureFolder(IContainer container, String path) {
        try {
            return ResourcesHelper.ensureFolder((IContainer)container, (String)path);
        }
        catch (CoreException ex) {
            throw new ProvException("Error while creating folder " + container.getLocation() + "/" + path, ex);
        }
    }

    private void initSite() throws ValidationException {
        this.site = ProvFactory.eINSTANCE.createSite();
        this.site.setName("Density Update Site");
        try {
            this.initFeatures();
            this.initCategories();
        }
        catch (Exception ex) {
            throw new ValidationException("Error while initializing site", (Throwable)ex);
        }
    }

    private void initCategories() throws ValidationException, IOException, CoreException {
        IFolder folder = this.getRootFolder();
        int i = 0;
        while (i < folder.members().length) {
            IResource member = folder.members()[i];
            if (member instanceof IFile && member.getName().endsWith(".category")) {
                this.initCategory((IFile)member);
            }
            ++i;
        }
    }

    private void initCategory(IFile file) throws ValidationException, IOException {
        Category category = this.loadCategory(new File(file.getLocation().toString()));
        this.site.getCategories().add((Object)category);
    }

    private Category loadCategory(File file) throws IOException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Map map = resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap();
        map.put("category", new XMLResourceFactoryImpl());
        URI uri = URI.createFileURI((String)file.getAbsolutePath());
        Resource resource = resourceSet.getResource(uri, true);
        resource.load(Collections.EMPTY_MAP);
        Category category = (Category)resource.getContents().get(0);
        return category;
    }

    private void initFeatures() throws ValidationException, CoreException {
        IFolder folder = this.getFeaturesFolder();
        int i = 0;
        while (i < folder.members().length) {
            IResource member = folder.members()[i];
            if (member instanceof IFile && member.getFileExtension().equals("jar")) {
                this.initFeature((IFile)member);
            }
            ++i;
        }
    }

    private void initFeature(IFile file) throws ValidationException {
        String name = file.getName();
        int lastUnderscore = name.lastIndexOf(95);
        if (lastUnderscore == -1) {
            throw new ValidationException("Feature archive has invalid filename " + name);
        }
        String id = name.substring(0, lastUnderscore);
        String version = name.substring(lastUnderscore + 1, name.lastIndexOf(46));
        this.site.addFeature(id, version);
    }

    private class FileSystemMonitor
    extends Worker
    implements IResourceChangeListener {
        private IContainer container;
        private int depth;
        private long interval;
        private transient IProgressMonitor monitor;
        private transient boolean inResourceChanged;

        public FileSystemMonitor(IContainer container, int depth, long interval) {
            super(String.valueOf(SiteManagerImpl.this.getFullBeanName()) + ".FileSystemMonitor");
            this.monitor = new NullProgressMonitor();
            this.container = container;
            this.depth = depth;
            this.interval = interval;
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
        }

        protected long doWorkStep(int progress) {
            if (!this.inResourceChanged) {
                try {
                    if (this.container != null) {
                        this.container.refreshLocal(this.depth, this.monitor);
                    }
                }
                catch (CoreException ex) {
                    SiteManagerImpl.this.error("Error while refreshing container " + this.container.getLocation().toString(), ex);
                    return -1L;
                }
            }
            return this.interval;
        }

        public void resourceChanged(IResourceChangeEvent event) {
            if (event.getType() != 1) {
                return;
            }
            IResourceDelta delta = event.getDelta().findMember(this.container.getFullPath());
            if (delta == null) {
                return;
            }
            this.inResourceChanged = true;
            IResourceDelta[] children = delta.getAffectedChildren(1);
            int i = 0;
            while (i < children.length) {
                IResource child = children[i].getResource();
                this.onResourceAdded(child);
                ++i;
            }
            this.inResourceChanged = false;
        }

        public void onResourceAdded(IResource resource) {
            String prefix = String.valueOf(this.container.getFullPath().toString()) + "/";
            String path = String.valueOf(resource.getFullPath().toString()) + (resource instanceof IContainer ? "/" : "");
            String name = StringHelper.removePrefix((String)path, (String)prefix);
            if (SiteManagerImpl.this.isDebugEnabled()) {
                SiteManagerImpl.this.debug("Detected incoming resource: " + name);
            }
            try {
                IncomingTask task = new IncomingTask(new File(resource.getLocation().toString()), name);
                SiteManagerImpl.this.incomingExecutor.execute((Task)task, null);
            }
            catch (Exception ex) {
                SiteManagerImpl.this.error("Error while executing IncomingTask for resource " + resource, ex);
            }
        }
    }

    private class IncomingTask
    implements Task {
        private File file;
        private String name;

        public IncomingTask(File file, String name) {
            this.file = file;
            this.name = name;
        }

        public void execute() throws Exception {
            SiteManagerImpl.this.addResource(this.file, this.name);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IncomingState {
        private List<Feature> features = new ArrayList<Feature>();
        private List<File> plugins = new ArrayList<File>();

        private IncomingState() {
        }

        public void addFeature(InputStream is) {
            try {
                Analzyer handler = new Analzyer();
                SaxParser parser = new SaxParser();
                parser.parse(is, handler);
            }
            finally {
                IOHelper.close((InputStream)is);
            }
        }

        public void addFeature(String id, String version) {
            Feature feature = ProvFactory.eINSTANCE.createFeature();
            feature.setId(id);
            feature.setVersion(version);
            this.features.add(feature);
        }

        public List<Feature> getFeatures() {
            return this.features;
        }

        public boolean hasFeature() {
            return !this.features.isEmpty();
        }

        public void addPlugin(File file) {
            this.plugins.add(file);
        }

        public List<File> getPlugins() {
            return this.plugins;
        }

        public boolean hasPlugin() {
            return !this.plugins.isEmpty();
        }

        private class Analzyer
        extends SaxHandler {
            private Analzyer() {
            }

            protected void handleStart(String[] context, String name, AttributesImpl attributes) throws Exception {
                if (this.matchContext(context, name, "/feature")) {
                    String id = this.getAttribute(attributes, "id");
                    String version = this.getAttribute(attributes, "version");
                    IncomingState.this.addFeature(id, version);
                }
                super.handleStart(context, name, attributes);
            }
        }
    }

    public static class IdAndVersion {
        private String id;
        private Version version;

        public IdAndVersion(String id, Version version) {
            if (id == null || id.length() == 0) {
                throw new IllegalArgumentException("id == null || id.length() == 0");
            }
            this.id = id;
            this.version = version;
        }

        public String getId() {
            return this.id;
        }

        public Version getVersion() {
            return this.version;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof IdAndVersion)) {
                return false;
            }
            IdAndVersion that = (IdAndVersion)obj;
            return StringHelper.equals((Object)this.id, (Object)that.id) && StringHelper.equals((Object)this.version, (Object)that.version);
        }

        public int hashCode() {
            return this.id.hashCode() ^ this.version.hashCode();
        }
    }

    public static class WithIdAndVersion {
        private IdAndVersion idAndVersion;

        public WithIdAndVersion(String id, Version version) {
            this.idAndVersion = new IdAndVersion(id, version);
        }

        public String getId() {
            return this.idAndVersion.getId();
        }

        public Version getVersion() {
            return this.idAndVersion.getVersion();
        }

        public IdAndVersion getIdAndVersion() {
            return this.idAndVersion;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AutoFeature
    extends WithIdAndVersion {
        private Map<IdAndVersion, AutoPlugin> plugins = new HashMap<IdAndVersion, AutoPlugin>();

        public AutoFeature(String id, Version version) {
            super(id, version);
        }

        private Set<String> getDependencies() {
            HashSet<String> result = new HashSet<String>();
            for (AutoPlugin plugin : this.plugins.values()) {
                ListIterator<AutoDependency> it = plugin.getDependencies().listIterator();
                while (it.hasNext()) {
                    AutoDependency dependency = it.next();
                    if (this.hasPlugin(dependency.getId(), dependency.getVersionRange())) continue;
                    result.add(dependency.toString());
                }
            }
            return result;
        }

        private boolean hasPlugin(String id, VersionRange versionRange) {
            for (AutoPlugin plugin : this.plugins.values()) {
                if (!StringHelper.equals((Object)id, (Object)plugin.getId()) || versionRange != null && !versionRange.isIncluded(plugin.getVersion())) continue;
                return true;
            }
            return false;
        }

        public void writeManifest(File file) throws FileNotFoundException {
            PrintWriter writer = null;
            try {
                writer = new PrintWriter(file);
                writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                writer.println();
                writer.println("<feature");
                writer.println("   id=\"" + this.getId() + "\"");
                writer.println("   label=\"" + this.getId() + "\"");
                writer.println("   version=\"" + this.getVersion() + "\"");
                writer.println("   provider-name=\"\">");
                writer.println();
                writer.println("   <description url=\"http://www.yourdomain.com/description\">");
                this.writeManifestDescription(writer);
                writer.println("   </description>");
                writer.println();
                writer.println("   <copyright url=\"http://www.yourdomain.com/copyright\">");
                writer.println("The copyrights of the contained plugins and fragments apply.");
                writer.println();
                this.writeManifestDescription(writer);
                writer.println("   </copyright>");
                writer.println();
                writer.println("   <license url=\"http://www.yourdomain.com/license\">");
                writer.println("The licenses of the contained plugins and fragments apply.");
                writer.println();
                this.writeManifestDescription(writer);
                writer.println("   </license>");
                writer.println();
                writer.println("   <requires>");
                for (String dependency : this.getDependencies()) {
                    writer.println("      " + dependency);
                }
                writer.println("   </requires>");
                writer.println();
                for (AutoPlugin plugin : this.plugins.values()) {
                    writer.println("   <plugin");
                    writer.println("      id=\"" + plugin.getId() + "\"");
                    writer.println("      download-size=\"0\"");
                    writer.println("      install-size=\"0\"");
                    writer.println("      version=\"" + plugin.getVersion() + "\"/>");
                    writer.println();
                }
                writer.println("</feature>");
                writer.flush();
            }
            catch (Throwable throwable) {
                IOHelper.close(writer);
                throw throwable;
            }
            IOHelper.close((Writer)writer);
        }

        private void writeManifestDescription(PrintWriter writer) {
            writer.println("This feature was automatically generated to contain");
            writer.println("the following plugins and fragments:");
            writer.println();
            for (AutoPlugin plugin : this.plugins.values()) {
                writer.println("      " + plugin.getId() + " " + plugin.getVersion());
            }
        }

        public AutoPlugin addPlugin(File file) {
            boolean isJar = file.isFile() && file.getName().endsWith(".jar");
            AutoPlugin plugin = null;
            InputStream is = null;
            try {
                try {
                    is = this.getInputStream(file, isJar, "META-INF/MANIFEST.MF");
                    plugin = this.readManifest(is);
                }
                catch (Exception exception) {}
            }
            finally {
                IOHelper.close(is);
            }
            if (plugin == null) {
                try {
                    try {
                        is = this.getInputStream(file, isJar, "plugin.xml");
                        plugin = this.readPlugin(is, false);
                    }
                    catch (IOException iOException) {}
                }
                finally {
                    IOHelper.close((InputStream)is);
                }
            }
            if (plugin == null) {
                try {
                    try {
                        is = this.getInputStream(file, isJar, "fragment.xml");
                        plugin = this.readPlugin(is, true);
                    }
                    catch (IOException iOException) {}
                }
                finally {
                    IOHelper.close((InputStream)is);
                }
            }
            if (plugin != null) {
                this.plugins.put(plugin.getIdAndVersion(), plugin);
            }
            return plugin;
        }

        public AutoPlugin addPlugin(String id, Version version, boolean isFragment) {
            AutoPlugin plugin = new AutoPlugin(id, version, isFragment);
            this.plugins.put(plugin.getIdAndVersion(), plugin);
            return plugin;
        }

        public AutoPlugin getPlugin(String id, Version version) {
            AutoPlugin plugin = this.plugins.get(new IdAndVersion(id, version));
            return plugin;
        }

        public Map<IdAndVersion, AutoPlugin> getPlugins() {
            return this.plugins;
        }

        private InputStream getInputStream(File file, boolean isJar, String entry) throws IOException {
            if (isJar) {
                URL url = new URL("jar:file:/" + file.getAbsolutePath() + "!/" + entry);
                JarURLConnection connection = (JarURLConnection)url.openConnection();
                return connection.getInputStream();
            }
            return new FileInputStream(new File(file, entry));
        }

        private AutoPlugin readManifest(InputStream is) throws IOException, BundleException {
            Headers headers = Headers.parseManifest((InputStream)is);
            String id = (String)headers.get((Object)"Bundle-SymbolicName");
            String version = (String)headers.get((Object)"Bundle-Version");
            if (id == null) {
                return null;
            }
            int semicolon = id.indexOf(59);
            if (semicolon != -1) {
                id = id.substring(0, semicolon);
            }
            if (version == null) {
                return null;
            }
            String fragmentHost = (String)headers.get((Object)"Require-Bundle");
            AutoPlugin plugin = this.addPlugin(id, new Version(version), fragmentHost != null);
            String requires = (String)headers.get((Object)"Require-Bundle");
            if (requires != null && requires.length() > 0) {
                ManifestElement[] elements = ManifestElement.parseHeader((String)"Require-Bundle", (String)requires);
                int i = 0;
                while (i < elements.length) {
                    ManifestElement element = elements[i];
                    String depId = element.getValue();
                    String attr = element.getAttribute("bundle-version");
                    VersionRange depVersionRange = attr == null ? null : new VersionRange(attr);
                    plugin.addDependency(depId, depVersionRange);
                    ++i;
                }
            }
            return plugin;
        }

        private AutoPlugin readPlugin(InputStream is, boolean isFragment) {
            Analzyer handler = new Analzyer(isFragment);
            SaxParser parser = new SaxParser();
            parser.parse(is, handler);
            return handler.getPlugin();
        }

        private VersionRange getVersionRange(String reqVersion, String matchRule) {
            if (reqVersion == null) {
                return null;
            }
            Version minVersion = Version.parseVersion((String)reqVersion);
            if (matchRule != null) {
                if (matchRule.equalsIgnoreCase("perfect")) {
                    return new VersionRange(minVersion, true, minVersion, true);
                }
                if (matchRule.equalsIgnoreCase("equivalent")) {
                    return new VersionRange(minVersion, true, new Version(minVersion.getMajor(), minVersion.getMinor() + 1, 0, ""), false);
                }
                if (matchRule.equalsIgnoreCase("compatible")) {
                    return new VersionRange(minVersion, true, new Version(minVersion.getMajor() + 1, 0, 0, ""), false);
                }
                if (matchRule.equalsIgnoreCase("greaterOrEqual")) {
                    return new VersionRange(reqVersion);
                }
                return new VersionRange(minVersion, true, new Version(minVersion.getMajor() + 1, 0, 0, ""), false);
            }
            return new VersionRange(minVersion, true, new Version(minVersion.getMajor() + 1, 0, 0, ""), false);
        }

        private class Analzyer
        extends SaxHandler {
            private boolean isFragment;
            private AutoPlugin plugin;

            public Analzyer(boolean isFragment) {
                this.isFragment = isFragment;
            }

            protected void handleStart(String[] context, String name, AttributesImpl attributes) throws Exception {
                String root;
                String string = root = this.isFragment ? "/fragment" : "/plugin";
                if (this.matchContext(context, name, root)) {
                    String id = this.getAttribute(attributes, "id");
                    String version = this.getAttribute(attributes, "version");
                    this.plugin = AutoFeature.this.addPlugin(id, new Version(version), this.isFragment);
                    if (this.isFragment) {
                        String pluginId = this.getAttribute(attributes, "plugin-id");
                        String pluginVersion = this.getAttribute(attributes, "plugin-version");
                        String matchRule = this.getAttribute(attributes, "match");
                        this.plugin.addDependency(pluginId, AutoFeature.this.getVersionRange(pluginVersion, matchRule));
                    }
                } else if (this.matchContext(context, name, String.valueOf(root) + "/requires/import")) {
                    String id = this.getAttribute(attributes, "plugin");
                    String version = this.getAttribute(attributes, "version");
                    String matchRule = this.getAttribute(attributes, "match");
                    this.plugin.addDependency(id, AutoFeature.this.getVersionRange(version, matchRule));
                }
                super.handleStart(context, name, attributes);
            }

            public AutoPlugin getPlugin() {
                return this.plugin;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AutoPlugin
    extends WithIdAndVersion {
        private boolean isFragment;
        private List<AutoDependency> dependencies = new ArrayList<AutoDependency>();

        public AutoPlugin(String id, Version version, boolean isFragment) {
            super(id, version);
            this.isFragment = isFragment;
        }

        public AutoDependency addDependency(String id, VersionRange versionRange) {
            AutoDependency dependency = new AutoDependency(id, versionRange);
            this.dependencies.add(dependency);
            return dependency;
        }

        public List<AutoDependency> getDependencies() {
            return this.dependencies;
        }

        public boolean isFragment() {
            return this.isFragment;
        }
    }

    public static class AutoDependency {
        private String id;
        private VersionRange versionRange;

        public AutoDependency(String id, VersionRange versionRange) {
            if (id == null || id.length() == 0) {
                throw new IllegalArgumentException("id == null || id.length() == 0");
            }
            this.id = id;
            this.versionRange = versionRange;
        }

        public String getId() {
            return this.id;
        }

        public VersionRange getVersionRange() {
            return this.versionRange;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("<import plugin=\"");
            buffer.append(this.id);
            buffer.append("\"");
            if (this.versionRange != null) {
                buffer.append(" version=\"");
                buffer.append(this.versionRange.getMinimum().toString());
                buffer.append("\"");
                int matchId = PluginBase.getMatchRule((VersionRange)this.versionRange);
                String match = null;
                switch (matchId) {
                    case 4: {
                        match = "greaterOrEqual";
                        break;
                    }
                    case 2: {
                        match = "compatible";
                        break;
                    }
                    case 1: {
                        match = "equivalent";
                        break;
                    }
                    case 3: {
                        match = "perfect";
                    }
                }
                if (match != null) {
                    buffer.append(" match=\"");
                    buffer.append(match);
                    buffer.append("\"");
                }
            }
            buffer.append("/>");
            return buffer.toString();
        }
    }
}

