/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.examples.prov.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.net4j.examples.prov.Category;
import org.eclipse.net4j.examples.prov.Feature;
import org.eclipse.net4j.examples.prov.ProvFactory;
import org.eclipse.net4j.examples.prov.ProvPackage;
import org.eclipse.net4j.examples.prov.Site;
import org.eclipse.net4j.util.StringHelper;

public class SiteImpl
extends EObjectImpl
implements Site {
    protected EList categories = null;
    protected static final String NAME_EDEFAULT = null;
    protected String name = NAME_EDEFAULT;
    protected EList features = null;

    protected SiteImpl() {
    }

    protected EClass eStaticClass() {
        return ProvPackage.Literals.SITE;
    }

    public EList getCategories() {
        if (this.categories == null) {
            this.categories = new EObjectContainmentWithInverseEList(Category.class, (InternalEObject)this, 0, 0);
        }
        return this.categories;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldName, (Object)this.name));
        }
    }

    public EList getFeatures() {
        if (this.features == null) {
            this.features = new EObjectContainmentWithInverseEList(Feature.class, (InternalEObject)this, 2, 5);
        }
        return this.features;
    }

    public Category getCategory(String name) {
        for (Category category : this.getCategories()) {
            if (!StringHelper.equals((Object)category.getName(), (Object)name)) continue;
            return category;
        }
        return null;
    }

    public Feature addFeature(String id, String version) {
        Feature feature = this.getFeature(id, version);
        if (feature != null) {
            return null;
        }
        feature = ProvFactory.eINSTANCE.createFeature();
        feature.setId(id);
        feature.setVersion(version);
        this.getFeatures().add((Object)feature);
        return feature;
    }

    public Category addCategory(String name) {
        Category category = this.getCategory(name);
        if (category != null) {
            return null;
        }
        category = ProvFactory.eINSTANCE.createCategory();
        category.setName(name);
        this.getCategories().add((Object)category);
        return category;
    }

    public Feature getFeature(String id, String version) {
        for (Feature feature : this.getFeatures()) {
            if (!StringHelper.equals((Object)feature.getId(), (Object)id) || version != null && !version.equals(feature.getVersion())) continue;
            return feature;
        }
        return null;
    }

    public EList getCategories(String featureId, String featureVersion) {
        ArrayList<Category> list = new ArrayList<Category>();
        for (Category category : this.getCategories()) {
            if (category.getFeature(featureId, featureVersion) == null) continue;
            list.add(category);
        }
        return new BasicEList.UnmodifiableEList(list.size(), list.toArray());
    }

    public Category removeCategory(int index) {
        return (Category)this.getCategories().remove(index);
    }

    public Feature removeFeature(int index) {
        Feature feature = (Feature)this.getFeatures().remove(index);
        EList categories = feature.getCategories();
        for (Category category : categories) {
            category.removeFeature(feature.getId(), feature.getVersion());
        }
        return feature;
    }

    public Feature removeFeature(String id, String version) {
        Iterator it = this.getFeatures().listIterator();
        while (it.hasNext()) {
            Feature feature = (Feature)it.next();
            if (!StringHelper.equals((Object)feature.getId(), (Object)id) || version != null && !version.equals(feature.getVersion())) continue;
            it.remove();
            return feature;
        }
        return null;
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                return ((InternalEList)this.getCategories()).basicAdd((Object)otherEnd, msgs);
            }
            case 2: {
                return ((InternalEList)this.getFeatures()).basicAdd((Object)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                return ((InternalEList)this.getCategories()).basicRemove((Object)otherEnd, msgs);
            }
            case 2: {
                return ((InternalEList)this.getFeatures()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getCategories();
            }
            case 1: {
                return this.getName();
            }
            case 2: {
                return this.getFeatures();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.getCategories().clear();
                this.getCategories().addAll((Collection)newValue);
                return;
            }
            case 1: {
                this.setName((String)newValue);
                return;
            }
            case 2: {
                this.getFeatures().clear();
                this.getFeatures().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.getCategories().clear();
                return;
            }
            case 1: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 2: {
                this.getFeatures().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.categories != null && !this.categories.isEmpty();
            }
            case 1: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 2: {
                return this.features != null && !this.features.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public Category removeCategory(String name) {
        Iterator it = this.getCategories().listIterator();
        while (it.hasNext()) {
            Category category = (Category)it.next();
            if (!StringHelper.equals((Object)category.getName(), (Object)name)) continue;
            it.remove();
            return category;
        }
        return null;
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (name: ");
        result.append(this.name);
        result.append(')');
        return result.toString();
    }
}

