/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.editor.configuration;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jet.internal.editor.JETTextEditor;
import org.eclipse.jet.internal.editor.annotations.JETAnnotationHover;
import org.eclipse.jet.internal.editor.configuration.DoubleClickStrategy;
import org.eclipse.jet.internal.editor.configuration.JETReconcilingStrategy;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.jface.text.formatter.MultiPassContentFormatter;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.MonoReconciler;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;

public class JETSourceViewerConfiguration
extends SourceViewerConfiguration {
    private DoubleClickStrategy doubleClickStrategy;
    private JETTextEditor editor;

    public JETSourceViewerConfiguration(JETTextEditor editor) {
        this.editor = editor;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return this.editor.getPartitionScanner().getContentTypes();
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        if (this.doubleClickStrategy == null) {
            this.doubleClickStrategy = new DoubleClickStrategy();
        }
        return this.doubleClickStrategy;
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        JETReconcilingStrategy strategy = new JETReconcilingStrategy(sourceViewer, this.editor);
        MonoReconciler reconciler = new MonoReconciler((IReconcilingStrategy)strategy, false);
        reconciler.setProgressMonitor((IProgressMonitor)new NullProgressMonitor());
        reconciler.setDelay(500);
        return reconciler;
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        return new JETAnnotationHover();
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        IAutoEditStrategy[] strategies = this.editor.getPartitionScanner().getAutoEditStrategies(contentType);
        if (strategies == null) {
            strategies = super.getAutoEditStrategies(sourceViewer, contentType);
        }
        return strategies;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        ContentAssistant assistant = new ContentAssistant();
        assistant.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        String[] configuredContentTypes = this.getConfiguredContentTypes(sourceViewer);
        int i = 0;
        while (i < configuredContentTypes.length) {
            String contentType = configuredContentTypes[i];
            IContentAssistProcessor processor = this.editor.getPartitionScanner().getCompletionProcessor(contentType, assistant);
            if (processor != null) {
                assistant.setContentAssistProcessor(processor, contentType);
            }
            ++i;
        }
        assistant.setContextInformationPopupOrientation(20);
        assistant.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
        assistant.enableAutoInsert(false);
        assistant.enableAutoActivation(true);
        return assistant;
    }

    public IContentFormatter getContentFormatter(ISourceViewer sourceViewer) {
        MultiPassContentFormatter formatter = new MultiPassContentFormatter(this.getConfiguredDocumentPartitioning(sourceViewer), "__dftl_partition_content_type");
        String[] configuredContentTypes = this.getConfiguredContentTypes(sourceViewer);
        int i = 0;
        while (i < configuredContentTypes.length) {
            String contentType = configuredContentTypes[i];
            IFormattingStrategy strategy = this.editor.getPartitionScanner().getFormattingStrategy(contentType);
            if (strategy != null) {
                if ("__dftl_partition_content_type".equals(contentType)) {
                    formatter.setMasterStrategy(strategy);
                } else {
                    formatter.setSlaveStrategy(strategy, contentType);
                }
            }
            ++i;
        }
        return formatter;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        String[] configuredContentTypes = this.getConfiguredContentTypes(sourceViewer);
        int i = 0;
        while (i < configuredContentTypes.length) {
            String contentType = configuredContentTypes[i];
            IPresentationDamager damager = this.editor.getPartitionScanner().getDamager(contentType);
            IPresentationRepairer repairer = this.editor.getPartitionScanner().getRepairer(contentType);
            if (damager != null) {
                reconciler.setDamager(damager, contentType);
            }
            if (repairer != null) {
                reconciler.setRepairer(repairer, contentType);
            }
            ++i;
        }
        return reconciler;
    }
}

