/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.launch;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.jet.JET2Context;
import org.eclipse.jet.internal.l10n.JET2Messages;
import org.eclipse.jet.internal.runtime.RuntimeLoggerContextExtender;
import org.eclipse.jet.internal.runtime.RuntimeTagLogger;
import org.eclipse.jet.taglib.TagInfo;

public class JETStreamMonitor
implements IStreamMonitor,
RuntimeTagLogger {
    private final List listeners = new ArrayList();
    private final StringBuffer buffer = new StringBuffer();
    private int msgLevel;

    public JETStreamMonitor(JET2Context context, int msgLevel) {
        new RuntimeLoggerContextExtender(context).addListener(this);
        this.msgLevel = msgLevel;
    }

    public void addListener(IStreamListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public String getContents() {
        return this.buffer.toString();
    }

    public void removeListener(IStreamListener listener) {
        this.listeners.remove(listener);
    }

    public void log(String message, TagInfo td, String templatePath, int level) {
        if (level != this.msgLevel) {
            return;
        }
        String msgPrefix = "";
        switch (level) {
            case 5: {
                msgPrefix = String.valueOf(JET2Messages.JETStreamMonitor_Error) + ": ";
                break;
            }
            case 4: {
                msgPrefix = String.valueOf(JET2Messages.JETStreamMonitor_Warning) + ": ";
                break;
            }
            case 3: {
                break;
            }
            case 2: {
                msgPrefix = String.valueOf(JET2Messages.JETStreamMonitor_Trace) + ": ";
                break;
            }
            case 1: {
                msgPrefix = String.valueOf(JET2Messages.JETStreamMonitor_Debug) + ": ";
            }
        }
        String formattedMsg = this.formatMessage(String.valueOf(msgPrefix) + message, td, templatePath);
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            IStreamListener listener = (IStreamListener)i.next();
            listener.streamAppended(formattedMsg, (IStreamMonitor)this);
        }
    }

    private String formatMessage(String message, TagInfo td, String templatePath) {
        StringBuffer msg = new StringBuffer();
        if (templatePath != null && templatePath.length() > 0) {
            msg.append(templatePath);
            if (td != null) {
                msg.append('(').append(td.getLine()).append(',').append(td.getCol()).append(')');
            }
            msg.append(": ");
            if (td != null) {
                msg.append(" ").append('<').append(td.getTagName());
                String[] attrNames = td.getAttributeNames();
                int i = 0;
                while (i < attrNames.length) {
                    msg.append(' ').append(attrNames[i]).append('=');
                    String value = td.getAttribute(attrNames[i]);
                    char quote = value.indexOf(34) >= 0 ? (char)'\'' : '\"';
                    msg.append(quote).append(value).append(quote);
                    ++i;
                }
                msg.append('>');
            }
            msg.append(System.getProperty("line.separator"));
            msg.append("    ");
        }
        msg.append(message);
        msg.append(System.getProperty("line.separator"));
        String finalMsg = msg.toString();
        return finalMsg;
    }
}

