/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.xpath.parser;

import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.jet.internal.l10n.JET2Messages;
import org.eclipse.jet.internal.xpath.ast.Axis;
import org.eclipse.jet.internal.xpath.ast.BinaryOp;
import org.eclipse.jet.internal.xpath.ast.ContextNode;
import org.eclipse.jet.internal.xpath.ast.ExprNode;
import org.eclipse.jet.internal.xpath.ast.Function;
import org.eclipse.jet.internal.xpath.ast.LogicalOp;
import org.eclipse.jet.internal.xpath.ast.NodeSetCast;
import org.eclipse.jet.internal.xpath.ast.NodeSetExpr;
import org.eclipse.jet.internal.xpath.ast.NodeTest;
import org.eclipse.jet.internal.xpath.ast.NumberLiteral;
import org.eclipse.jet.internal.xpath.ast.Predicate;
import org.eclipse.jet.internal.xpath.ast.RelOp;
import org.eclipse.jet.internal.xpath.ast.Root;
import org.eclipse.jet.internal.xpath.ast.Step;
import org.eclipse.jet.internal.xpath.ast.StringLiteral;
import org.eclipse.jet.internal.xpath.ast.UnaryMinus;
import org.eclipse.jet.internal.xpath.ast.UnionExpr;
import org.eclipse.jet.internal.xpath.ast.Variable;
import org.eclipse.jet.internal.xpath.parser.Token;
import org.eclipse.jet.internal.xpath.parser.TokenInstance;
import org.eclipse.jet.internal.xpath.parser.XPathTokenScanner;
import org.eclipse.jet.internal.xpath.parser.XPathTokens;
import org.eclipse.jet.xpath.NamespaceContext;
import org.eclipse.jet.xpath.XPathFunction;
import org.eclipse.jet.xpath.XPathFunctionResolver;
import org.eclipse.jet.xpath.XPathLexicalException;
import org.eclipse.jet.xpath.XPathSyntaxException;
import org.eclipse.jet.xpath.inspector.ExpandedName;

public class XPathParser {
    private static final String STAR = "*";
    private final XPathFunctionResolver functionResolver;
    private final TokenInstance[] tokenInstances;
    private final String input;
    private int nextTokenIndex;
    private final NamespaceContext nsContext;

    public XPathParser(String input, XPathFunctionResolver functionResolver, NamespaceContext nsContext) throws XPathLexicalException {
        this.input = input;
        this.functionResolver = functionResolver;
        this.nsContext = nsContext;
        TokenInstance[] result = this.scanTokens(input);
        this.tokenInstances = result;
        this.nextTokenIndex = 0;
    }

    public XPathParser(String input, XPathFunctionResolver functionResolver) throws XPathLexicalException {
        this(input, functionResolver, null);
    }

    private TokenInstance[] scanTokens(String input) throws XPathLexicalException {
        XPathTokenScanner scan = new XPathTokenScanner(input);
        ArrayList<TokenInstance> tokens = new ArrayList<TokenInstance>();
        Token token = scan.nextToken();
        while (token != Token.EOF_TOKEN && token != Token.UNDEFINED_TOKEN) {
            tokens.add(new TokenInstance(token, scan.getTokenStart(), scan.getTokenEnd()));
            token = scan.nextToken();
        }
        if (token != Token.EOF_TOKEN) {
            throw new XPathLexicalException(String.valueOf(JET2Messages.XPath_UnrecognizedToken) + scan.getTokenStart());
        }
        TokenInstance[] result = tokens.toArray(new TokenInstance[tokens.size()]);
        return result;
    }

    public ExprNode primaryExpr() throws XPathSyntaxException {
        Token next = this.peekNext();
        ExprNode expr = null;
        if (next == XPathTokens.DOLLAR_SIGN) {
            expr = this.variableReference();
        } else if (next == XPathTokens.LITERAL) {
            expr = this.literal();
        } else if (next == XPathTokens.NUMBER) {
            expr = this.number();
        } else if (next == XPathTokens.LPAREN) {
            this.consumeToken();
            ExprNode result = this.expr();
            next = this.peekNext();
            if (next != XPathTokens.RPAREN) {
                throw new XPathSyntaxException(JET2Messages.XPath_Expected);
            }
            this.consumeToken();
            expr = result;
        } else if (next == XPathTokens.NCNAME && this.peek(2) == XPathTokens.LPAREN) {
            expr = this.functionCall();
        }
        return expr;
    }

    public ExprNode functionCall() throws XPathSyntaxException {
        Token name = this.peek(1);
        Token lparen = this.peek(2);
        if (name != XPathTokens.QNAME && name != XPathTokens.NCNAME && lparen != XPathTokens.LPAREN) {
            return null;
        }
        String functionName = this.consumeToken();
        this.consumeToken();
        ArrayList<ExprNode> args = new ArrayList<ExprNode>();
        Token t = this.peekNext();
        while (t != XPathTokens.RPAREN && !t.isEOF() && !t.isUndefined()) {
            args.add(this.expr());
            if (this.peekNext() == XPathTokens.COMMA) {
                this.consumeToken();
            } else if (this.peekNext() != XPathTokens.RPAREN) {
                throw new XPathSyntaxException(MessageFormat.format(JET2Messages.XPath_Expected, ")"));
            }
            t = this.peekNext();
        }
        if (this.peekNext() != XPathTokens.RPAREN) {
            throw new XPathSyntaxException(MessageFormat.format(JET2Messages.XPath_Expected, ", )"));
        }
        this.consumeToken();
        XPathFunction function = this.functionResolver.resolveFunction(functionName, args.size());
        if (function == null) {
            throw new XPathSyntaxException(MessageFormat.format(JET2Messages.XPath_UnknownFunction, functionName));
        }
        return new Function(functionName, function, args);
    }

    public ExprNode expr() throws XPathSyntaxException {
        return this.orExpr();
    }

    public ExprNode orExpr() throws XPathSyntaxException {
        ExprNode result = this.andExpr();
        while (this.peekNext() == XPathTokens.NCNAME && "or".equals(this.peekTokenText())) {
            this.consumeToken();
            ExprNode rightExpr = this.andExpr();
            result = new LogicalOp.Or(result, rightExpr);
        }
        return result;
    }

    public ExprNode andExpr() throws XPathSyntaxException {
        ExprNode result = this.equalityExpr();
        while (this.peekNext() == XPathTokens.NCNAME && "and".equals(this.peekTokenText())) {
            this.consumeToken();
            ExprNode rightExpr = this.equalityExpr();
            result = new LogicalOp.And(result, rightExpr);
        }
        return result;
    }

    public ExprNode equalityExpr() throws XPathSyntaxException {
        ExprNode result = this.relationalExpr();
        Token t = this.peekNext();
        while (t == XPathTokens.EQUALS || t == XPathTokens.NOT_EQUALS) {
            this.consumeToken();
            ExprNode rightExpr = this.relationalExpr();
            result = t == XPathTokens.EQUALS ? new RelOp.Eq(result, rightExpr) : new RelOp.NotEq(result, rightExpr);
            t = this.peekNext();
        }
        return result;
    }

    public ExprNode relationalExpr() throws XPathSyntaxException {
        ExprNode result = this.additiveExpr();
        Token t = this.peekNext();
        while (t == XPathTokens.LT || t == XPathTokens.LT_EQUALS || t == XPathTokens.GT || t == XPathTokens.GT_EQUALS) {
            this.consumeToken();
            ExprNode rightExpr = this.additiveExpr();
            if (t == XPathTokens.LT) {
                result = new RelOp.Lt(result, rightExpr);
            } else if (t == XPathTokens.LT_EQUALS) {
                result = new RelOp.Lte(result, rightExpr);
            } else if (t == XPathTokens.GT) {
                result = new RelOp.Gt(result, rightExpr);
            } else if (t == XPathTokens.GT_EQUALS) {
                result = new RelOp.Gte(result, rightExpr);
            }
            t = this.peekNext();
        }
        return result;
    }

    public ExprNode additiveExpr() throws XPathSyntaxException {
        ExprNode result = this.multiplicativeExpr();
        Token t = this.peekNext();
        while (t == XPathTokens.PLUS_SIGN || t == XPathTokens.HYPHEN) {
            this.consumeToken();
            ExprNode rightExpr = this.multiplicativeExpr();
            if (t == XPathTokens.PLUS_SIGN) {
                result = new BinaryOp.Add(result, rightExpr);
            } else if (t == XPathTokens.HYPHEN) {
                result = new BinaryOp.Subtract(result, rightExpr);
            }
            t = this.peekNext();
        }
        return result;
    }

    public ExprNode multiplicativeExpr() throws XPathSyntaxException {
        ExprNode result = this.unaryExpr();
        Token t = this.peekNext();
        while (t == XPathTokens.ASTERISK || t == XPathTokens.NCNAME && "mod".equals(this.peekTokenText()) || t == XPathTokens.NCNAME && "div".equals(this.peekTokenText())) {
            String op = this.consumeToken();
            ExprNode rightExpr = this.unaryExpr();
            if (t == XPathTokens.ASTERISK) {
                result = new BinaryOp.Multiply(result, rightExpr);
            } else if ("mod".equals(op)) {
                result = new BinaryOp.Mod(result, rightExpr);
            } else if ("div".equals(op)) {
                result = new BinaryOp.Div(result, rightExpr);
            }
            t = this.peekNext();
        }
        return result;
    }

    public ExprNode unaryExpr() throws XPathSyntaxException {
        int unaryMinusCount = 0;
        Token t = this.peekNext();
        while (t == XPathTokens.HYPHEN) {
            this.consumeToken();
            ++unaryMinusCount;
            t = this.peekNext();
        }
        ExprNode result = this.unionExpr();
        int i = 0;
        while (i < unaryMinusCount) {
            result = new UnaryMinus(result);
            ++i;
        }
        return result;
    }

    public ExprNode unionExpr() throws XPathSyntaxException {
        ExprNode result = this.pathExpr();
        Token t = this.peekNext();
        while (t == XPathTokens.OR_BAR) {
            this.consumeToken();
            NodeSetExpr leftExpr = this.castToNodeSetExpr(result);
            NodeSetExpr rightExpr = this.castToNodeSetExpr(this.pathExpr());
            result = new UnionExpr(leftExpr, rightExpr);
            t = this.peekNext();
        }
        return result;
    }

    public ExprNode predicate() throws XPathSyntaxException {
        if (this.peekNext() != XPathTokens.LBRACKET) {
            return null;
        }
        this.consumeToken();
        ExprNode expr = this.expr();
        if (this.peekNext() != XPathTokens.RBRACKET) {
            throw new XPathSyntaxException(MessageFormat.format(JET2Messages.XPath_Expected, "]"));
        }
        this.consumeToken();
        return expr;
    }

    public NodeSetExpr locationPath() throws XPathSyntaxException {
        NodeSetExpr anchorNode;
        boolean optionalRelativeLocationPath = false;
        if (this.peekNext() == XPathTokens.SLASH) {
            this.consumeToken();
            anchorNode = new Root();
            optionalRelativeLocationPath = true;
        } else if (this.peekNext() == XPathTokens.SLASH_SLASH) {
            this.consumeToken();
            anchorNode = new Step(new Root(), Axis.descendantOrSelf(), NodeTest.allNodes());
        } else {
            anchorNode = new ContextNode();
        }
        NodeSetExpr relativeLocationPath = this.relativeLocationPath(anchorNode);
        if (optionalRelativeLocationPath && relativeLocationPath == null) {
            return anchorNode;
        }
        if (relativeLocationPath != null) {
            return relativeLocationPath;
        }
        throw new XPathSyntaxException("Expected: relative location path");
    }

    private NodeSetExpr relativeLocationPath(NodeSetExpr left) throws XPathSyntaxException {
        NodeSetExpr result = this.step(left);
        if (result != null) {
            while (true) {
                if (this.peekNext() == XPathTokens.SLASH) {
                    this.consumeToken();
                    result = this.step(result);
                    continue;
                }
                if (this.peekNext() != XPathTokens.SLASH_SLASH) break;
                this.consumeToken();
                result = this.step(new Step(result, Axis.descendantOrSelf(), NodeTest.allNodes()));
            }
        }
        return result;
    }

    public ExprNode pathExpr() throws XPathSyntaxException {
        ExprNode filterExpr = this.filterExpr();
        if (filterExpr != null) {
            if (this.peekNext() == XPathTokens.SLASH) {
                this.consumeToken();
                return this.relativeLocationPath(this.castToNodeSetExpr(filterExpr));
            }
            if (this.peekNext() == XPathTokens.SLASH_SLASH) {
                this.consumeToken();
                return this.relativeLocationPath(new Step(this.castToNodeSetExpr(filterExpr), Axis.descendantOrSelf(), NodeTest.allNodes()));
            }
            return filterExpr;
        }
        return this.locationPath();
    }

    public NodeSetExpr step(NodeSetExpr leftNodeExpr) throws XPathSyntaxException {
        String ncName;
        NodeTest nodeTest;
        if (this.peekNext() == XPathTokens.DOT) {
            this.consumeToken();
            return new Step(leftNodeExpr, Axis.selfAxis(), NodeTest.allNodes());
        }
        if (this.peekNext() == XPathTokens.DOT_DOT) {
            this.consumeToken();
            return new Step(leftNodeExpr, Axis.parentAxis(), NodeTest.allNodes());
        }
        Axis axis = Axis.childAxis();
        boolean axisSet = false;
        if (this.peekNext() == XPathTokens.AT_SIGN) {
            this.consumeToken();
            axis = Axis.attributeAxis();
            axisSet = true;
        } else if (this.peek(1) == XPathTokens.NCNAME && this.peek(2) == XPathTokens.COLON_COLON) {
            String axisName = this.consumeToken();
            this.consumeToken();
            axis = Axis.axisByName(axisName);
            if (axis == null) {
                throw new XPathSyntaxException(String.valueOf(JET2Messages.XPath_UnknownAxis) + axisName);
            }
            axisSet = true;
        }
        if (this.peekNext() == XPathTokens.ASTERISK) {
            this.consumeToken();
            nodeTest = NodeTest.nameTest(axis.principalNodeKind(), new ExpandedName(STAR));
        } else if (this.peek(1) == XPathTokens.NCNAME && this.peek(2) == XPathTokens.COLON && this.peek(3) == XPathTokens.ASTERISK) {
            ncName = this.consumeToken();
            this.consumeToken();
            this.consumeToken();
            nodeTest = NodeTest.nameTest(axis.principalNodeKind(), new ExpandedName(ncName, STAR));
        } else if (this.peekNext() == XPathTokens.QNAME) {
            String nsURI;
            String qName = this.consumeToken();
            int colonPos = qName.indexOf(58);
            String prefix = qName.substring(0, colonPos);
            String string = nsURI = this.nsContext == null ? null : this.nsContext.getNamespaceURI(prefix);
            if (nsURI == null) {
                throw new XPathSyntaxException(MessageFormat.format(JET2Messages.XPath_UnknownNSPrefix, prefix));
            }
            nodeTest = NodeTest.nameTest(axis.principalNodeKind(), new ExpandedName(nsURI, qName.substring(colonPos + 1)));
        } else if (this.peek(1) == XPathTokens.NCNAME && this.peek(2) == XPathTokens.LPAREN) {
            ncName = this.consumeToken();
            this.consumeToken();
            if ("node".equals(ncName)) {
                nodeTest = NodeTest.allNodes();
            } else if ("comment".equals(ncName)) {
                nodeTest = NodeTest.commentNodes();
            } else if ("text".equals(ncName)) {
                nodeTest = NodeTest.textNodes();
            } else if ("processing-instruction".equals(ncName)) {
                String literal = null;
                if (this.peekNext() == XPathTokens.LITERAL) {
                    String rawLiteral = this.consumeToken();
                    literal = rawLiteral.substring(1, rawLiteral.length() - 1);
                }
                nodeTest = literal != null ? NodeTest.processingInstructionNodes(literal) : NodeTest.allProcessingInstructionNodes();
            } else {
                throw new XPathSyntaxException(String.valueOf(JET2Messages.XPath_UnknownNodeTest) + ncName);
            }
            if (this.peekNext() != XPathTokens.RPAREN) {
                throw new XPathSyntaxException(MessageFormat.format(JET2Messages.XPath_Expected, ")"));
            }
            this.consumeToken();
        } else if (this.peekNext() == XPathTokens.NCNAME) {
            ncName = this.consumeToken();
            nodeTest = NodeTest.nameTest(axis.principalNodeKind(), new ExpandedName(ncName));
        } else {
            if (axisSet) {
                throw new XPathSyntaxException(MessageFormat.format(JET2Messages.XPath_Expected, "*, NCNAME, QNAME, NCNAME::*"));
            }
            return null;
        }
        NodeSetExpr result = new Step(leftNodeExpr, axis, nodeTest);
        ExprNode predicate = null;
        while ((predicate = this.predicate()) != null) {
            result = new Predicate(result, predicate);
        }
        return result;
    }

    public ExprNode filterExpr() throws XPathSyntaxException {
        ExprNode primaryExpr = this.primaryExpr();
        if (this.peekNext() == XPathTokens.LBRACKET) {
            NodeSetExpr expr = this.castToNodeSetExpr(primaryExpr);
            ExprNode predicate = null;
            while ((predicate = this.predicate()) != null) {
                expr = new Predicate(expr, predicate);
            }
            return expr;
        }
        return primaryExpr;
    }

    private NodeSetExpr castToNodeSetExpr(ExprNode expr) throws XPathSyntaxException {
        if (expr instanceof NodeSetExpr) {
            return (NodeSetExpr)expr;
        }
        if (expr instanceof Variable || expr instanceof Function) {
            return new NodeSetCast(expr);
        }
        throw new XPathSyntaxException(JET2Messages.XPath_ExpressionMustBeNodeSet);
    }

    public ExprNode number() {
        if (this.peekNext() != XPathTokens.NUMBER) {
            return null;
        }
        String literal = this.consumeToken();
        return new NumberLiteral(Double.valueOf(literal));
    }

    public ExprNode literal() {
        if (this.peekNext() != XPathTokens.LITERAL) {
            return null;
        }
        String literal = this.consumeToken();
        return new StringLiteral(literal.substring(1, literal.length() - 1));
    }

    public ExprNode variableReference() throws XPathSyntaxException {
        Token token = this.peekNext();
        if (token != XPathTokens.DOLLAR_SIGN) {
            return null;
        }
        this.consumeToken();
        if (this.peekNext() != XPathTokens.QNAME && this.peekNext() != XPathTokens.NCNAME) {
            throw new XPathSyntaxException(MessageFormat.format(JET2Messages.XPath_Expected, "QName NCName"));
        }
        String variableName = this.consumeToken();
        return new Variable(variableName);
    }

    private String consumeToken() {
        if (this.nextTokenIndex >= this.tokenInstances.length) {
            throw new IllegalStateException();
        }
        TokenInstance ti = this.tokenInstances[this.nextTokenIndex++];
        return ti.getTokenText(this.input);
    }

    public Token peekNext() {
        return this.peek(1);
    }

    private Token peek(int i) {
        int index = this.nextTokenIndex + i - 1;
        return index >= this.tokenInstances.length ? Token.EOF_TOKEN : this.tokenInstances[index].token;
    }

    private String peekTokenText() {
        return this.nextTokenIndex >= this.tokenInstances.length ? null : this.tokenInstances[this.nextTokenIndex].getTokenText(this.input);
    }
}

