/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.compiler;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.jet.JET2Platform;
import org.eclipse.jet.compiler.CompileOptionsManager;
import org.eclipse.jet.core.compiler.JETCompilerOptions;
import org.eclipse.jet.core.parser.ITagLibraryResolver;
import org.eclipse.jet.core.parser.ITemplateResolver;
import org.eclipse.jet.core.parser.ast.JETASTParser;
import org.eclipse.jet.core.parser.ast.JETCompilationUnit;
import org.eclipse.jet.internal.InternalJET2Platform;
import org.eclipse.jet.internal.compiler.TemplateRunner;
import org.eclipse.jet.internal.parser.resources.WorkspaceTemplateResolverBuilder;
import org.eclipse.jet.taglib.TagLibrary;
import org.eclipse.jet.taglib.TagLibraryManager;
import org.eclipse.jet.taglib.TagLibraryReference;
import org.eclipse.jet.transform.IJETBundleDescriptor;

public class CompilationHelper {
    private static final ITagLibraryResolver TAG_LIBRARY_RESOLVER = new ITagLibraryResolver(){

        public TagLibrary getLibrary(String tagLibraryID) {
            return TagLibraryManager.getInstance().getTagLibrary(tagLibraryID);
        }
    };
    private final IProject project;
    private IJETBundleDescriptor projectDescription;
    private Map options;
    private Map predefinedTagLibraryMap;
    private JETASTParser astParser;

    public CompilationHelper(IProject project) {
        if (project == null) {
            throw new NullPointerException();
        }
        if (!project.exists() || !project.isOpen()) {
            throw new IllegalArgumentException();
        }
        this.project = project;
    }

    public JETASTParser getASTParser() {
        if (this.astParser == null) {
            Map options = this.getOptions();
            int jetSpec = JETCompilerOptions.getIntOption((Map)options, (String)"org.eclipse.jet.jetSpecificationVersion");
            JETASTParser.Builder builder = new JETASTParser.Builder(jetSpec);
            builder.tagLibraryResolver(TAG_LIBRARY_RESOLVER);
            builder.templateResolver(this.buildTemplateResolver());
            builder.predefinedTagLibraries(this.getPredefinedTagLibraryMap());
            this.astParser = builder.build();
        }
        return this.astParser;
    }

    public JETCompilationUnit getAST(String templatePath) {
        return (JETCompilationUnit)this.getASTParser().parse(templatePath);
    }

    public JETCompilationUnit getASTFromSource(String source) {
        return (JETCompilationUnit)this.getASTParser().parse(source.toCharArray());
    }

    public String getJavaCode(JETCompilationUnit ast) {
        this.ensurePackageAndClassSet(ast);
        TemplateRunner templateRunner = new TemplateRunner();
        String cgTemplatePath = this.getJetVersion() == 1 ? "templates/v1/jet2java.jet" : "templates/v2/jet2java.jet";
        String code = templateRunner.generate(cgTemplatePath, Collections.singletonMap("cu", ast));
        return code;
    }

    private void ensurePackageAndClassSet(JETCompilationUnit ast) {
        if (ast.getOutputJavaPackage() == null) {
            ast.setOutputJavaPackage(JETCompilerOptions.getStringOption((Map)this.getOptions(), (String)"org.eclipse.jet.compiledTemplatePackage"));
        }
        if (ast.getOutputJavaClassName() == null) {
            ast.setOutputJavaClassName("_jet_Unkonwn_");
        }
    }

    public String getJavaCode(JETCompilationUnit ast, Map javaElementPositionMap) {
        HashMap<String, Object> arguments = new HashMap<String, Object>(2);
        arguments.put("cu", ast);
        arguments.put("positionMap", javaElementPositionMap);
        TemplateRunner templateRunner = new TemplateRunner();
        String cgTemplatePath = this.getJetVersion() == 1 ? "templates/v1/jet2java.jet" : "templates/v2/jet2java.jet";
        String code = templateRunner.generate(cgTemplatePath, arguments);
        return code;
    }

    public int getJetVersion() {
        return JETCompilerOptions.getIntOption((Map)this.getOptions(), (String)"org.eclipse.jet.jetSpecificationVersion");
    }

    public Map getOptions() {
        if (this.options == null) {
            this.options = CompileOptionsManager.getOptions(this.project);
        }
        return this.options;
    }

    public Map getPredefinedTagLibraryMap() {
        if (this.predefinedTagLibraryMap == null) {
            IJETBundleDescriptor descriptor = this.getDescriptor();
            if (descriptor != null) {
                TagLibraryReference[] tagLibraryReferences = descriptor.getTagLibraryReferences();
                this.predefinedTagLibraryMap = new HashMap(tagLibraryReferences.length);
                int i = 0;
                while (i < tagLibraryReferences.length) {
                    if (tagLibraryReferences[i].isAutoImport()) {
                        this.predefinedTagLibraryMap.put(tagLibraryReferences[i].getPrefix(), tagLibraryReferences[i].getTagLibraryId());
                    }
                    ++i;
                }
            } else {
                this.predefinedTagLibraryMap = Collections.EMPTY_MAP;
            }
        }
        return this.predefinedTagLibraryMap;
    }

    private IJETBundleDescriptor getDescriptor() {
        if (this.projectDescription == null) {
            this.projectDescription = JET2Platform.getProjectDescription(this.project.getName());
        }
        return this.projectDescription;
    }

    private ITemplateResolver buildTemplateResolver() {
        Map options = this.getOptions();
        WorkspaceTemplateResolverBuilder templateResolverWorkspaceTemplateResolverBuilder = new WorkspaceTemplateResolverBuilder(this.project);
        URI[] altBaseLocations = this.getAltBaseLocations(options);
        if (altBaseLocations.length > 0) {
            templateResolverWorkspaceTemplateResolverBuilder.addAltBaseLocations(altBaseLocations);
        }
        ITemplateResolver templateResolver = templateResolverWorkspaceTemplateResolverBuilder.build();
        return templateResolver;
    }

    private URI[] getAltBaseLocations(Map options) {
        String value = JETCompilerOptions.getStringOption((Map)options, (String)"org.eclipse.jet.v1BaseTransformationID");
        if (value == null || value.trim().length() == 0) {
            return new URI[0];
        }
        String[] uriStrings = value.split(",");
        ArrayList<URI> altLocations = new ArrayList<URI>(uriStrings.length);
        int i = 0;
        while (i < uriStrings.length) {
            String uriString = uriStrings[i].endsWith("/") ? uriStrings[i] : String.valueOf(uriStrings[i]) + "/";
            try {
                URI uri = new URI(uriString);
                altLocations.add(uri);
            }
            catch (URISyntaxException e) {
                InternalJET2Platform.logError(null, e);
            }
            ++i;
        }
        return altLocations.toArray(new URI[altLocations.size()]);
    }
}

