/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.xpath.inspectors;

import org.eclipse.jet.internal.l10n.JET2Messages;
import org.eclipse.jet.xpath.inspector.AddElementException;
import org.eclipse.jet.xpath.inspector.CopyElementException;
import org.eclipse.jet.xpath.inspector.ExpandedName;
import org.eclipse.jet.xpath.inspector.IElementInspector;
import org.eclipse.jet.xpath.inspector.INodeInspector;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DOMInspector
implements INodeInspector,
IElementInspector {
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];

    public INodeInspector.NodeKind getNodeKind(Object obj) {
        INodeInspector.NodeKind result = null;
        if (obj instanceof Node) {
            Node node = (Node)obj;
            switch (node.getNodeType()) {
                case 2: {
                    result = INodeInspector.NodeKind.ATTRIBUTE;
                    break;
                }
                case 8: {
                    result = INodeInspector.NodeKind.COMMENT;
                    break;
                }
                case 9: {
                    result = INodeInspector.NodeKind.ROOT;
                    break;
                }
                case 1: {
                    result = INodeInspector.NodeKind.ELEMENT;
                    break;
                }
                case 7: {
                    result = INodeInspector.NodeKind.PROCESSING_INSTRUCTION;
                    break;
                }
                case 3: 
                case 4: {
                    result = INodeInspector.NodeKind.TEXT;
                }
            }
        }
        return result;
    }

    public Object getParent(Object obj) {
        Node result = null;
        if (obj instanceof Node) {
            Node node = (Node)obj;
            switch (node.getNodeType()) {
                case 2: {
                    result = ((Attr)node).getOwnerElement();
                    break;
                }
                default: {
                    result = node.getParentNode();
                }
            }
        }
        return result;
    }

    public String stringValueOf(Object obj) {
        String result = null;
        if (obj instanceof Node) {
            Node node = (Node)obj;
            switch (node.getNodeType()) {
                case 2: 
                case 3: 
                case 4: 
                case 7: 
                case 8: {
                    result = node.getNodeValue();
                    break;
                }
                case 1: 
                case 9: {
                    StringBuffer buffer = new StringBuffer();
                    this.textForNode(buffer, node);
                    result = buffer.toString();
                }
            }
        }
        return result;
    }

    private void textForNode(StringBuffer buffer, Node node) {
        NodeList childNodes = node.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node childNode = childNodes.item(i);
            switch (childNode.getNodeType()) {
                case 3: 
                case 4: {
                    buffer.append(childNode.getNodeValue());
                    break;
                }
                case 1: {
                    this.textForNode(buffer, childNode);
                }
            }
            ++i;
        }
    }

    public ExpandedName expandedNameOf(Object obj) {
        ExpandedName result = null;
        if (obj instanceof Node) {
            Node node = (Node)obj;
            switch (node.getNodeType()) {
                case 1: 
                case 2: {
                    String localName = node.getLocalName();
                    if (localName != null) {
                        result = new ExpandedName(node.getNamespaceURI(), localName);
                        break;
                    }
                    result = new ExpandedName(node.getNodeName());
                    break;
                }
                case 7: {
                    result = new ExpandedName(node.getNodeName());
                }
            }
        }
        return result;
    }

    public Object[] getAttributes(Object contextNode) {
        Node node;
        NamedNodeMap attributes;
        Object[] result = EMPTY_OBJECT_ARRAY;
        if (contextNode instanceof Node && (attributes = (node = (Node)contextNode).getAttributes()) != null) {
            result = new Object[attributes.getLength()];
            int i = 0;
            while (i < attributes.getLength()) {
                result[i] = attributes.item(i);
                ++i;
            }
        }
        return result;
    }

    public Object getDocumentRoot(Object contextNode) {
        Object result = null;
        if (contextNode instanceof Document) {
            result = contextNode;
        } else if (contextNode instanceof Node) {
            result = ((Node)contextNode).getOwnerDocument();
        }
        return result;
    }

    public Object[] getChildren(Object contextNode) {
        Object[] result = EMPTY_OBJECT_ARRAY;
        if (contextNode instanceof Node) {
            Node node = (Node)contextNode;
            switch (node.getNodeType()) {
                case 1: 
                case 9: {
                    NodeList childNodes = node.getChildNodes();
                    int nonAttributeChildCount = 0;
                    int i = 0;
                    while (i < childNodes.getLength()) {
                        if (childNodes.item(i).getNodeType() != 2) {
                            ++nonAttributeChildCount;
                        }
                        ++i;
                    }
                    result = new Object[nonAttributeChildCount];
                    int resultIndex = 0;
                    int i2 = 0;
                    while (i2 < childNodes.getLength()) {
                        if (childNodes.item(i2).getNodeType() != 2) {
                            result[resultIndex] = childNodes.item(i2);
                            ++resultIndex;
                        }
                        ++i2;
                    }
                    break;
                }
            }
        }
        return result;
    }

    public String nameOf(Object contextNode) {
        String result = null;
        if (contextNode instanceof Node) {
            Node node = (Node)contextNode;
            switch (node.getNodeType()) {
                case 1: 
                case 2: 
                case 7: {
                    result = node.getNodeName();
                }
            }
        }
        return result;
    }

    public Object getNamedAttribute(Object contextNode, ExpandedName nameTestExpandedName) {
        Node node = (Node)contextNode;
        String nsURI = nameTestExpandedName.getNamespaceURI();
        if (nsURI == null) {
            Node namedItem = node.getAttributes().getNamedItem(nameTestExpandedName.getLocalPart());
            if (namedItem == null) {
                namedItem = node.getAttributes().getNamedItem(nameTestExpandedName.getLocalPart());
            }
            return namedItem;
        }
        return node.getAttributes().getNamedItemNS(nsURI, nameTestExpandedName.getLocalPart());
    }

    public boolean createAttribute(Object contextNode, String attributeName, String value) {
        Element element = (Element)contextNode;
        element.setAttribute(attributeName, value);
        return true;
    }

    public Object addElement(Object contextNode, ExpandedName elementName, Object addBeforeThisSibling) {
        Element element = (Element)contextNode;
        if (addBeforeThisSibling != null && !(addBeforeThisSibling instanceof Node)) {
            throw new IllegalStateException();
        }
        Node addBeforeThisNode = (Node)addBeforeThisSibling;
        String nsURI = elementName.getNamespaceURI();
        String localName = elementName.getLocalPart();
        Element newChild = null;
        newChild = nsURI == null ? element.getOwnerDocument().createElement(localName) : element.getOwnerDocument().createElementNS(nsURI, localName);
        if (addBeforeThisSibling == null) {
            element.appendChild(newChild);
        } else {
            element.insertBefore(newChild, addBeforeThisNode);
        }
        return newChild;
    }

    public void removeElement(Object contextNode) {
        Element element = (Element)contextNode;
        Node parent = element.getParentNode();
        if (parent != null) {
            parent.removeChild(element);
        }
    }

    public Object copyElement(Object tgtParent, Object srcElement, String name, boolean recursive) throws CopyElementException {
        Element parentElement = (Element)tgtParent;
        Element newElement = null;
        Document ownerDocument = parentElement.getOwnerDocument();
        if (srcElement instanceof Element) {
            Element source = (Element)srcElement;
            if (!name.equals(source.getLocalName())) {
                newElement = ownerDocument.createElement(name);
                NodeList childNodes = source.getChildNodes();
                int i = 0;
                while (i < childNodes.getLength()) {
                    newElement.appendChild(ownerDocument.importNode(childNodes.item(i), true));
                    ++i;
                }
                NamedNodeMap attributes = source.getAttributes();
                int i2 = 0;
                while (i2 < attributes.getLength()) {
                    newElement.setAttributeNodeNS((Attr)ownerDocument.importNode(attributes.item(i2), false));
                    ++i2;
                }
                parentElement.appendChild(newElement);
            } else {
                newElement = (Element)ownerDocument.importNode(source, recursive);
                parentElement.appendChild(newElement);
            }
        } else if (srcElement instanceof Document) {
            newElement = ownerDocument.createElement(name);
            NodeList childNodes = ((Document)srcElement).getChildNodes();
            int i = 0;
            while (i < childNodes.getLength()) {
                newElement.appendChild(ownerDocument.importNode(childNodes.item(i), true));
                ++i;
            }
            parentElement.appendChild(newElement);
        } else {
            throw new CopyElementException(JET2Messages.DOMInspector_NotDOMObject);
        }
        return newElement;
    }

    public Object addTextElement(Object parentElementObject, String name, String bodyContent, boolean asCData) throws AddElementException {
        Element parentElement = (Element)parentElementObject;
        Element newElement = parentElement.getOwnerDocument().createElement(name);
        Text text = asCData ? parentElement.getOwnerDocument().createTextNode(bodyContent) : parentElement.getOwnerDocument().createCDATASection(bodyContent);
        newElement.appendChild(text);
        parentElement.appendChild(newElement);
        return newElement;
    }

    public void removeAttribute(Object object, String name) {
        Element element = (Element)object;
        element.removeAttribute(name);
    }

    public boolean testExpandedName(Object node, ExpandedName testName) {
        String localName;
        boolean match = testName.equals(this.expandedNameOf(node));
        if (!match && (localName = ((Node)node).getLocalName()) != null) {
            match = testName.equals(new ExpandedName(localName));
        }
        return match;
    }
}

