/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.shared.ui.core.search;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.internal.xpand2.ast.Definition;
import org.eclipse.internal.xpand2.ast.ExpandStatement;
import org.eclipse.internal.xpand2.ast.Template;
import org.eclipse.internal.xpand2.model.XpandDefinition;
import org.eclipse.internal.xtend.expression.ast.Identifier;
import org.eclipse.internal.xtend.expression.ast.OperationCall;
import org.eclipse.internal.xtend.expression.ast.SyntaxElement;
import org.eclipse.internal.xtend.xtend.ast.AbstractExtension;
import org.eclipse.internal.xtend.xtend.ast.Extension;
import org.eclipse.internal.xtend.xtend.ast.ExtensionFile;
import org.eclipse.xtend.shared.ui.Activator;
import org.eclipse.xtend.shared.ui.core.IXtendXpandProject;
import org.eclipse.xtend.shared.ui.core.IXtendXpandResource;
import org.eclipse.xtend.shared.ui.core.search.SearchMatch;
import org.eclipse.xtend.shared.ui.internal.XtendLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XtendXpandSearchEngine {
    public static List<Definition> findAllDefines(IXtendXpandProject project) {
        IXtendXpandResource[] resources;
        ArrayList<Definition> matches = new ArrayList<Definition>();
        IXtendXpandResource[] iXtendXpandResourceArray = resources = project.getRegisteredResources();
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IXtendXpandResource res = iXtendXpandResourceArray[n2];
            if (res.getExtXptResource() instanceof Template) {
                Template tpl = (Template)res.getExtXptResource();
                XpandDefinition[] xpandDefinitionArray = tpl.getDefinitions();
                int n3 = xpandDefinitionArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    XpandDefinition xdef = xpandDefinitionArray[n4];
                    if (xdef instanceof Definition) {
                        Definition def = (Definition)xdef;
                        matches.add(def);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return matches;
    }

    public static List<SearchMatch> findAllOccurrences(IXtendXpandProject project, String identifier) {
        IXtendXpandResource[] resources;
        ArrayList<SearchMatch> matches = new ArrayList<SearchMatch>();
        IXtendXpandResource[] iXtendXpandResourceArray = resources = project.getRegisteredResources();
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IXtendXpandResource res = iXtendXpandResourceArray[n2];
            if (res.getExtXptResource() instanceof Template) {
                Template tpl = (Template)res.getExtXptResource();
                XpandDefinition[] xpandDefinitionArray = tpl.getDefinitions();
                int n3 = xpandDefinitionArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    Definition def;
                    XpandDefinition xdef = xpandDefinitionArray[n4];
                    if (xdef instanceof Definition && (def = (Definition)xdef).getName().equals(identifier)) {
                        int startOfDefnitionName = def.getDefName().getStart() - 1;
                        int lengthOfDefinitionName = def.getDefName().getEnd() - def.getDefName().getStart();
                        matches.add(new SearchMatch(startOfDefnitionName, lengthOfDefinitionName, res.getUnderlyingStorage()));
                    }
                    ++n4;
                }
            }
            Set<ExpandStatement> ops = XtendXpandSearchEngine.findRec(res.getExtXptResource(), ExpandStatement.class, new HashSet<Object>());
            for (ExpandStatement expr : ops) {
                Identifier definition = expr.getDefinition();
                String definitionFQN = definition.getValue();
                int lastIndexOf = definitionFQN.lastIndexOf(identifier);
                if (lastIndexOf <= -1) continue;
                int startOfDefinition = definition.getStart() + lastIndexOf - 1;
                int lengthOfDefinition = identifier.length();
                matches.add(new SearchMatch(startOfDefinition, lengthOfDefinition, res.getUnderlyingStorage()));
            }
            ++n2;
        }
        iXtendXpandResourceArray = project.getProject().getProject().getReferencingProjects();
        n = iXtendXpandResourceArray.length;
        n2 = 0;
        while (n2 < n) {
            IXtendXpandResource p = iXtendXpandResourceArray[n2];
            IXtendXpandProject extxptp = Activator.getExtXptModelManager().findProject((IResource)p);
            if (extxptp != null) {
                matches.addAll(XtendXpandSearchEngine.findAllOccurrences(extxptp, identifier));
            }
            ++n2;
        }
        return XtendXpandSearchEngine.sort(matches);
    }

    public static List<SearchMatch> findReferences(IXtendXpandProject project, String identifier) {
        IXtendXpandResource[] resources;
        ArrayList<SearchMatch> matches = new ArrayList<SearchMatch>();
        IXtendXpandResource[] iXtendXpandResourceArray = resources = project.getRegisteredResources();
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IXtendXpandResource res = iXtendXpandResourceArray[n2];
            Set<OperationCall> ops = XtendXpandSearchEngine.findRec(res.getExtXptResource(), OperationCall.class, new HashSet<Object>());
            for (OperationCall expr : ops) {
                if (!expr.getName().getValue().equals(identifier)) continue;
                matches.add(new SearchMatch(expr.getName().getStart(), expr.getName().getEnd() - expr.getStart() - 1, res.getUnderlyingStorage()));
            }
            ++n2;
        }
        iXtendXpandResourceArray = project.getProject().getProject().getReferencingProjects();
        n = iXtendXpandResourceArray.length;
        n2 = 0;
        while (n2 < n) {
            IXtendXpandResource p = iXtendXpandResourceArray[n2];
            IXtendXpandProject extxptp = Activator.getExtXptModelManager().findProject((IResource)p);
            if (extxptp != null) {
                matches.addAll(XtendXpandSearchEngine.findReferences(extxptp, identifier));
            }
            ++n2;
        }
        return XtendXpandSearchEngine.sort(matches);
    }

    public static List<SearchMatch> findDeclarations(IXtendXpandProject project, String identifier) {
        IXtendXpandResource[] resources;
        ArrayList<SearchMatch> matches = new ArrayList<SearchMatch>();
        IXtendXpandResource[] iXtendXpandResourceArray = resources = project.getRegisteredResources();
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IXtendXpandResource res = iXtendXpandResourceArray[n2];
            if (res.getExtXptResource() instanceof ExtensionFile) {
                ExtensionFile ef = (ExtensionFile)res.getExtXptResource();
                for (Extension ext : ef.getExtensions()) {
                    if (!(ext instanceof AbstractExtension)) continue;
                    AbstractExtension ae = (AbstractExtension)ext;
                    if (!ext.getName().equals(identifier)) continue;
                    Identifier id = ae.getNameIdentifier();
                    matches.add(new SearchMatch(id.getStart(), id.getEnd() - id.getStart() + 1, res.getUnderlyingStorage()));
                }
            }
            if (res.getExtXptResource() instanceof Template) {
                Template tpl = (Template)res.getExtXptResource();
                XpandDefinition[] xpandDefinitionArray = tpl.getDefinitions();
                int n3 = xpandDefinitionArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    Definition def;
                    XpandDefinition xdef = xpandDefinitionArray[n4];
                    if (xdef instanceof Definition && (def = (Definition)xdef).getName().equals(identifier)) {
                        matches.add(new SearchMatch(def.getDefName().getStart(), def.getDefName().getEnd() - def.getDefName().getStart(), res.getUnderlyingStorage()));
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        try {
            iXtendXpandResourceArray = project.getProject().getProject().getReferencedProjects();
            n = iXtendXpandResourceArray.length;
            n2 = 0;
            while (n2 < n) {
                IXtendXpandResource p = iXtendXpandResourceArray[n2];
                IXtendXpandProject extxptp = Activator.getExtXptModelManager().findProject((IResource)p);
                if (extxptp != null) {
                    matches.addAll(XtendXpandSearchEngine.findDeclarations(extxptp, identifier));
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            XtendLog.logError(e);
        }
        return XtendXpandSearchEngine.sort(matches);
    }

    private static List<SearchMatch> sort(List<SearchMatch> searchmatches) {
        Collections.sort(searchmatches, new Comparator<SearchMatch>(){

            @Override
            public int compare(SearchMatch o1, SearchMatch o2) {
                if (o1.getFile() == null) {
                    return -1;
                }
                if (o2.getFile() == null) {
                    return 1;
                }
                int fileCompare = o1.getFile().getName().compareTo(o2.getFile().getName());
                if (fileCompare == 0) {
                    return Integer.valueOf(o1.getOffSet()).compareTo(o2.getOffSet());
                }
                return fileCompare;
            }
        });
        return searchmatches;
    }

    private static <T extends SyntaxElement> Set<T> findRec(Object res, Class<T> clazz, Set<Object> visitedNodes) {
        Method[] methods;
        if (visitedNodes.contains(res)) {
            return Collections.emptySet();
        }
        visitedNodes.add(res);
        HashSet<Object> result = new HashSet<Object>();
        if (clazz.isInstance(res)) {
            result.add((SyntaxElement)res);
        }
        Class<?> instanceClass = res.getClass();
        Method[] methodArray = methods = instanceClass.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> pType;
            Method method = methodArray[n2];
            int mod = method.getModifiers();
            if (Modifier.isPublic(mod) && !Modifier.isStatic(mod) && method.getName().startsWith("get") && method.getParameterTypes().length == 0 && (Collection.class.isAssignableFrom(pType = method.getReturnType()) || SyntaxElement.class.isAssignableFrom(pType))) {
                try {
                    Object invRes = method.invoke(res, new Object[0]);
                    if (invRes instanceof Collection) {
                        for (Object o : (Collection)invRes) {
                            result.addAll(XtendXpandSearchEngine.findRec(o, clazz, visitedNodes));
                        }
                    } else if (invRes != null) {
                        result.addAll(XtendXpandSearchEngine.findRec(invRes, clazz, visitedNodes));
                    }
                }
                catch (Exception e) {
                    XtendLog.logError(e);
                }
            }
            ++n2;
        }
        return result;
    }
}

