/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.parser.resources;

import java.net.URI;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jet.core.parser.ITemplateResolverHelper;
import org.eclipse.jet.core.parser.ITemplateResolverHelperFactory;
import org.eclipse.jet.internal.parser.resources.ResourceTemplateResolverHelper;

public class WorkspaceTemplateResolverHelperFactory
implements ITemplateResolverHelperFactory {
    private static final WorkspaceTemplateResolverHelperFactory instance = new WorkspaceTemplateResolverHelperFactory();

    public static ITemplateResolverHelperFactory getInstance() {
        return instance;
    }

    private WorkspaceTemplateResolverHelperFactory() {
    }

    public ITemplateResolverHelper getTemplateResolverHelper(URI baseLocation) {
        IContainer container = this.getWorkspaceContainer(baseLocation);
        ResourceTemplateResolverHelper helper = null;
        if (container != null) {
            helper = new ResourceTemplateResolverHelper(container);
        }
        return helper;
    }

    private IContainer getWorkspaceContainer(URI baseLocation) {
        if ("platform".equals(baseLocation.getScheme())) {
            Path p = new Path(baseLocation.getSchemeSpecificPart());
            if ("resource".equals(p.segment(0))) {
                p = p.removeFirstSegments(1);
                IResource member = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)p);
                return member instanceof IContainer ? (IContainer)member : null;
            }
            return null;
        }
        IContainer[] containers = ResourcesPlugin.getWorkspace().getRoot().findContainersForLocationURI(baseLocation);
        return containers.length > 0 ? containers[0] : null;
    }
}

