/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.runtime;

import java.net.URL;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jet.internal.InternalJET2Platform;
import org.eclipse.jet.internal.l10n.JET2Messages;
import org.eclipse.jet.internal.runtime.DynamicJETBundleDescriptor;
import org.eclipse.jet.internal.runtime.IJETBundleProvider;
import org.eclipse.jet.internal.runtime.JETBundleManager;
import org.eclipse.jet.transform.IJETBundleDescriptor;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class DeployedJETBundleProvider
implements IJETBundleProvider,
IRegistryChangeListener {
    private static boolean DEBUG = InternalJET2Platform.getDefault().isDebugging() && Boolean.valueOf(Platform.getDebugOption((String)"org.eclipse.jet/debug/pluginBundleLoading")) != false;
    private static final String PLUGIN_ID = "org.eclipse.jet";
    private static final String EXTENSION_NAME = "deployedTransforms";
    private static final String EXTENSION_POINT_ID = "org.eclipse.jet.deployedTransforms";
    private static final String DEPLOYEDTRANSFORM_ELEMENT = "deployedTransform";
    private static final String ID_ATTRIBUTE = "id";
    private static final String BUNDLE_ATTRIBUTE = "bundle";
    private final Map descriptorsById = Collections.synchronizedMap(new HashMap());

    public Set getAllJETBundleIds() {
        return this.descriptorsById.keySet();
    }

    public IJETBundleDescriptor getDescriptor(String id) {
        return (IJETBundleDescriptor)this.descriptorsById.get(id);
    }

    public void shutdown() {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        reg.removeRegistryChangeListener((IRegistryChangeListener)this);
        this.descriptorsById.clear();
    }

    public void startup() {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] configElements = reg.getConfigurationElementsFor(EXTENSION_POINT_ID);
        this.addTransforms(configElements);
        reg.addRegistryChangeListener((IRegistryChangeListener)this, EXTENSION_POINT_ID);
    }

    public void registryChanged(IRegistryChangeEvent event) {
        IExtensionDelta[] deltas = event.getExtensionDeltas(EXTENSION_POINT_ID);
        int i = 0;
        while (i < deltas.length) {
            IExtension ext = deltas[i].getExtension();
            if (deltas[i].getKind() == 1) {
                this.addTransforms(ext.getConfigurationElements());
            } else {
                this.removeTransforms(ext.getConfigurationElements());
            }
            ++i;
        }
    }

    private void removeTransforms(IConfigurationElement[] configElements) {
        int i = 0;
        while (i < configElements.length) {
            String id;
            if (DEPLOYEDTRANSFORM_ELEMENT.equals(configElements[i].getName()) && (id = configElements[i].getAttribute(ID_ATTRIBUTE)) != null) {
                if (DEBUG) {
                    InternalJET2Platform.debugMessage(this, "removeTransforms(" + id + ")");
                }
                this.descriptorsById.remove(id);
            }
            ++i;
        }
    }

    private void addTransforms(IConfigurationElement[] configElements) {
        int i = 0;
        while (i < configElements.length) {
            if (DEPLOYEDTRANSFORM_ELEMENT.equals(configElements[i].getName())) {
                String jet2Bundle = configElements[i].getAttribute(BUNDLE_ATTRIBUTE);
                if (jet2Bundle != null) {
                    Bundle declaringBundle = Platform.getBundle((String)configElements[i].getDeclaringExtension().getNamespace());
                    URL bundleURL = declaringBundle.getEntry(jet2Bundle);
                    IJETBundleDescriptor descriptor = JETBundleManager.getJETBundleDescriptorForJAR(bundleURL);
                    if (descriptor != null) {
                        this.descriptorsById.put(descriptor.getId(), descriptor);
                        if (DEBUG) {
                            InternalJET2Platform.debugMessage(this, "addTransforms(" + descriptor.getId() + ", " + bundleURL + ")");
                        }
                    }
                } else {
                    String msg = JET2Messages.PluginDeployedTemplateBundleSupplier_BadExtensionElement;
                    InternalJET2Platform.log((IStatus)new Status(4, configElements[i].getDeclaringExtension().getNamespace(), 0, MessageFormat.format(msg, DEPLOYEDTRANSFORM_ELEMENT, EXTENSION_POINT_ID), null));
                }
            }
            ++i;
        }
    }

    public Bundle load(String id, IProgressMonitor monitor) throws BundleException {
        Bundle bundle = null;
        DynamicJETBundleDescriptor descriptor = (DynamicJETBundleDescriptor)this.getDescriptor(id);
        if (descriptor != null) {
            bundle = InternalJET2Platform.getDefault().getJETBundleInstaller().installBundle(descriptor.getBundleURL());
            if (DEBUG) {
                System.out.println("[deployedBundle] Loaded " + bundle.getSymbolicName());
            }
        }
        return bundle;
    }

    public void unload(String id) throws BundleException {
        if (this.descriptorsById.containsKey(id)) {
            Bundle bundle = Platform.getBundle((String)id);
            this.unload(bundle);
        }
    }

    public void unload(Bundle bundle) throws BundleException {
        if (bundle != null) {
            if (DEBUG) {
                System.out.println("[deployedBundle] Unloading " + bundle.getSymbolicName());
            }
            bundle.uninstall();
        }
    }

    public Collection getAllJETBundleDescriptors() {
        return this.descriptorsById.values();
    }
}

