/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.language;

import com.google.common.base.Strings;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Version
implements Comparable<Version> {
    private final Pattern VERSION_PATTERN = Pattern.compile("^(-?\\d+)(\\.\\d+)?(\\.\\d+)?(\\.[A-Za-z0-9_+\\-]+)?$");
    public static final Version ZERO = new Version(0, 0, 0, null);
    public static final Version ONE = new Version(1, 0, 0, null);
    private final int major;
    private final int minor;
    private final int service;
    private final String qualifier;

    public Version(int major) {
        this(major, 0, 0, null);
    }

    public Version(int major, int minor) {
        this(major, minor, 0, null);
    }

    public Version(int major, int minor, int service) {
        this(major, minor, service, null);
    }

    public Version(int major, int minor, int service, String qualifier) {
        if (minor < 0) {
            throw new IllegalArgumentException("Negative minor segment");
        }
        if (service < 0) {
            throw new IllegalArgumentException("Negative service segment");
        }
        if ("".equals(qualifier)) {
            throw new IllegalArgumentException("Empty qualifier; should be null");
        }
        this.major = major;
        this.minor = minor;
        this.service = service;
        this.qualifier = qualifier;
    }

    public Version(String versionSpec) {
        Matcher m = this.VERSION_PATTERN.matcher(versionSpec);
        if (!m.matches()) {
            throw new IllegalArgumentException("Invalid version specification: " + versionSpec);
        }
        this.major = Integer.parseInt(m.group(1));
        this.minor = m.group(2) == null ? 0 : Integer.parseInt(m.group(2).substring(1));
        this.service = m.group(3) == null ? 0 : Integer.parseInt(m.group(3).substring(1));
        this.qualifier = m.group(3) == null ? null : m.group(3).substring(1);
    }

    public int major() {
        return this.major;
    }

    public int minor() {
        return this.minor;
    }

    public int service() {
        return this.service;
    }

    public String qualifier() {
        return this.qualifier;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.major;
        result = 31 * result + this.minor;
        result = 31 * result + (this.qualifier == null ? 0 : this.qualifier.hashCode());
        result = 31 * result + this.service;
        return result;
    }

    public String toString() {
        return this.qualifier == null ? String.format("%s.%s.%s", this.major, this.minor, this.service) : String.format("%s.%s.%s.%s", this.major, this.minor, this.service, this.qualifier);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Version)) {
            return false;
        }
        Version other = (Version)obj;
        if (this.major != other.major) {
            return false;
        }
        if (this.minor != other.minor) {
            return false;
        }
        if (this.qualifier == null ? other.qualifier != null : !this.qualifier.equals(other.qualifier)) {
            return false;
        }
        return this.service == other.service;
    }

    @Override
    public int compareTo(Version o) {
        int result = o.major - this.major;
        if (result == 0 && (result = o.minor - this.minor) == 0 && (result = o.service - this.service) == 0) {
            result = Strings.nullToEmpty((String)o.qualifier).compareTo(Strings.nullToEmpty((String)this.qualifier));
        }
        return result;
    }

    public static org.osgi.framework.Version toOSGI(Version version) {
        return new org.osgi.framework.Version(version.major, version.minor, version.service, version.qualifier);
    }

    public static Version fromOSGI(org.osgi.framework.Version version) {
        return new Version(version.getMajor(), version.getMinor(), version.getMicro(), Strings.emptyToNull((String)version.getQualifier()));
    }
}

