/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.nattable.provider;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.infra.nattable.utils.AxisUtils;
import org.eclipse.papyrus.infra.widgets.providers.IRestrictedContentProvider;
import org.eclipse.papyrus.uml.nattable.manager.axis.UMLStereotypePropertyAxisManager;
import org.eclipse.papyrus.uml.tools.providers.UMLStereotypePropertyContentProvider;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ElementImport;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageImport;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.ProfileApplication;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;

public class UMLStereotypeRestrictedPropertyContentProvider
extends UMLStereotypePropertyContentProvider
implements IRestrictedContentProvider {
    private boolean isRestricted;
    private UMLStereotypePropertyAxisManager umlStereotypePropertyManager;
    private Collection<Element> restrictedElements;

    public UMLStereotypeRestrictedPropertyContentProvider(UMLStereotypePropertyAxisManager umlStereotypePropertyManager, boolean isRestricted) {
        this.setIgnoreBaseProperty(true);
        this.isRestricted = isRestricted;
        this.umlStereotypePropertyManager = umlStereotypePropertyManager;
        this.init();
    }

    protected void init() {
        this.setProfiles(new ArrayList<Profile>(this.getAllAvailableProfiles()));
        this.restrictedElements = this.calculusOfAllowedElements();
    }

    public Object[] getElements() {
        if (this.isRestricted) {
            boolean isColumnManager = this.umlStereotypePropertyManager.isUsedAsColumnManager();
            List elements = isColumnManager ? this.umlStereotypePropertyManager.getTableManager().getRowElementsList() : this.umlStereotypePropertyManager.getTableManager().getColumnElementsList();
            if (elements.isEmpty()) {
                return new Object[0];
            }
            List<Object> values = Arrays.asList(super.getElements());
            values = new ArrayList<Object>(values);
            values.retainAll(this.restrictedElements);
            return values.toArray();
        }
        return super.getElements();
    }

    protected Collection<Element> calculusOfAllowedElements() {
        HashSet<Element> restrictedElements = new HashSet<Element>();
        HashSet restrictedStereotypes = new HashSet();
        boolean isColumnManager = this.umlStereotypePropertyManager.isUsedAsColumnManager();
        List elementsList = isColumnManager ? this.umlStereotypePropertyManager.getTableManager().getRowElementsList() : this.umlStereotypePropertyManager.getTableManager().getColumnElementsList();
        for (Object object : elementsList) {
            Object representedElement = AxisUtils.getRepresentedElement(object);
            if (!(representedElement instanceof Element)) continue;
            restrictedStereotypes.addAll(((Element)representedElement).getAppliedStereotypes());
        }
        HashSet stereotypesNamespace = new HashSet();
        stereotypesNamespace.addAll(restrictedStereotypes);
        for (Stereotype stereotype : restrictedStereotypes) {
            stereotypesNamespace.addAll(stereotype.allNamespaces());
        }
        restrictedElements.addAll(restrictedStereotypes);
        restrictedElements.addAll(stereotypesNamespace);
        return restrictedElements;
    }

    protected Profile getTopRootProfile(Profile profile, Collection<Profile> availableProfiles) {
        EObject container = profile.eContainer();
        Profile topProfile = profile;
        while (container != null) {
            if (container instanceof Profile && availableProfiles.contains(container)) {
                topProfile = (Profile)container;
            }
            container = container.eContainer();
        }
        return topProfile;
    }

    protected Set<Profile> getAllAvailableProfiles() {
        EObject container;
        HashSet<Profile> coll = new HashSet<Profile>();
        EObject context = this.umlStereotypePropertyManager.getTableManager().getTableContext();
        if (context instanceof Element && (container = EcoreUtil.getRootContainer((EObject)context)) instanceof Package) {
            Collection<Profile> allAppliedProfiles = UMLStereotypeRestrictedPropertyContentProvider.getAppliedProfilesInWholePackage((Package)container);
            for (Profile profile : allAppliedProfiles) {
                coll.add(this.getTopRootProfile(profile, allAppliedProfiles));
            }
        }
        return coll;
    }

    private static final Collection<Profile> getAppliedProfilesInWholePackage(Package pack) {
        HashSet<Profile> appliedProfiles = new HashSet<Profile>();
        List<ProfileApplication> result = UMLStereotypeRestrictedPropertyContentProvider.getInstancesFilteredByType(pack, ProfileApplication.class, null);
        for (ProfileApplication profileApplication : result) {
            if (EcoreUtil.getRootContainer((EObject)profileApplication.getApplyingPackage()) != pack) continue;
            appliedProfiles.add(profileApplication.getAppliedProfile());
        }
        return appliedProfiles;
    }

    private static final <T extends EObject> List<T> getInstancesFilteredByType(Package topPackage, Class<T> metaType, Stereotype appliedStereotype) {
        TreeIterator iter = topPackage.eAllContents();
        ArrayList<EObject> filteredElements = new ArrayList<EObject>();
        while (iter.hasNext()) {
            PackageableElement importedElement;
            Package imported;
            EObject currentElt = (EObject)iter.next();
            if (currentElt instanceof ElementImport) {
                ElementImport elementImport = (ElementImport)currentElt;
                currentElt = elementImport.getImportedElement();
            } else if (currentElt instanceof PackageImport && (imported = ((PackageImport)currentElt).getImportedPackage()) != null) {
                TreeIterator piIter = imported.eAllContents();
                while (piIter.hasNext()) {
                    PackageableElement importedElement2;
                    EObject piCurrentElt = (EObject)piIter.next();
                    if (!(piCurrentElt instanceof Element)) continue;
                    if (appliedStereotype != null) {
                        for (Stereotype currentSt : ((Element)piCurrentElt).getAppliedStereotypes()) {
                            if (!currentSt.conformsTo((Type)appliedStereotype)) continue;
                            filteredElements.add(piCurrentElt);
                        }
                        continue;
                    }
                    if (metaType.isInstance(piCurrentElt)) {
                        filteredElements.add(piCurrentElt);
                        continue;
                    }
                    if (!(piCurrentElt instanceof ElementImport) || (importedElement2 = ((ElementImport)piCurrentElt).getImportedElement()) == null) continue;
                    TreeIterator eIter = importedElement2.eAllContents();
                    while (eIter.hasNext()) {
                        EObject currentEIelt = (EObject)eIter.next();
                        if (!metaType.isInstance(currentEIelt)) continue;
                        filteredElements.add(currentEIelt);
                    }
                }
            }
            if (!(currentElt instanceof Element)) continue;
            if (appliedStereotype != null) {
                for (Stereotype currentSt : ((Element)currentElt).getAppliedStereotypes()) {
                    if (!currentSt.conformsTo((Type)appliedStereotype)) continue;
                    filteredElements.add(currentElt);
                }
                continue;
            }
            if (metaType.isInstance(currentElt)) {
                filteredElements.add(currentElt);
                continue;
            }
            if (!(currentElt instanceof ElementImport) || (importedElement = ((ElementImport)currentElt).getImportedElement()) == null) continue;
            TreeIterator eIter = importedElement.eAllContents();
            while (eIter.hasNext()) {
                EObject currentEIelt = (EObject)eIter.next();
                if (!metaType.isInstance(currentEIelt)) continue;
                filteredElements.add(currentEIelt);
            }
        }
        return filteredElements;
    }

    public void setRestriction(boolean isRestricted) {
        this.isRestricted = isRestricted;
    }

    public Object[] getChildren(Object parentElement) {
        if (!(parentElement instanceof Package) && !(parentElement instanceof Stereotype)) {
            return new Object[0];
        }
        Object[] children = super.getChildren(parentElement);
        if (!this.isRestricted || !(parentElement instanceof Package)) {
            return children;
        }
        ArrayList<Object> returnedValues = new ArrayList<Object>();
        returnedValues.addAll(Arrays.asList(children));
        returnedValues.retainAll(this.restrictedElements);
        return returnedValues.toArray();
    }

    public void dispose() {
        super.dispose();
        this.umlStereotypePropertyManager = null;
        this.restrictedElements.clear();
    }

    public boolean isRestricted() {
        return this.isRestricted;
    }
}

