/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.refactoring2.rename;

import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.ui.IEditorPart;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.ide.refactoring.IRenameStrategy2;
import org.eclipse.xtext.ide.refactoring.RefactoringIssueAcceptor;
import org.eclipse.xtext.ide.refactoring.RenameChange;
import org.eclipse.xtext.ide.refactoring.RenameContext;
import org.eclipse.xtext.ide.serializer.IChangeSerializer;
import org.eclipse.xtext.ide.serializer.ITextDocumentChange;
import org.eclipse.xtext.resource.IGlobalServiceProvider;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.refactoring.ILinkedPositionGroupCalculator;
import org.eclipse.xtext.ui.refactoring.impl.CachingResourceSetProvider;
import org.eclipse.xtext.ui.refactoring.impl.ProjectUtil;
import org.eclipse.xtext.ui.refactoring.impl.RefactoringResourceSetProvider;
import org.eclipse.xtext.ui.refactoring.ui.IRenameElementContext;
import org.eclipse.xtext.ui.refactoring2.LtkIssueAcceptor;
import org.eclipse.xtext.ui.refactoring2.rename.ISimpleNameProvider;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class DefaultLinkedPositionGroupCalculator2
implements ILinkedPositionGroupCalculator {
    private static final Logger LOG = Logger.getLogger(DefaultLinkedPositionGroupCalculator2.class);
    @Inject
    private ProjectUtil projectUtil;
    @Inject
    private RefactoringResourceSetProvider resourceSetProvider;
    @Inject
    private ISimpleNameProvider simpleNameProvider;
    @Inject
    private IGlobalServiceProvider globalServiceProvider;
    @Inject
    private IResourceServiceProvider.Registry resourceServiceProviderRegistry;

    @Override
    public Provider<LinkedPositionGroup> getLinkedPositionGroup(IRenameElementContext renameElementContext, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IEditorPart _triggeringEditor = renameElementContext.getTriggeringEditor();
        XtextEditor editor = (XtextEditor)_triggeringEditor;
        IProject project = this.projectUtil.getProject(renameElementContext.getContextResourceURI());
        if (project == null) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Could not determine project for context resource ");
            URI _contextResourceURI = renameElementContext.getContextResourceURI();
            _builder.append((Object)_contextResourceURI);
            String _string = _builder.toString();
            throw new IllegalStateException(_string);
        }
        CachingResourceSetProvider resourceSetProvider = new CachingResourceSetProvider(this.resourceSetProvider);
        ResourceSet resourceSet = resourceSetProvider.get(project);
        EObject targetElement = resourceSet.getEObject(renameElementContext.getTargetElementURI(), true);
        if (targetElement == null) {
            throw new IllegalStateException("Target element could not be loaded");
        }
        boolean _isCanceled = monitor.isCanceled();
        if (_isCanceled) {
            throw new OperationCanceledException();
        }
        IRenameStrategy2 renameStrategy = (IRenameStrategy2)this.globalServiceProvider.findService(targetElement, IRenameStrategy2.class);
        if (renameStrategy == null) {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("Cannot find a rename strategy for ");
            URI _targetElementURI = renameElementContext.getTargetElementURI();
            _builder_1.append((Object)_targetElementURI);
            throw new IllegalArgumentException(_builder_1.toString());
        }
        String oldName = this.simpleNameProvider.getSimpleName(targetElement);
        String newName = this.getNewDummyName(oldName);
        IResourceServiceProvider resourceServiceProvider = this.resourceServiceProviderRegistry.getResourceServiceProvider(renameElementContext.getTargetElementURI());
        LtkIssueAcceptor issues = (LtkIssueAcceptor)resourceServiceProvider.get(LtkIssueAcceptor.class);
        IChangeSerializer changeSerializer = (IChangeSerializer)resourceServiceProvider.get(IChangeSerializer.class);
        changeSerializer.setUpdateRelatedFiles(false);
        URI _targetElementURI_1 = renameElementContext.getTargetElementURI();
        RenameChange change = new RenameChange(newName, _targetElementURI_1);
        RenameContext renameContext = new RenameContext(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new RenameChange[]{change})), resourceSet, changeSerializer, (RefactoringIssueAcceptor)issues);
        renameStrategy.applyRename(renameContext);
        ArrayList replaceEdits = CollectionLiterals.newArrayList();
        IAcceptor _function = c -> {
            if (c instanceof ITextDocumentChange) {
                Functions.Function1 _function_1 = replacement -> {
                    int _offset = replacement.getOffset();
                    int _length = replacement.getLength();
                    String _replacementText = replacement.getReplacementText();
                    return new ReplaceEdit(_offset, _length, _replacementText);
                };
                List _map = ListExtensions.map((List)((ITextDocumentChange)c).getReplacements(), (Functions.Function1)_function_1);
                Iterables.addAll((Collection)replaceEdits, (Iterable)_map);
            }
        };
        changeSerializer.applyModifications(_function);
        boolean _isCanceled_1 = monitor.isCanceled();
        if (_isCanceled_1) {
            throw new OperationCanceledException();
        }
        Provider _function_1 = () -> this.createLinkedGroupFromReplaceEdits(replaceEdits, editor, oldName, progress.newChild(10));
        return _function_1;
    }

    protected String getNewDummyName(String oldName) {
        return String.valueOf(oldName) + oldName;
    }

    protected LinkedPositionGroup createLinkedGroupFromReplaceEdits(List<ReplaceEdit> edits, XtextEditor xtextEditor, String originalName, SubMonitor progress) {
        if (edits == null) {
            return null;
        }
        IXtextDocument document = xtextEditor.getDocument();
        LinkedPositionGroup group = new LinkedPositionGroup();
        Functions.Function1 _function = it -> {
            try {
                String textToReplace = document.get(it.getOffset(), it.getLength());
                int indexOf = textToReplace.indexOf(originalName);
                if (indexOf != -1) {
                    int _offset = it.getOffset();
                    int calculatedOffset = _offset + indexOf;
                    int _length = originalName.length();
                    return new LinkedPosition((IDocument)document, calculatedOffset, _length);
                }
            }
            catch (Throwable _t) {
                if (_t instanceof BadLocationException) {
                    BadLocationException exc = (BadLocationException)_t;
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("Skipping invalid text edit ");
                    _builder.append(it);
                    LOG.error((Object)_builder, (Throwable)exc);
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            return null;
        };
        Iterable linkedPositions = IterableExtensions.filterNull((Iterable)ListExtensions.map(edits, (Functions.Function1)_function));
        progress.worked(10);
        int invocationOffset = xtextEditor.getInternalSourceViewer().getSelectedRange().x;
        int i = 0;
        Iterable<LinkedPosition> _sortPositions = this.sortPositions(linkedPositions, invocationOffset);
        for (LinkedPosition position : _sortPositions) {
            try {
                position.setSequenceNumber(i);
                ++i;
                group.addPosition(position);
            }
            catch (Throwable _t) {
                if (_t instanceof BadLocationException) {
                    BadLocationException e = (BadLocationException)_t;
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                    return null;
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        return group;
    }

    protected Iterable<LinkedPosition> sortPositions(Iterable<LinkedPosition> linkedPositions, final int invocationOffset) {
        abstract class __DefaultLinkedPositionGroupCalculator2_1
        implements Comparator<LinkedPosition> {
            __DefaultLinkedPositionGroupCalculator2_1() {
            }

            abstract int rank(LinkedPosition var1);
        }
        __DefaultLinkedPositionGroupCalculator2_1 comparator = new __DefaultLinkedPositionGroupCalculator2_1(this){
            {
            }

            @Override
            public int compare(LinkedPosition left, LinkedPosition right) {
                int _rank = this.rank(left);
                int _rank_1 = this.rank(right);
                return _rank - _rank_1;
            }

            @Override
            int rank(LinkedPosition o1) {
                int relativeRank = o1.offset + o1.length - invocationOffset;
                if (relativeRank < 0) {
                    return Integer.MAX_VALUE + relativeRank;
                }
                return relativeRank;
            }
        };
        return ImmutableSortedSet.copyOf((Comparator)comparator, linkedPositions);
    }
}

