/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.search;

import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.internal.core.ifeature.IFeaturePlugin;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.feature.FeatureEditor;
import org.eclipse.pde.internal.ui.search.AbstractSearchResultPage;
import org.eclipse.pde.internal.ui.search.ManifestEditorOpener;
import org.eclipse.pde.internal.ui.search.PluginSearchActionGroup;
import org.eclipse.pde.internal.ui.views.plugins.ImportActionGroup;
import org.eclipse.pde.internal.ui.views.plugins.JavaSearchActionGroup;
import org.eclipse.search.ui.text.Match;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionContext;

public class PluginSearchResultPage
extends AbstractSearchResultPage {
    public PluginSearchResultPage() {
        PDEPlugin.getDefault().getLabelProvider().connect((Object)this);
    }

    protected void fillContextMenu(IMenuManager mgr) {
        super.fillContextMenu(mgr);
        mgr.add((IContributionItem)new Separator());
        IStructuredSelection selection = this.getViewer().getStructuredSelection();
        ActionContext context = new ActionContext((ISelection)selection);
        PluginSearchActionGroup actionGroup = new PluginSearchActionGroup();
        actionGroup.setContext(context);
        actionGroup.fillContextMenu(mgr);
        if (ImportActionGroup.canImport(selection)) {
            mgr.add((IContributionItem)new Separator());
            ImportActionGroup importActionGroup = new ImportActionGroup();
            importActionGroup.setContext(context);
            importActionGroup.fillContextMenu(mgr);
        }
        mgr.add((IContributionItem)new Separator());
        JavaSearchActionGroup jsActionGroup = new JavaSearchActionGroup();
        jsActionGroup.setContext(new ActionContext((ISelection)selection));
        jsActionGroup.fillContextMenu(mgr);
    }

    @Override
    protected ILabelProvider createLabelProvider() {
        return new SearchLabelProvider();
    }

    @Override
    protected ViewerComparator createViewerComparator() {
        return new ViewerComparator();
    }

    protected void showMatch(Match match, int currentOffset, int currentLength, boolean activate) throws PartInitException {
        if (match.getElement() instanceof IFeaturePlugin) {
            IFeaturePlugin featurePlugin = (IFeaturePlugin)match.getElement();
            FeatureEditor.openFeatureEditor(featurePlugin);
            return;
        }
        ManifestEditorOpener.open(match, activate);
    }

    public void dispose() {
        PDEPlugin.getDefault().getLabelProvider().disconnect((Object)this);
        super.dispose();
    }

    class SearchLabelProvider
    extends LabelProvider {
        SearchLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof IFeaturePlugin) {
                return this.getImage(((IFeaturePlugin)element).getFeature().getModel());
            }
            return PDEPlugin.getDefault().getLabelProvider().getImage(element);
        }

        public String getText(Object object) {
            if (object instanceof IPluginBase) {
                return ((IPluginBase)object).getId();
            }
            if (object instanceof IPluginImport) {
                IPluginImport dep = (IPluginImport)object;
                return String.valueOf(dep.getId()) + " - " + dep.getPluginBase().getId();
            }
            if (object instanceof IPluginExtension) {
                IPluginExtension extension = (IPluginExtension)object;
                return String.valueOf(extension.getPoint()) + " - " + extension.getPluginBase().getId();
            }
            if (object instanceof IPluginExtensionPoint) {
                return ((IPluginExtensionPoint)object).getFullId();
            }
            if (object instanceof IFeaturePlugin) {
                IFeaturePlugin featurePlugin = (IFeaturePlugin)object;
                String pluginId = featurePlugin.getId();
                String featureId = featurePlugin.getFeature().getId();
                return String.valueOf(pluginId) + " - " + featureId;
            }
            return PDEPlugin.getDefault().getLabelProvider().getText(object);
        }
    }
}

