/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.branch;

import java.text.MessageFormat;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchManager;
import org.eclipse.emf.cdo.common.branch.CDOBranchVersion;
import org.eclipse.emf.cdo.spi.common.branch.CDOBranchAdjustable;

public class CDOBranchVersionImpl
implements CDOBranchVersion,
CDOBranchAdjustable {
    private CDOBranch branch;
    private int version;

    public CDOBranchVersionImpl(CDOBranch branch, int version) {
        this.branch = branch;
        this.version = version;
    }

    @Override
    public void adjustBranches(CDOBranchManager newBranchManager) {
        if (this.branch != null) {
            this.branch = newBranchManager.getBranch(this.branch.getID());
        }
    }

    @Override
    public CDOBranch getBranch() {
        return this.branch;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    public int hashCode() {
        return this.branch.hashCode() ^ this.version;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CDOBranchVersion) {
            CDOBranchVersion that = (CDOBranchVersion)obj;
            return this.branch == that.getBranch() && this.version == that.getVersion();
        }
        return false;
    }

    public String toString() {
        return MessageFormat.format("BranchVersion[{0}, v{1}]", this.branch, this.version);
    }
}

