/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.core.data;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.mylyn.tasks.core.IRepositoryPerson;

public class TaskRevision {
    private final IRepositoryPerson author;
    private final List<Change> changes;
    private final Date date;
    private final String id;

    public TaskRevision(String id, Date date, IRepositoryPerson author) {
        Assert.isNotNull((Object)id);
        this.id = id;
        this.date = date;
        this.author = author;
        this.changes = new ArrayList<Change>();
    }

    public void add(Change change) {
        this.changes.add(change);
    }

    public IRepositoryPerson getAuthor() {
        return this.author;
    }

    public List<Change> getChanges() {
        return new ArrayList<Change>(this.changes);
    }

    public Date getDate() {
        return this.date;
    }

    public String getId() {
        return this.id;
    }

    public void remove(Change change) {
        this.changes.remove(change);
    }

    public static class Change {
        private final String added;
        private final String attributeId;
        private final String field;
        private final String removed;

        public Change(String attributeId, String field, String removed, String added) {
            Assert.isNotNull((Object)attributeId);
            Assert.isNotNull((Object)field);
            this.attributeId = attributeId;
            this.field = field;
            this.removed = removed;
            this.added = added;
        }

        public String getAdded() {
            return this.added;
        }

        public String getAttributeId() {
            return this.attributeId;
        }

        public String getField() {
            return this.field;
        }

        public String getRemoved() {
            return this.removed;
        }
    }
}

