/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.core.data;

import java.io.InputStream;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskAttachmentSource;
import org.eclipse.mylyn.tasks.core.data.TaskAttachmentMapper;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;

public class UnsubmittedTaskAttachment {
    private final TaskAttribute attribute;
    private String contentType;
    private String description;
    private String fileName;
    private boolean replaceExisting;
    private final AbstractTaskAttachmentSource source;

    public UnsubmittedTaskAttachment(AbstractTaskAttachmentSource source, TaskAttribute attribute) {
        Assert.isNotNull((Object)source);
        this.source = source;
        this.attribute = attribute;
        this.contentType = source.getContentType();
        this.fileName = source.getName();
        this.description = source.getDescription();
        if (attribute != null) {
            TaskAttachmentMapper mapper = TaskAttachmentMapper.createFrom(attribute);
            if (mapper.getContentType() != null) {
                this.contentType = mapper.getContentType();
            }
            if (mapper.getFileName() != null) {
                this.fileName = mapper.getFileName();
            }
            if (mapper.getDescription() != null) {
                this.description = mapper.getDescription();
            }
            if (mapper.getReplaceExisting() != null) {
                this.replaceExisting = mapper.getReplaceExisting();
            }
        }
        if (this.description == null) {
            this.description = "";
        }
    }

    public InputStream createInputStream(IProgressMonitor monitor) throws CoreException {
        return this.source.createInputStream(monitor);
    }

    public TaskAttribute getAttribute() {
        return this.attribute;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getDescription() {
        return this.description;
    }

    public String getFileName() {
        return this.fileName;
    }

    public boolean getReplaceExisting() {
        return this.replaceExisting;
    }

    public AbstractTaskAttachmentSource getSource() {
        return this.source;
    }
}

