/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.xtext.base.serializer;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.Import;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.utilities.Nameable;
import org.eclipse.ocl.pivot.utilities.URIUtil;
import org.eclipse.ocl.xtext.base.as2cs.AliasAnalysis;
import org.eclipse.ocl.xtext.base.utilities.BaseCSResource;
import org.eclipse.ocl.xtext.basecs.ImportCS;
import org.eclipse.ocl.xtext.basecs.PathElementCS;
import org.eclipse.ocl.xtext.basecs.PathElementWithURICS;
import org.eclipse.ocl.xtext.basecs.PathNameCS;
import org.eclipse.ocl.xtext.basecs.RootPackageCS;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.conversion.IValueConverterService;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.linking.impl.LinkingHelper;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.serializer.diagnostic.ISerializationDiagnostic;
import org.eclipse.xtext.serializer.tokens.CrossReferenceSerializer;

public class BaseCrossReferenceSerializer
extends CrossReferenceSerializer {
    @Inject
    private LinkingHelper linkingHelper;
    @Inject
    private IQualifiedNameConverter qualifiedNameConverter;
    @Inject
    private IValueConverterService valueConverter;

    protected String getCrossReferenceNameFromScope(EObject semanticObject, CrossReference crossref, EObject target, IScope scope, ISerializationDiagnostic.Acceptor errors) {
        AcceptorHelper helper = new AcceptorHelper(semanticObject, crossref, target, scope, errors);
        boolean foundOne = false;
        String ruleName = this.linkingHelper.getRuleNameFrom((EObject)crossref);
        if ("URI".equals(ruleName)) {
            Object converted;
            PathElementWithURICS pathElementWithURICS;
            String uri;
            if (semanticObject instanceof PathElementWithURICS && (uri = (pathElementWithURICS = (PathElementWithURICS)semanticObject).getUri()) != null && (converted = helper.convert(uri, ruleName)) != null) {
                return converted;
            }
            Iterable elements = scope.getElements(target);
            for (IEObjectDescription desc : elements) {
                URI baseURI;
                URI uri2 = URI.createURI((String)desc.getName().toString());
                URI deresolvedURI = URIUtil.deresolve((URI)uri2, (URI)(baseURI = semanticObject.eResource().getURI()));
                String unconverted = deresolvedURI.toString();
                String converted2 = helper.convert(unconverted, ruleName);
                if (converted2 == null) continue;
                return converted2;
            }
        } else if (semanticObject instanceof PathElementCS) {
            PathElementCS pathElement = (PathElementCS)semanticObject;
            PathNameCS pathName = pathElement.getOwningPathName();
            int index = pathName.getOwnedPathElements().indexOf((Object)pathElement);
            Element element = pathElement.getReferredElement();
            if (element != null && !element.eIsProxy()) {
                NamedElement namedElement;
                Resource csResource = pathElement.eResource();
                assert (csResource != null);
                NamedElement namedElement2 = namedElement = csResource instanceof BaseCSResource ? ((BaseCSResource)csResource).isPathable((EObject)element) : null;
                if (namedElement != null) {
                    String converted;
                    String name = namedElement.getName();
                    if (index == 0 && namedElement instanceof Package) {
                        AliasAnalysis adapter;
                        String alias;
                        Resource elementResource;
                        EObject root = EcoreUtil.getRootContainer((EObject)semanticObject);
                        Resource asResource = null;
                        if (root instanceof RootPackageCS) {
                            Element root2 = ((RootPackageCS)root).getPivot();
                            asResource = EcoreUtil.getRootContainer((EObject)root2).eResource();
                        }
                        if ((elementResource = namedElement.eResource()) != csResource && elementResource != asResource && (alias = (adapter = AliasAnalysis.getAdapter(csResource)).getAlias((EObject)namedElement, null)) != null) {
                            name = alias;
                        }
                    }
                    if ((converted = helper.convert(name, ruleName)) != null) {
                        return converted;
                    }
                } else {
                    URI baseURI;
                    EObject eTarget = element.getESObject();
                    URI uri = eTarget != null ? EcoreUtil.getURI((EObject)eTarget) : EcoreUtil.getURI((EObject)element);
                    URI deresolvedURI = URIUtil.deresolve((URI)uri, (URI)(baseURI = semanticObject.eResource().getURI()));
                    String unconverted = deresolvedURI.toString();
                    String converted = helper.convert(unconverted, ruleName);
                    if (converted != null) {
                        return converted;
                    }
                }
            }
        } else {
            EObject semanticRoot;
            if (target instanceof Package && (semanticRoot = EcoreUtil.getRootContainer((EObject)semanticObject)) instanceof RootPackageCS) {
                for (ImportCS csImport : ((RootPackageCS)semanticRoot).getOwnedImports()) {
                    Import asImport;
                    String aliasName;
                    Element asElement = csImport.getPivot();
                    if (!(asElement instanceof Import) || (aliasName = (asImport = (Import)asElement).getName()) == null || asImport.getImportedNamespace() != target) continue;
                    return aliasName;
                }
            }
            Iterable elements = scope.getElements(target);
            for (IEObjectDescription desc : elements) {
                String unconverted;
                String converted;
                foundOne = true;
                QualifiedName name = desc.getName();
                if (name.getSegmentCount() <= 0 || (converted = helper.convert(unconverted = name.getLastSegment(), ruleName)) == null) continue;
                return converted;
            }
            if (target instanceof Nameable) {
                return ((Nameable)target).getName();
            }
        }
        helper.report(foundOne);
        return null;
    }

    protected class AcceptorHelper {
        protected final EObject semanticObject;
        protected final CrossReference crossref;
        protected final EObject target;
        protected final IScope scope;
        protected final // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable ISerializationDiagnostic.Acceptor errors;
        private @Nullable List<ISerializationDiagnostic> recordedErrors = null;

        public AcceptorHelper(EObject semanticObject, CrossReference crossref, EObject target, @Nullable IScope scope, ISerializationDiagnostic.Acceptor errors) {
            this.semanticObject = semanticObject;
            this.crossref = crossref;
            this.target = target;
            this.scope = scope;
            this.errors = errors;
        }

        public @Nullable String convert(String unconverted, String ruleName) {
            try {
                return BaseCrossReferenceSerializer.this.valueConverter.toString((Object)unconverted, ruleName);
            }
            catch (ValueConverterException e) {
                this.record(unconverted, e);
                return null;
            }
        }

        protected @Nullable String convert(List<String> segments, String ruleName) {
            int iMax = segments.size();
            String[] converted = new String[iMax];
            String unconverted = null;
            try {
                int i = 0;
                while (i < iMax) {
                    unconverted = segments.get(i);
                    converted[i] = i > 0 && "UnrestrictedName".equals(ruleName) ? BaseCrossReferenceSerializer.this.valueConverter.toString((Object)unconverted, "UnreservedName") : BaseCrossReferenceSerializer.this.valueConverter.toString((Object)unconverted, ruleName);
                    ++i;
                }
                return BaseCrossReferenceSerializer.this.qualifiedNameConverter.toString(new QualifiedName(converted){});
            }
            catch (ValueConverterException e) {
                this.record(unconverted, e);
                return null;
            }
        }

        protected void record(String unconverted, @NonNull ValueConverterException e) {
            if (this.errors != null) {
                ArrayList recordedErrors2 = this.recordedErrors;
                if (recordedErrors2 == null) {
                    this.recordedErrors = recordedErrors2 = Lists.newArrayList();
                }
                recordedErrors2.add(BaseCrossReferenceSerializer.this.diagnostics.getValueConversionExceptionDiagnostic(this.semanticObject, (AbstractElement)this.crossref, (Object)unconverted, (Throwable)e));
            }
        }

        protected void report(boolean foundOne) {
            ISerializationDiagnostic.Acceptor errors2 = this.errors;
            if (errors2 != null) {
                if (this.recordedErrors != null) {
                    for (ISerializationDiagnostic diag : this.recordedErrors) {
                        errors2.accept(diag);
                    }
                }
                if (!foundOne) {
                    errors2.accept(BaseCrossReferenceSerializer.this.diagnostics.getNoEObjectDescriptionFoundDiagnostic(this.semanticObject, this.crossref, this.target, this.scope));
                }
            }
        }
    }
}

