/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.core.refactoring.resource;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.ParticipantManager;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.ltk.core.refactoring.participants.RenameProcessor;
import org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.ltk.core.refactoring.resource.RenameResourceChange;
import org.eclipse.ltk.core.refactoring.resource.RenameResourceDescriptor;
import org.eclipse.ltk.core.refactoring.resource.Resources;
import org.eclipse.ltk.internal.core.refactoring.BasicElementLabels;
import org.eclipse.ltk.internal.core.refactoring.Messages;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCoreMessages;
import org.eclipse.ltk.internal.core.refactoring.resource.ResourceModifications;
import org.eclipse.ltk.internal.core.refactoring.resource.ResourceProcessors;

public class RenameResourceProcessor
extends RenameProcessor {
    private IResource fResource;
    private String fNewResourceName;
    private boolean fUpdateReferences;
    private RenameArguments fRenameArguments;

    public RenameResourceProcessor(IResource resource) {
        if (resource == null || !resource.exists()) {
            throw new IllegalArgumentException("resource must not be null and must exist");
        }
        this.fResource = resource;
        this.fRenameArguments = null;
        this.fUpdateReferences = true;
        this.setNewResourceName(resource.getName());
    }

    public IResource getResource() {
        return this.fResource;
    }

    public String getNewResourceName() {
        return this.fNewResourceName;
    }

    public void setNewResourceName(String newName) {
        Assert.isNotNull((Object)newName);
        this.fNewResourceName = newName;
    }

    public boolean isUpdateReferences() {
        return this.fUpdateReferences;
    }

    public void setUpdateReferences(boolean updateReferences) {
        this.fUpdateReferences = updateReferences;
    }

    @Override
    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        boolean autoRefresh;
        IStatus status = Resources.checkInSync(this.fResource);
        if (!status.isOK() && (autoRefresh = Platform.getPreferencesService().getBoolean("org.eclipse.core.resources", "refresh.lightweight.enabled", false, null))) {
            this.fResource.refreshLocal(2, pm);
            status = Resources.checkInSync(this.fResource);
        }
        return RefactoringStatus.create(status);
    }

    @Override
    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException {
        pm.beginTask("", 1);
        try {
            this.fRenameArguments = new RenameArguments(this.getNewResourceName(), this.isUpdateReferences());
            ResourceChangeChecker checker = context.getChecker(ResourceChangeChecker.class);
            IResourceChangeDescriptionFactory deltaFactory = checker.getDeltaFactory();
            ResourceModifications.buildMoveDelta(deltaFactory, this.fResource, this.fRenameArguments);
            RefactoringStatus refactoringStatus = new RefactoringStatus();
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    public RefactoringStatus validateNewElementName(String newName) {
        Assert.isNotNull((Object)newName, (String)"new name");
        IContainer c = this.fResource.getParent();
        if (c == null) {
            return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.RenameResourceProcessor_error_no_parent);
        }
        if (!c.getFullPath().isValidSegment(newName)) {
            return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.RenameResourceProcessor_error_invalid_name);
        }
        if (c.findMember(newName) != null) {
            return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.RenameResourceProcessor_error_resource_already_exists);
        }
        RefactoringStatus result = RefactoringStatus.create(c.getWorkspace().validateName(newName, this.fResource.getType()));
        if (!result.hasFatalError()) {
            result.merge(RefactoringStatus.create(c.getWorkspace().validatePath(this.createNewPath(newName), this.fResource.getType())));
        }
        return result;
    }

    protected RenameResourceDescriptor createDescriptor() {
        IResource resource = this.getResource();
        RenameResourceDescriptor descriptor = new RenameResourceDescriptor();
        descriptor.setProject(resource instanceof IProject ? null : resource.getProject().getName());
        descriptor.setDescription(Messages.format(RefactoringCoreMessages.RenameResourceProcessor_description, BasicElementLabels.getResourceName(resource)));
        descriptor.setComment(Messages.format(RefactoringCoreMessages.RenameResourceProcessor_comment, new String[]{BasicElementLabels.getPathLabel(resource.getFullPath(), false), BasicElementLabels.getResourceName(this.getNewResourceName())}));
        descriptor.setFlags(7);
        descriptor.setResourcePath(resource.getFullPath());
        descriptor.setNewName(this.getNewResourceName());
        descriptor.setUpdateReferences(this.isUpdateReferences());
        return descriptor;
    }

    @Override
    public Change createChange(IProgressMonitor pm) throws CoreException {
        pm.beginTask("", 1);
        try {
            RenameResourceChange change = new RenameResourceChange(this.fResource.getFullPath(), this.getNewResourceName());
            change.setDescriptor(new RefactoringChangeDescriptor(this.createDescriptor()));
            RenameResourceChange renameResourceChange = change;
            return renameResourceChange;
        }
        finally {
            pm.done();
        }
    }

    private String createNewPath(String newName) {
        return this.fResource.getFullPath().removeLastSegments(1).append(newName).toString();
    }

    @Override
    public Object[] getElements() {
        return new Object[]{this.fResource};
    }

    @Override
    public String getIdentifier() {
        return "org.eclipse.ltk.core.refactoring.renameResourceProcessor";
    }

    @Override
    public String getProcessorName() {
        return RefactoringCoreMessages.RenameResourceProcessor_processor_name;
    }

    @Override
    public boolean isApplicable() {
        if (this.fResource == null) {
            return false;
        }
        if (!this.fResource.exists()) {
            return false;
        }
        return this.fResource.isAccessible();
    }

    @Override
    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants shared) throws CoreException {
        String[] affectedNatures = ResourceProcessors.computeAffectedNatures(this.fResource);
        return ParticipantManager.loadRenameParticipants(status, this, this.fResource, this.fRenameArguments, null, affectedNatures, shared);
    }
}

