/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.command;

import java.util.ArrayList;
import java.util.Optional;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.BendpointRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.core.edithelpers.CreateElementRequestAdapter;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewAndElementRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.DestructionOccurrenceSpecificationEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.figures.DestructionEventFigure;
import org.eclipse.papyrus.uml.diagram.sequence.messages.Messages;
import org.eclipse.uml2.uml.DestructionOccurrenceSpecification;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageEnd;

public class DropDestructionOccurenceSpecification
extends AbstractTransactionalCommand {
    private Request request;
    private EditPart graphicalContainer;
    private Point absolutePosition;

    public DropDestructionOccurenceSpecification(TransactionalEditingDomain domain, Request request, EditPart graphicalContainer, Point absolutePosition) {
        super(domain, Messages.Commands_DropDestructionOccurenceSpecification_Label, null);
        this.request = request;
        this.graphicalContainer = graphicalContainer;
        this.absolutePosition = absolutePosition;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        CommandResult commandresult = null;
        Message deleteMessage = this.getDeleteMessage();
        if (deleteMessage == null) {
            return commandresult;
        }
        DestructionOccurrenceSpecification destructionOccurrenceSpecification = this.getDestructionOccurrence(deleteMessage);
        if (destructionOccurrenceSpecification == null) {
            return commandresult;
        }
        this.dropDestructionOccurrence(destructionOccurrenceSpecification);
        return CommandResult.newOKCommandResult();
    }

    private void dropDestructionOccurrence(DestructionOccurrenceSpecification destructionOccurrenceSpecification) {
        DropObjectsRequest dropDestructionOccurrenceRequest = new DropObjectsRequest();
        Point point = this.absolutePosition.getCopy();
        IFigure parentFigure = ((GraphicalEditPart)this.graphicalContainer).getFigure();
        parentFigure.translateToRelative((Translatable)point);
        DestructionEventFigure destructionEventFigure = null;
        Optional<Object> findFirst = this.graphicalContainer.getChildren().stream().filter(DestructionOccurrenceSpecificationEditPart.class::isInstance).map(DestructionOccurrenceSpecificationEditPart.class::cast).findFirst();
        if (!findFirst.isPresent()) {
            destructionEventFigure = new DestructionEventFigure();
            point.y -= destructionEventFigure.getDefaultSize().height / 2;
            dropDestructionOccurrenceRequest.setLocation(point);
            ArrayList<DestructionOccurrenceSpecification> destructionOccurrenceListToDrop = new ArrayList<DestructionOccurrenceSpecification>();
            destructionOccurrenceListToDrop.add(destructionOccurrenceSpecification);
            dropDestructionOccurrenceRequest.setObjects(destructionOccurrenceListToDrop);
            Command command = this.graphicalContainer.getCommand((Request)dropDestructionOccurrenceRequest);
            command.execute();
        }
    }

    private DestructionOccurrenceSpecification getDestructionOccurrence(Message deleteMessage) {
        DestructionOccurrenceSpecification destructionOccurrenceSpecification = null;
        MessageEnd messageEnd = deleteMessage.getReceiveEvent();
        if (messageEnd instanceof DestructionOccurrenceSpecification) {
            destructionOccurrenceSpecification = (DestructionOccurrenceSpecification)messageEnd;
        }
        return destructionOccurrenceSpecification;
    }

    private Message getDeleteMessage() {
        EObject element;
        Message deleteMessage = null;
        if (this.request instanceof CreateConnectionViewAndElementRequest) {
            CreateConnectionViewAndElementRequest.ConnectionViewAndElementDescriptor connectionViewAndElementDescriptor = ((CreateConnectionViewAndElementRequest)this.request).getConnectionViewAndElementDescriptor();
            if (connectionViewAndElementDescriptor != null) {
                CreateElementRequestAdapter createElementRequestAdapter = connectionViewAndElementDescriptor.getCreateElementRequestAdapter();
                deleteMessage = (Message)createElementRequestAdapter.getAdapter(Message.class);
            }
        } else if (this.request instanceof ReconnectRequest) {
            EObject element2 = ((View)((ReconnectRequest)this.request).getConnectionEditPart().getModel()).getElement();
            if (element2 instanceof Message) {
                deleteMessage = (Message)element2;
            }
        } else if (this.request instanceof BendpointRequest && (element = ((View)((BendpointRequest)this.request).getSource().getModel()).getElement()) instanceof Message) {
            deleteMessage = (Message)element;
        }
        return deleteMessage;
    }
}

