/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import java.net.URI;
import java.util.Set;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.ide.dialogs.PathVariableSelectionDialog;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.dialogs.IDEResourceInfoUtils;

public class PathVariableDialog
extends TitleAreaDialog {
    private Button okButton;
    private Label variableNameLabel;
    private Label variableValueLabel;
    private Label variableResolvedValueLabel;
    private Text variableNameField;
    private Text variableValueField;
    private Label variableResolvedValueField;
    private Button fileButton;
    private Button folderButton;
    private Button variableButton;
    private int type;
    private int variableType;
    private String variableName;
    private String variableValue;
    private String originalName;
    private int operationMode = 0;
    private IPathVariableManager pathVariableManager;
    private Set namesInUse;
    private int validationStatus;
    private String validationMessage;
    private boolean nameEntered = false;
    private boolean locationEntered = false;
    private final String standardMessage;
    public static final int NEW_VARIABLE = 1;
    public static final int EXISTING_VARIABLE = 2;
    public static final int EDIT_LINK_LOCATION = 3;
    private IResource currentResource = null;

    public PathVariableDialog(Shell parentShell, int type, int variableType, IPathVariableManager pathVariableManager, Set namesInUse) {
        super(parentShell);
        this.type = type;
        this.operationMode = type;
        this.variableName = "";
        this.variableValue = "";
        this.variableType = variableType;
        this.pathVariableManager = pathVariableManager;
        this.namesInUse = namesInUse;
        switch (this.operationMode) {
            case 1: {
                this.standardMessage = IDEWorkbenchMessages.PathVariableDialog_message_newVariable;
                break;
            }
            case 2: {
                this.standardMessage = IDEWorkbenchMessages.PathVariableDialog_message_existingVariable;
                break;
            }
            default: {
                this.standardMessage = IDEWorkbenchMessages.PathVariableDialog_message_editLocation;
            }
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        switch (this.operationMode) {
            case 1: {
                shell.setText(IDEWorkbenchMessages.PathVariableDialog_shellTitle_newVariable);
                break;
            }
            case 2: {
                shell.setText(IDEWorkbenchMessages.PathVariableDialog_shellTitle_existingVariable);
                break;
            }
            default: {
                shell.setText(IDEWorkbenchMessages.PathVariableDialog_shellTitle_editLocation);
            }
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        this.initializeDialogUnits((Control)parentComposite);
        Composite contents = this.createComposite(parentComposite);
        this.createWidgets(contents);
        if (this.type == 2) {
            this.locationEntered = true;
            this.nameEntered = true;
            this.validateVariableValue();
        }
        Dialog.applyDialogFont((Control)parentComposite);
        return contents;
    }

    private Composite createComposite(Composite parentComposite) {
        Composite contents = new Composite(parentComposite, 0);
        contents.setLayout((Layout)new GridLayout(3, false));
        contents.setLayoutData((Object)new GridData(1808));
        switch (this.operationMode) {
            case 1: {
                this.setTitle(IDEWorkbenchMessages.PathVariableDialog_dialogTitle_newVariable);
                break;
            }
            case 2: {
                this.setTitle(IDEWorkbenchMessages.PathVariableDialog_dialogTitle_existingVariable);
                break;
            }
            default: {
                this.setTitle(IDEWorkbenchMessages.PathVariableDialog_dialogTitle_editLinkLocation);
            }
        }
        this.setMessage(this.standardMessage);
        return contents;
    }

    private void createWidgets(Composite contents) {
        String nameLabelText = IDEWorkbenchMessages.PathVariableDialog_variableName;
        String valueLabelText = IDEWorkbenchMessages.PathVariableDialog_variableValue;
        String resolvedValueLabelText = IDEWorkbenchMessages.PathVariableDialog_variableResolvedValue;
        if (this.operationMode != 3) {
            this.variableNameLabel = new Label(contents, 16384);
            this.variableNameLabel.setText(nameLabelText);
            this.variableNameLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            this.variableNameField = new Text(contents, 2052);
            this.variableNameField.setText(this.variableName);
            this.variableNameField.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
            this.variableNameField.addModifyListener(event -> this.variableNameModified());
        }
        this.variableValueLabel = new Label(contents, 16384);
        this.variableValueLabel.setText(valueLabelText);
        this.variableValueLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.variableValueField = new Text(contents, 2052);
        this.variableValueField.setText(this.variableValue);
        this.variableValueField.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.variableValueField.addModifyListener(event -> this.variableValueModified());
        Composite buttonsComposite = new Composite(contents, 0);
        buttonsComposite.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false, 1, 1));
        GridLayout layout = new GridLayout(0, true);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        buttonsComposite.setLayout((Layout)layout);
        if ((this.variableType & 1) != 0) {
            ++layout.numColumns;
            this.fileButton = new Button(buttonsComposite, 8);
            this.fileButton.setText(IDEWorkbenchMessages.PathVariableDialog_file);
            this.fileButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            this.fileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PathVariableDialog.this.selectFile();
                }
            });
            this.setButtonLayoutData(this.fileButton);
        }
        if ((this.variableType & 2) != 0) {
            ++layout.numColumns;
            this.folderButton = new Button(buttonsComposite, 8);
            this.folderButton.setText(IDEWorkbenchMessages.PathVariableDialog_folder);
            this.folderButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            this.folderButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PathVariableDialog.this.selectFolder();
                }
            });
            this.setButtonLayoutData(this.folderButton);
        }
        if (this.currentResource != null) {
            ++layout.numColumns;
            this.variableButton = new Button(buttonsComposite, 8);
            this.variableButton.setText(IDEWorkbenchMessages.PathVariableDialog_variable);
            this.variableButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            this.variableButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PathVariableDialog.this.selectVariable();
                }
            });
            this.setButtonLayoutData(this.variableButton);
            this.variableResolvedValueLabel = new Label(contents, 16384);
            this.variableResolvedValueLabel.setText(resolvedValueLabelText);
            this.variableResolvedValueField = new Label(contents, 16396);
            this.variableResolvedValueField.setText(TextProcessor.process((String)this.getVariableResolvedValue()));
            this.variableResolvedValueField.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        }
    }

    private IPathVariableManager getPathVariableManager() {
        if (this.currentResource != null) {
            return this.currentResource.getPathVariableManager();
        }
        return ResourcesPlugin.getWorkspace().getPathVariableManager();
    }

    private String getVariableResolvedValue() {
        if (this.currentResource != null) {
            IPathVariableManager pathVariableManager2 = this.currentResource.getPathVariableManager();
            String[] variables = pathVariableManager2.getPathVariableNames();
            String internalFormat = pathVariableManager2.convertFromUserEditableFormat(this.variableValue, this.operationMode == 3);
            URI uri = URIUtil.toURI((IPath)Path.fromOSString((String)internalFormat));
            URI resolvedURI = pathVariableManager2.resolveURI(uri);
            String resolveValue = URIUtil.toPath((URI)resolvedURI).toOSString();
            String[] stringArray = pathVariableManager2.getPathVariableNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String newVariable = stringArray[n2];
                boolean found = false;
                String[] stringArray2 = variables;
                int n3 = variables.length;
                int n4 = 0;
                while (n4 < n3) {
                    String variable = stringArray2[n4];
                    if (variable.equals(newVariable)) {
                        found = true;
                        break;
                    }
                    ++n4;
                }
                if (!found) {
                    try {
                        pathVariableManager2.setURIValue(newVariable, null);
                    }
                    catch (CoreException coreException) {}
                }
                ++n2;
            }
            return resolveValue;
        }
        return this.variableValue;
    }

    private void variableNameModified() {
        this.variableName = this.variableNameField.getText();
        this.validationStatus = 0;
        this.okButton.setEnabled(this.validateVariableName() && this.validateVariableValue() && this.variableValue.length() != 0);
        this.nameEntered = true;
    }

    private void variableValueModified() {
        this.variableValue = this.variableValueField.getText().trim();
        this.validationStatus = 0;
        this.okButton.setEnabled(this.validateVariableValue() && this.validateVariableName());
        this.locationEntered = true;
        if (this.variableResolvedValueField != null) {
            this.variableResolvedValueField.setText(TextProcessor.process((String)this.getVariableResolvedValue()));
        }
    }

    private void selectFolder() {
        DirectoryDialog dialog = new DirectoryDialog(this.getShell(), 0x10000000);
        dialog.setText(IDEWorkbenchMessages.PathVariableDialog_selectFolderTitle);
        dialog.setMessage(IDEWorkbenchMessages.PathVariableDialog_selectFolderMessage);
        String filterPath = this.getVariableResolvedValue();
        dialog.setFilterPath(filterPath);
        String res = dialog.open();
        if (res != null) {
            this.variableValue = new Path(res).makeAbsolute().toOSString();
            this.variableValueField.setText(this.variableValue);
        }
    }

    private void selectFile() {
        FileDialog dialog = new FileDialog(this.getShell(), 0x10000000);
        dialog.setText(IDEWorkbenchMessages.PathVariableDialog_selectFileTitle);
        String filterPath = this.getVariableResolvedValue();
        dialog.setFilterPath(filterPath);
        String res = dialog.open();
        if (res != null) {
            this.variableValue = new Path(res).makeAbsolute().toOSString();
            this.variableValueField.setText(this.variableValue);
        }
    }

    private void selectVariable() {
        String[] variableNames;
        PathVariableSelectionDialog dialog = new PathVariableSelectionDialog(this.getShell(), 3);
        dialog.setResource(this.currentResource);
        if (dialog.open() == 0 && (variableNames = (String[])dialog.getResult()) != null && variableNames.length == 1) {
            String newValue = variableNames[0];
            IPath path = Path.fromOSString((String)newValue);
            if (this.operationMode != 3 && this.currentResource != null && !path.isAbsolute() && path.segmentCount() > 0) {
                path = this.buildVariableMacro(path);
                newValue = path.toOSString();
            }
            this.variableValue = newValue;
            this.variableValueField.setText(newValue);
        }
    }

    private IPath buildVariableMacro(IPath relativeSrcValue) {
        String variable = relativeSrcValue.segment(0);
        variable = "${" + variable + "}";
        return Path.fromOSString((String)variable).append(relativeSrcValue.removeFirstSegments(1));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.okButton.setEnabled(this.type == 2);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    private boolean validateVariableName() {
        boolean allowFinish = false;
        if (this.operationMode == 3) {
            return true;
        }
        if (this.validationStatus == 3) {
            return false;
        }
        String message = this.standardMessage;
        int newValidationStatus = 0;
        if (this.variableName.length() == 0) {
            if (this.nameEntered) {
                newValidationStatus = 3;
                message = IDEWorkbenchMessages.PathVariableDialog_variableNameEmptyMessage;
            }
        } else {
            IStatus status = this.pathVariableManager.validateName(this.variableName);
            if (!status.isOK()) {
                newValidationStatus = 3;
                message = status.getMessage();
            } else if (this.namesInUse.contains(this.variableName) && !this.variableName.equals(this.originalName)) {
                message = IDEWorkbenchMessages.PathVariableDialog_variableAlreadyExistsMessage;
                newValidationStatus = 3;
            } else {
                allowFinish = true;
            }
        }
        if (this.validationStatus == 0 || newValidationStatus == 3) {
            this.validationStatus = newValidationStatus;
            this.validationMessage = message;
        }
        if (!allowFinish) {
            this.setMessage(this.validationMessage, this.validationStatus);
        }
        return allowFinish;
    }

    private boolean validateVariableValue() {
        boolean allowFinish = false;
        if (this.validationStatus == 3) {
            return false;
        }
        String message = this.standardMessage;
        int newValidationStatus = 0;
        if (this.variableValue.length() == 0 && this.locationEntered) {
            newValidationStatus = 3;
            message = IDEWorkbenchMessages.PathVariableDialog_variableValueEmptyMessage;
        }
        if (this.currentResource != null) {
            allowFinish = true;
            String resolvedValue = this.getVariableResolvedValue();
            IPath resolvedPath = Path.fromOSString((String)resolvedValue);
            if (!IDEResourceInfoUtils.exists(resolvedPath.toOSString())) {
                message = IDEWorkbenchMessages.PathVariableDialog_pathDoesNotExistMessage;
                newValidationStatus = 2;
            } else {
                IFileInfo info = IDEResourceInfoUtils.getFileInfo(resolvedPath.toOSString());
                if (info.isDirectory() && (this.variableType & 2) == 0 || !info.isDirectory() && (this.variableType & 1) == 0) {
                    allowFinish = false;
                    newValidationStatus = 3;
                    message = (this.variableType & 2) != 0 ? IDEWorkbenchMessages.PathVariableDialog_variableValueIsWrongTypeFolder : IDEWorkbenchMessages.PathVariableDialog_variableValueIsWrongTypeFile;
                }
            }
        } else if (!Path.EMPTY.isValidPath(this.variableValue)) {
            message = IDEWorkbenchMessages.PathVariableDialog_variableValueInvalidMessage;
            newValidationStatus = 3;
        } else if (!new Path(this.variableValue).isAbsolute()) {
            message = IDEWorkbenchMessages.PathVariableDialog_pathIsRelativeMessage;
            newValidationStatus = 3;
        } else if (!IDEResourceInfoUtils.exists(this.variableValue)) {
            message = IDEWorkbenchMessages.PathVariableDialog_pathDoesNotExistMessage;
            newValidationStatus = 2;
            allowFinish = true;
        } else {
            allowFinish = true;
        }
        if (this.validationStatus == 0 || newValidationStatus > this.validationStatus) {
            this.validationStatus = newValidationStatus;
            this.validationMessage = message;
        }
        this.setMessage(this.validationMessage, this.validationStatus);
        return allowFinish;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public String getVariableValue() {
        if (this.currentResource != null) {
            return this.getPathVariableManager().convertFromUserEditableFormat(this.variableValue, this.operationMode == 3);
        }
        return this.variableValue;
    }

    public void setVariableName(String variableName) {
        this.originalName = this.variableName = variableName.trim();
    }

    public void setVariableValue(String variable) {
        String userEditableString;
        this.variableValue = userEditableString = this.getPathVariableManager().convertToUserEditableFormat(variable, this.operationMode == 3);
    }

    public void setResource(IResource resource) {
        this.currentResource = resource;
    }

    public void setLinkLocation(IPath location) {
        String userEditableString;
        this.variableValue = userEditableString = this.getPathVariableManager().convertToUserEditableFormat(location.toOSString(), this.operationMode == 3);
    }

    protected boolean isResizable() {
        return true;
    }
}

