/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.xtext.essentialocl.as2cs;

import org.apache.log4j.Logger;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.AnyType;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.InvalidType;
import org.eclipse.ocl.pivot.MapType;
import org.eclipse.ocl.pivot.Namespace;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.PrimitiveType;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.TupleType;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.VoidType;
import org.eclipse.ocl.pivot.util.Visitor;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.values.IntegerValue;
import org.eclipse.ocl.pivot.values.Unlimited;
import org.eclipse.ocl.pivot.values.UnlimitedNaturalValue;
import org.eclipse.ocl.xtext.base.as2cs.AS2CSConversion;
import org.eclipse.ocl.xtext.base.as2cs.BaseReferenceVisitor;
import org.eclipse.ocl.xtext.basecs.BaseCSFactory;
import org.eclipse.ocl.xtext.basecs.ElementCS;
import org.eclipse.ocl.xtext.basecs.MultiplicityCS;
import org.eclipse.ocl.xtext.basecs.MultiplicityStringCS;
import org.eclipse.ocl.xtext.basecs.PathNameCS;
import org.eclipse.ocl.xtext.basecs.PrimitiveTypeRefCS;
import org.eclipse.ocl.xtext.basecs.TuplePartCS;
import org.eclipse.ocl.xtext.basecs.TupleTypeCS;
import org.eclipse.ocl.xtext.basecs.TypedRefCS;
import org.eclipse.ocl.xtext.essentialoclcs.CollectionTypeCS;
import org.eclipse.ocl.xtext.essentialoclcs.EssentialOCLCSFactory;
import org.eclipse.ocl.xtext.essentialoclcs.MapTypeCS;
import org.eclipse.ocl.xtext.essentialoclcs.TypeNameExpCS;

public class EssentialOCLReferenceVisitor
extends BaseReferenceVisitor {
    public static final Logger logger = Logger.getLogger(EssentialOCLReferenceVisitor.class);
    protected final @Nullable Namespace scope;

    public EssentialOCLReferenceVisitor(@NonNull AS2CSConversion context, @Nullable Namespace scope) {
        super(context);
        this.scope = scope;
    }

    public ElementCS visitAnyType(@NonNull AnyType object) {
        PrimitiveTypeRefCS csRef = BaseCSFactory.eINSTANCE.createPrimitiveTypeRefCS();
        csRef.setPivot((Element)object);
        csRef.setName(object.getName());
        return csRef;
    }

    public ElementCS visitClass(@NonNull Class object) {
        return this.visitType((Type)object);
    }

    public ElementCS visitCollectionType(@NonNull CollectionType object) {
        CollectionTypeCS csRef = EssentialOCLCSFactory.eINSTANCE.createCollectionTypeCS();
        csRef.setPivot((Element)object);
        csRef.setName(object.getName());
        Type elementType = object.getElementType();
        if (elementType != null) {
            Package typePackage;
            TypedRefCS csElementType = (TypedRefCS)elementType.accept((Visitor)this);
            csRef.setOwnedType(csElementType);
            if (elementType instanceof Class && (typePackage = ((Class)elementType).getOwningPackage()) != null) {
                ((AS2CSConversion)this.context).importNamespace((Namespace)typePackage, null);
            }
        }
        IntegerValue lowerValue = object.getLowerValue();
        Number upper2 = object.getUpper();
        UnlimitedNaturalValue upperValue = object.getUpperValue();
        int upper = upper2 == null ? -1 : (upper2 instanceof Unlimited ? -1 : upperValue.intValue());
        boolean isNullFree = object.isIsNullFree();
        int lower = lowerValue.intValue();
        MultiplicityCS csMultiplicity = ((AS2CSConversion)this.context).createMultiplicityCS(lower, upper, isNullFree);
        csRef.setOwnedCollectionMultiplicity(csMultiplicity);
        return csRef;
    }

    public ElementCS visitInvalidType(@NonNull InvalidType object) {
        PrimitiveTypeRefCS csRef = BaseCSFactory.eINSTANCE.createPrimitiveTypeRefCS();
        csRef.setPivot((Element)object);
        csRef.setName(object.getName());
        return csRef;
    }

    public ElementCS visitMapType(@NonNull MapType object) {
        Package typePackage;
        MultiplicityStringCS csMultiplicity;
        MapTypeCS csRef = EssentialOCLCSFactory.eINSTANCE.createMapTypeCS();
        csRef.setPivot((Element)object);
        csRef.setName(object.getName());
        Type keyType = PivotUtil.getKeyType((MapType)object);
        Type valueType = PivotUtil.getValueType((MapType)object);
        TypedRefCS csKeyType = (TypedRefCS)keyType.accept((Visitor)this);
        TypedRefCS csValueType = (TypedRefCS)valueType.accept((Visitor)this);
        if (!object.isKeysAreNullFree()) {
            csMultiplicity = BaseCSFactory.eINSTANCE.createMultiplicityStringCS();
            csMultiplicity.setStringBounds("?");
            csKeyType.setOwnedMultiplicity((MultiplicityCS)csMultiplicity);
        }
        if (!object.isValuesAreNullFree()) {
            csMultiplicity = BaseCSFactory.eINSTANCE.createMultiplicityStringCS();
            csMultiplicity.setStringBounds("?");
            csValueType.setOwnedMultiplicity((MultiplicityCS)csMultiplicity);
        }
        csRef.setOwnedKeyType(csKeyType);
        csRef.setOwnedValueType(csValueType);
        if (keyType instanceof Class && (typePackage = ((Class)keyType).getOwningPackage()) != null) {
            ((AS2CSConversion)this.context).importNamespace((Namespace)typePackage, null);
        }
        if (valueType instanceof Class && (typePackage = ((Class)valueType).getOwningPackage()) != null) {
            ((AS2CSConversion)this.context).importNamespace((Namespace)typePackage, null);
        }
        return csRef;
    }

    public ElementCS visitPrimitiveType(@NonNull PrimitiveType object) {
        PrimitiveTypeRefCS csRef = BaseCSFactory.eINSTANCE.createPrimitiveTypeRefCS();
        csRef.setPivot((Element)object);
        csRef.setName(object.getName());
        return csRef;
    }

    public ElementCS visitTupleType(@NonNull TupleType object) {
        TupleTypeCS csRef = BaseCSFactory.eINSTANCE.createTupleTypeCS();
        csRef.setPivot((Element)object);
        csRef.setName(object.getName());
        for (Property asTuplePart : PivotUtil.getOwnedProperties((Class)object)) {
            TuplePartCS csPart = BaseCSFactory.eINSTANCE.createTuplePartCS();
            csPart.setPivot((Element)asTuplePart);
            csPart.setName(asTuplePart.getName());
            csPart.setOwnedType((TypedRefCS)asTuplePart.getType().accept((Visitor)this));
            csRef.getOwnedParts().add((Object)csPart);
        }
        return csRef;
    }

    public ElementCS visitType(@NonNull Type object) {
        Package typePackage;
        TypeNameExpCS csRef = EssentialOCLCSFactory.eINSTANCE.createTypeNameExpCS();
        csRef.setPivot((Element)object);
        PathNameCS csPathName = csRef.getOwnedPathName();
        if (csPathName == null) {
            csPathName = BaseCSFactory.eINSTANCE.createPathNameCS();
            assert (csPathName != null);
            csRef.setOwnedPathName(csPathName);
        }
        ((AS2CSConversion)this.context).refreshPathName(csPathName, (Element)object, this.scope);
        if (object instanceof Class && (typePackage = ((Class)object).getOwningPackage()) != null) {
            ((AS2CSConversion)this.context).importNamespace((Namespace)typePackage, null);
        }
        return csRef;
    }

    public ElementCS visitVoidType(@NonNull VoidType object) {
        PrimitiveTypeRefCS csRef = BaseCSFactory.eINSTANCE.createPrimitiveTypeRefCS();
        csRef.setPivot((Element)object);
        csRef.setName(object.getName());
        return csRef;
    }
}

