/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.template.java;

import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.template.java.ICompilationUnitContext;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;

public class CompilationUnitContext
extends DocumentTemplateContext
implements ICompilationUnitContext {
    private final ICompilationUnit fCompilationUnit;
    protected boolean fForceEvaluation;
    private final boolean fIsManaged;

    public CompilationUnitContext(TemplateContextType type, IDocument document, int completionOffset, int completionLength, ICompilationUnit compilationUnit) {
        super(type, document, completionOffset, completionLength);
        this.fCompilationUnit = compilationUnit;
        this.fIsManaged = false;
    }

    public CompilationUnitContext(TemplateContextType type, IDocument document, Position completionPosition, ICompilationUnit compilationUnit) {
        super(type, document, completionPosition);
        this.fCompilationUnit = compilationUnit;
        this.fIsManaged = true;
    }

    @Override
    public final ICompilationUnit getCompilationUnit() {
        return this.fCompilationUnit;
    }

    @Override
    public IJavaElement findEnclosingElement(int elementType) {
        if (this.fCompilationUnit == null) {
            return null;
        }
        try {
            IJavaElement element = this.fCompilationUnit.getElementAt(this.getStart());
            if (element == null) {
                element = this.fCompilationUnit;
            }
            return element.getAncestor(elementType);
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    public void setForceEvaluation(boolean evaluate) {
        this.fForceEvaluation = evaluate;
    }

    public boolean isForceEvaluation() {
        return this.fForceEvaluation;
    }

    public boolean isManaged() {
        return this.fIsManaged;
    }

    public IJavaProject getJavaProject() {
        ICompilationUnit compilationUnit = this.getCompilationUnit();
        IJavaProject project = compilationUnit == null ? null : compilationUnit.getJavaProject();
        return project;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IProject.class) {
            return adapter.cast(this.getJavaProject().getProject());
        }
        return (T)super.getAdapter(adapter);
    }
}

