/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.manipulation.CleanUpRequirementsCore;
import org.eclipse.jdt.core.manipulation.ICleanUpFixCore;
import org.eclipse.jdt.internal.corext.fix.UnusedCodeFixCore;
import org.eclipse.jdt.internal.ui.fix.AbstractMultiFixCore;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.internal.ui.text.correction.IProblemLocationCore;

public class UnnecessaryCodeCleanUpCore
extends AbstractMultiFixCore {
    public UnnecessaryCodeCleanUpCore(Map<String, String> options) {
        super(options);
    }

    public UnnecessaryCodeCleanUpCore() {
    }

    @Override
    public CleanUpRequirementsCore getRequirementsCore() {
        boolean requireAST = this.isEnabled("cleanup.remove_unnecessary_casts");
        Map<String, String> requiredOptions = requireAST ? this.getRequiredOptions() : null;
        return new CleanUpRequirementsCore(requireAST, false, false, requiredOptions);
    }

    @Override
    public ICleanUpFixCore createFix(CompilationUnit compilationUnit) throws CoreException {
        return UnusedCodeFixCore.createCleanUp(compilationUnit, false, false, false, false, false, false, this.isEnabled("cleanup.remove_unnecessary_casts"));
    }

    @Override
    public ICleanUpFixCore createFix(CompilationUnit compilationUnit, IProblemLocationCore[] problems) throws CoreException {
        return UnusedCodeFixCore.createCleanUp(compilationUnit, problems, false, false, false, false, false, false, this.isEnabled("cleanup.remove_unnecessary_casts"));
    }

    private Map<String, String> getRequiredOptions() {
        Hashtable<String, String> result = new Hashtable<String, String>();
        if (this.isEnabled("cleanup.remove_unnecessary_casts")) {
            result.put("org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck", "warning");
        }
        return result;
    }

    @Override
    public String[] getStepDescriptions() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.isEnabled("cleanup.remove_unnecessary_casts")) {
            result.add(MultiFixMessages.UnusedCodeCleanUp_RemoveUnusedCasts_description);
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public String getPreview() {
        StringBuilder buf = new StringBuilder();
        if (this.isEnabled("cleanup.remove_unnecessary_casts")) {
            buf.append("Boolean b= Boolean.TRUE;\n");
        } else {
            buf.append("Boolean b= (Boolean) Boolean.TRUE;\n");
        }
        return buf.toString();
    }

    @Override
    public boolean canFix(ICompilationUnit compilationUnit, IProblemLocationCore problem) {
        if (problem.getProblemId() == 553648309) {
            return this.isEnabled("cleanup.remove_unnecessary_casts");
        }
        return false;
    }

    @Override
    public int computeNumberOfFixes(CompilationUnit compilationUnit) {
        int result = 0;
        IProblem[] problems = compilationUnit.getProblems();
        if (this.isEnabled("cleanup.remove_unnecessary_casts")) {
            result += UnnecessaryCodeCleanUpCore.getNumberOfProblems(problems, 553648309);
        }
        return result;
    }
}

