/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.core;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.internal.core.IRepositoryProviderListener;

public class RepositoryProviderManager
implements IRepositoryProviderListener {
    private static RepositoryProviderManager instance;
    private ListenerList<IRepositoryProviderListener> listeners = new ListenerList();

    public static synchronized RepositoryProviderManager getInstance() {
        if (instance == null) {
            instance = new RepositoryProviderManager();
        }
        return instance;
    }

    @Override
    public void providerMapped(RepositoryProvider provider) {
        Object[] allListeners;
        Object[] objectArray = allListeners = this.listeners.getListeners();
        int n = allListeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object l = objectArray[n2];
            IRepositoryProviderListener listener = (IRepositoryProviderListener)l;
            listener.providerMapped(provider);
            ++n2;
        }
    }

    @Override
    public void providerUnmapped(IProject project) {
        Object[] allListeners;
        Object[] objectArray = allListeners = this.listeners.getListeners();
        int n = allListeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object l = objectArray[n2];
            IRepositoryProviderListener listener = (IRepositoryProviderListener)l;
            listener.providerUnmapped(project);
            ++n2;
        }
    }

    public void addListener(IRepositoryProviderListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeListener(IRepositoryProviderListener listener) {
        this.listeners.remove((Object)listener);
    }
}

