/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.sync.internal;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.papyrus.infra.sync.Activator;
import org.eclipse.papyrus.infra.sync.service.AbstractSyncTrigger;
import org.eclipse.papyrus.infra.sync.service.ISyncAction;
import org.eclipse.papyrus.infra.sync.service.ISyncService;
import org.eclipse.papyrus.infra.sync.service.ISyncTrigger;

public class SyncTriggerRegistry {
    private static final String EXT_PT = "org.eclipse.papyrus.infra.sync.triggers";
    private static final String E_TRIGGER = "syncTrigger";
    private static final String E_ENABLEMENT = "enablement";
    private static final String A_CLASS = "class";
    private static SyncTriggerRegistry INSTANCE = new SyncTriggerRegistry();
    private final List<ISyncTrigger> syncTriggers = Lists.newArrayList();

    private SyncTriggerRegistry() {
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(EXT_PT);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement next = iConfigurationElementArray[n2];
            if (E_TRIGGER.equals(next.getName())) {
                this.syncTriggers.add(new SyncTriggerDescriptor(next));
            }
            ++n2;
        }
    }

    public static SyncTriggerRegistry getInstance() {
        return INSTANCE;
    }

    public Iterable<ISyncTrigger> getSyncTriggers(final Object object) {
        return Iterables.filter(this.syncTriggers, (Predicate)new Predicate<ISyncTrigger>(){

            public boolean apply(ISyncTrigger input) {
                return input.isTriggeredOn(object);
            }
        });
    }

    private static class NullSyncTrigger
    extends AbstractSyncTrigger {
        static final NullSyncTrigger INSTANCE = new NullSyncTrigger();

        private NullSyncTrigger() {
        }

        @Override
        public boolean isTriggeredOn(Object object) {
            return false;
        }

        @Override
        public ISyncAction trigger(ISyncService syncService, Object object) {
            return SyncNoop.INSTANCE;
        }
    }

    private static class SyncNoop
    implements ISyncAction {
        static final SyncNoop INSTANCE = new SyncNoop();

        private SyncNoop() {
        }

        @Override
        public IStatus perform(ISyncService syncService, Object object) {
            return Status.OK_STATUS;
        }
    }

    static class SyncTriggerDescriptor
    implements ISyncTrigger {
        private final IConfigurationElement config;
        private Expression enablement;
        private ISyncTrigger resolved;

        SyncTriggerDescriptor(IConfigurationElement config) {
            this.config = config;
            this.enablement = this.getEnablement(config);
        }

        private Expression getEnablement(IConfigurationElement config) {
            Expression result = null;
            IConfigurationElement[] enablements = config.getChildren(SyncTriggerRegistry.E_ENABLEMENT);
            if (enablements.length > 0) {
                try {
                    result = ExpressionConverter.getDefault().perform(enablements[0]);
                }
                catch (CoreException e) {
                    result = Expression.FALSE;
                    Activator.log.log(e.getStatus());
                }
            }
            return result;
        }

        @Override
        public boolean isTriggeredOn(Object object) {
            try {
                return this.enablement == null ? this.resolve().isTriggeredOn(object) : EvaluationResult.TRUE.equals(this.enablement.evaluate((IEvaluationContext)new EvaluationContext(null, object)));
            }
            catch (CoreException e) {
                this.enablement = Expression.FALSE;
                Activator.log.error("Sync trigger enablement expression failed. The trigger is disabled: " + this.config.getContributor().getName(), (Throwable)e);
                return false;
            }
        }

        ISyncTrigger resolve() {
            if (this.resolved == null) {
                try {
                    this.resolved = (ISyncTrigger)this.config.createExecutableExtension(SyncTriggerRegistry.A_CLASS);
                }
                catch (CoreException e) {
                    this.resolved = NullSyncTrigger.INSTANCE;
                    Activator.log.error("Failed to create sync trigger. The trigger is disabled: " + this.config.getContributor().getName(), (Throwable)e);
                }
                catch (ClassCastException e) {
                    this.resolved = NullSyncTrigger.INSTANCE;
                    Activator.log.error("Sync trigger does not implement ISyncTrigger interface. The trigger is disabled: " + this.config.getContributor().getName(), (Throwable)e);
                }
            }
            return this.resolved;
        }

        @Override
        public ISyncAction trigger(ISyncService syncService, Object object) {
            return this.resolve().trigger(syncService, object);
        }
    }
}

