/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.strategy;

import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.papyrus.infra.gmfdiag.common.strategy.IStrategy;
import org.eclipse.papyrus.infra.gmfdiag.common.strategy.IStrategyManager;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class StrategyLabelProvider
extends ColumnLabelProvider {
    IStrategyManager instance;

    public StrategyLabelProvider(IStrategyManager abstractStrategyManager) {
        this.instance = abstractStrategyManager;
    }

    public String getText(Object element) {
        if (element instanceof IStrategy) {
            return ((IStrategy)element).getLabel();
        }
        return super.getText(element);
    }

    public Image getImage(Object element) {
        if (element instanceof IStrategy) {
            return ((IStrategy)element).getImage();
        }
        return super.getImage(element);
    }

    public String getToolTipText(Object element) {
        if (element instanceof IStrategy) {
            return ((IStrategy)element).getDescription();
        }
        return null;
    }

    public void update(ViewerCell cell) {
        Object element = cell.getElement();
        if (element instanceof IStrategy) {
            IStrategy strategy = (IStrategy)element;
            if (cell.getColumnIndex() == 1) {
                cell.setImage(strategy.getImage());
                int foreground = this.instance.isActive(strategy) ? 2 : 15;
                cell.setForeground(Display.getCurrent().getSystemColor(foreground));
                cell.setText(strategy.getLabel());
            }
        }
    }
}

